/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.version.DeleteVersionValidator;
import com.atlassian.jira.bc.project.version.SwapVersionAction;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionBuilderImpl;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequests;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVersionService
implements VersionService {
    private static final int MAX_VERSION_NAME_LENGTH = 255;
    private static final Logger log = LoggerFactory.getLogger(DefaultVersionService.class);
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final SearchProvider searchProvider;
    private final I18nHelper.BeanFactory i18n;
    private final DateFieldFormat dateFieldFormat;
    private final ProjectManager projectManager;

    public DefaultVersionService(VersionManager versionManager, PermissionManager permissionManager, IssueManager issueManager, SearchProvider searchProvider, I18nHelper.BeanFactory i18n, DateFieldFormat dateFieldFormat, ProjectManager projectManager) {
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.i18n = i18n;
        this.searchProvider = searchProvider;
        this.dateFieldFormat = dateFieldFormat;
        this.projectManager = projectManager;
    }

    public VersionService.VersionResult getVersionById(@Nullable ApplicationUser user, Project project, Long versionId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"versionId", (Object)versionId);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", String.valueOf(versionId)));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return new VersionService.VersionResult((ErrorCollection)errors, version);
    }

    public VersionService.VersionResult getVersionById(ApplicationUser user, Long versionId) {
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            I18nHelper i18nBean = this.getI18nBean(user);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", String.valueOf(versionId)));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return this.getVersionById(user, version.getProject(), versionId);
    }

    @Nonnull
    public VersionService.VersionResult getVersionByProjectAndName(@Nullable ApplicationUser user, @Nonnull Project project, @Nonnull String versionName) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notBlank((String)"versionName", (String)versionName);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(project.getId(), versionName);
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist", versionName, project.getName()));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return new VersionService.VersionResult((ErrorCollection)errors, version);
    }

    @Nonnull
    public VersionService.VersionsResult getVersionsByProject(@Nullable ApplicationUser user, @Nonnull Project project) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"project", (Object)project);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionsResult((ErrorCollection)errors, Collections.emptyList());
        }
        return new VersionService.VersionsResult((ErrorCollection)errors, (Collection)this.versionManager.getVersions(project.getId()));
    }

    @Nonnull
    public ServiceOutcome<Page<Version>> getVersionsByProject(@Nullable ApplicationUser user, @Nonnull Project project, @Nonnull PageRequest pageRequest) {
        return this.getVersionsByProject(user, project, pageRequest, (Option<OrderByRequest<VersionService.VersionExtractableField>>)Option.none());
    }

    @Nonnull
    public ServiceOutcome<Page<Version>> getVersionsByProject(@Nullable ApplicationUser user, @Nonnull Project project, @Nonnull PageRequest pageRequest, @Nullable OrderByRequest<VersionService.VersionExtractableField> orderBy) {
        return this.getVersionsByProject(user, project, pageRequest, (Option<OrderByRequest<VersionService.VersionExtractableField>>)Option.option(orderBy));
    }

    public ServiceOutcome<Version> setVersionDetails(ApplicationUser user, Version version, String name, String description) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.hasEditPermission(user, version.getProject())) {
            VersionBuilder versionBuilder = this.newVersionBuilder(version).name(name).description(description);
            VersionService.VersionBuilderValidationResult versionBuilderValidationResult = this.validateUpdate(user, versionBuilder);
            if (!versionBuilderValidationResult.isValid()) {
                return ServiceOutcomeImpl.from(versionBuilderValidationResult.getErrorCollection(), null);
            }
            return this.update(user, versionBuilderValidationResult);
        }
        String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.could.not.edit", version.getName());
        errors.addErrorMessage(message, ErrorCollection.Reason.FORBIDDEN);
        return new ServiceOutcomeImpl<Version>((ErrorCollection)errors);
    }

    public ErrorCollection validateVersionDetails(ApplicationUser user, Version version, String name, String description) {
        VersionBuilder versionBuilder = this.newVersionBuilder(version).name(name).description(description);
        VersionService.VersionBuilderValidationResult versionBuilderValidationResult = this.validateUpdate(user, versionBuilder);
        return versionBuilderValidationResult.getErrorCollection();
    }

    public ServiceOutcome<Version> setReleaseDate(ApplicationUser user, Version version, Date releaseDate) {
        VersionBuilder versionBuilder = this.newVersionBuilder(version).releaseDate(releaseDate);
        VersionService.VersionBuilderValidationResult versionBuilderValidationResult = this.validateUpdate(user, versionBuilder);
        if (!versionBuilderValidationResult.isValid()) {
            return ServiceOutcomeImpl.from(versionBuilderValidationResult.getErrorCollection(), null);
        }
        return this.update(user, versionBuilderValidationResult);
    }

    public ServiceOutcome<Version> validateReleaseDate(ApplicationUser user, Version version, String releaseDate) {
        return this.setReleaseDate(user, version, (Either<String, Date>)Either.left((Object)releaseDate));
    }

    public ServiceOutcome<Version> setReleaseDate(ApplicationUser user, Version version, String releaseDate) {
        return this.setReleaseDate(user, version, (Either<String, Date>)Either.left((Object)releaseDate));
    }

    public VersionService.ValidationResult validateDelete(JiraServiceContext context, Long versionId, VersionService.VersionAction affectsAction, VersionService.VersionAction fixAction) {
        log.debug("Validating delete of version with id " + versionId);
        DeleteVersionValidator validator = new DeleteVersionValidator(context, this.versionManager, this.permissionManager);
        return validator.validate(versionId, affectsAction, fixAction);
    }

    public void delete(JiraServiceContext context, VersionService.ValidationResult result) {
        if (!result.isValid()) {
            throw new IllegalArgumentException("Result from validation is invalid");
        }
        Version version = result.getVersionToDelete();
        log.debug("Deleting version with id " + version.getId());
        switch (result.getAction()) {
            case DELETE: {
                this.versionManager.deleteAndRemoveFromIssues(context.getLoggedInApplicationUser(), version);
                break;
            }
            case MERGE: {
                this.versionManager.merge(context.getLoggedInApplicationUser(), version, (Version)result.getVersionToMergeTo().get());
                break;
            }
            case DELETE_AND_REPLACE: {
                this.versionManager.deleteVersion(context.getLoggedInApplicationUser(), version, Option.option((Object)result.getAffectsSwapVersion()), Option.option((Object)result.getFixSwapVersion()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized action: " + result.getAction());
            }
        }
    }

    public VersionService.ValidationResult validateMerge(JiraServiceContext context, Long versionId, Long swapVersionId) {
        SwapVersionAction swapVersionAction = new SwapVersionAction(swapVersionId);
        return this.validateDelete(context, versionId, (VersionService.VersionAction)swapVersionAction, (VersionService.VersionAction)swapVersionAction);
    }

    public void merge(JiraServiceContext context, VersionService.ValidationResult result) {
        this.delete(context, result);
    }

    public VersionService.CreateVersionValidationResult validateCreateVersion(ApplicationUser user, Project project, String versionName, String releaseDateStr, String description, Long scheduleAfterVersion) {
        ValidateResult result = this.validateCreateParameters(user, project, versionName, null, releaseDateStr);
        if (!result.isValid()) {
            return new VersionService.CreateVersionValidationResult(result.errors, result.reasons);
        }
        VersionBuilder versionBuilder = this.newVersionBuilder().projectId(project.getId()).name(versionName).description(description).releaseDate(result.getParsedReleaseDate()).scheduleAfterVersion(scheduleAfterVersion);
        return this.newCreateResult(this.validateCreate(user, versionBuilder));
    }

    public VersionService.CreateVersionValidationResult validateCreateVersion(ApplicationUser user, Project project, String versionName, Date releaseDate, String description, Long scheduleAfterVersion) {
        VersionBuilder versionBuilder = this.newVersionBuilder().projectId(project.getId()).name(versionName).description(description).releaseDate(releaseDate).scheduleAfterVersion(scheduleAfterVersion);
        return this.newCreateResult(this.validateCreate(user, versionBuilder));
    }

    public Version createVersion(ApplicationUser user, VersionService.CreateVersionValidationResult request) {
        VersionBuilder versionBuilder = this.newVersionBuilder().projectId(request.getProject().getId()).name(request.getVersionName()).description(request.getDescription()).startDate(request.getStartDate()).releaseDate(request.getReleaseDate()).scheduleAfterVersion(request.getScheduleAfterVersion());
        VersionService.VersionBuilderValidationResult versionBuilderValidationResult = this.validateCreate(user, versionBuilder);
        if (!versionBuilderValidationResult.isValid()) {
            throw new IllegalArgumentException("Should not have received a create version request which was not valid");
        }
        ServiceOutcome<Version> outcome = this.create(user, versionBuilderValidationResult);
        if (!outcome.isValid()) {
            throw new IllegalArgumentException("Attempted to create a version and failed");
        }
        return (Version)outcome.getReturnedValue();
    }

    @Nonnull
    public VersionService.ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser user, @Nonnull Version version, @Nullable Date releaseDate) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        if (version.isReleased()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.release.already.released"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors, version, releaseDate);
    }

    @Nonnull
    public VersionService.ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser user, @Nonnull Version version, @Nullable String releaseDate) {
        try {
            return this.validateReleaseVersion(user, version, this.parseDate(user, DateField.RELEASE_DATE, releaseDate));
        }
        catch (DateParseException e) {
            return new VersionService.ReleaseVersionValidationResult(e.parseErrors);
        }
    }

    @Nonnull
    public VersionService.ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser user, @Nonnull Version version, @Nullable Date releaseDate) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        if (!version.isReleased()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.release.not.released"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors, version, releaseDate);
    }

    @Nonnull
    public VersionService.ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser user, @Nonnull Version version, @Nonnull String releaseDate) {
        try {
            return this.validateUnreleaseVersion(user, version, this.parseDate(user, DateField.RELEASE_DATE, releaseDate));
        }
        catch (DateParseException e) {
            return new VersionService.ReleaseVersionValidationResult(e.parseErrors);
        }
    }

    @Nonnull
    public VersionService.ArchiveVersionValidationResult validateArchiveVersion(@Nullable ApplicationUser user, @Nonnull Version version) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (version.isArchived()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.archive.already.archived"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors, version);
    }

    @Nonnull
    public VersionService.ArchiveVersionValidationResult validateUnarchiveVersion(@Nullable ApplicationUser user, @Nonnull Version version) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        if (!version.isArchived()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.archive.not.archived"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors, version);
    }

    public Version releaseVersion(VersionService.ReleaseVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not release a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not release a version with an invalid validation result.");
        }
        VersionBuilderImpl versionParams = new VersionBuilderImpl(result.getVersion());
        versionParams.releaseDate(result.getReleaseDate());
        versionParams.released(true);
        Version version = versionParams.build();
        this.versionManager.releaseVersion(version, true);
        return this.versionManager.getVersion(version.getId());
    }

    public void moveUnreleasedToNewVersion(@Nullable ApplicationUser directoryUser, @Nonnull Version currentVersion, @Nonnull Version newVersion) {
        List<Issue> issues = this.getUnresolvedIssues(directoryUser, currentVersion);
        if (!issues.isEmpty()) {
            for (Issue issue : issues) {
                MutableIssue mutableIssue = this.issueManager.getIssueObject(issue.getId());
                Collection versions = mutableIssue.getFixVersions();
                versions.remove(currentVersion);
                versions.add(newVersion);
                mutableIssue.setFixVersions(versions);
                this.issueManager.updateIssue(directoryUser, mutableIssue, EventDispatchOption.ISSUE_UPDATED, true);
            }
        }
    }

    public Version unreleaseVersion(VersionService.ReleaseVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not unrelease a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not unrelease a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        this.versionManager.releaseVersion(version, false);
        return this.versionManager.getVersion(version.getId());
    }

    public Version archiveVersion(VersionService.ArchiveVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not archive a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not archive a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        this.versionManager.archiveVersion(version, true);
        return this.versionManager.getVersion(version.getId());
    }

    public Version unarchiveVersion(VersionService.ArchiveVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not unarchive a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not unarchive a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        this.versionManager.archiveVersion(version, false);
        return this.versionManager.getVersion(version.getId());
    }

    @Nonnull
    public VersionService.MoveVersionValidationResult validateMoveToStartVersionSequence(@Nullable ApplicationUser user, long versionId) {
        return this.validateMove(user, versionId);
    }

    @Nonnull
    public VersionService.MoveVersionValidationResult validateIncreaseVersionSequence(@Nullable ApplicationUser user, long versionId) {
        return this.validateMove(user, versionId);
    }

    @Nonnull
    public VersionService.MoveVersionValidationResult validateDecreaseVersionSequence(@Nullable ApplicationUser user, long versionId) {
        return this.validateMove(user, versionId);
    }

    @Nonnull
    public VersionService.MoveVersionValidationResult validateMoveToEndVersionSequence(@Nullable ApplicationUser user, long versionId) {
        return this.validateMove(user, versionId);
    }

    @Nonnull
    public VersionService.MoveVersionValidationResult validateMoveVersionAfter(@Nullable ApplicationUser user, long versionId, @Nonnull Long scheduleAfterVersionId) {
        VersionService.MoveVersionValidationResult moveVersionValidationResult = this.validateMove(user, versionId);
        if (!moveVersionValidationResult.getErrorCollection().hasAnyErrors()) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            I18nHelper i18nBean = this.getI18nBean(user);
            Version version = moveVersionValidationResult.getVersion();
            Version scheduleAfterVersion = this.versionManager.getVersion(scheduleAfterVersionId);
            if (scheduleAfterVersion == null || !scheduleAfterVersion.getProject().equals(version.getProject())) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id.for.project", scheduleAfterVersionId.toString(), version.getProject().getKey()));
                moveVersionValidationResult = new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.SCHEDULE_AFTER_VERSION_NOT_FOUND));
            } else {
                moveVersionValidationResult = new VersionService.MoveVersionValidationResult((ErrorCollection)new SimpleErrorCollection(), version, scheduleAfterVersionId);
            }
        }
        return moveVersionValidationResult;
    }

    public void moveToStartVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveToStartVersionSequence(moveVersionValidationResult.getVersion());
    }

    public void increaseVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.increaseVersionSequence(moveVersionValidationResult.getVersion());
    }

    public void decreaseVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.decreaseVersionSequence(moveVersionValidationResult.getVersion());
    }

    public void moveToEndVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveToEndVersionSequence(moveVersionValidationResult.getVersion());
    }

    public void moveVersionAfter(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveVersionAfter(moveVersionValidationResult.getVersion(), moveVersionValidationResult.getScheduleAfterVersion());
    }

    public boolean isOverdue(Version version) {
        return this.versionManager.isVersionOverDue((Version)Assertions.notNull((String)"version", (Object)version));
    }

    public long getFixIssuesCount(Version version) {
        return this.versionManager.getIssueIdsWithFixVersion(version).size();
    }

    public long getAffectsIssuesCount(Version version) {
        return this.versionManager.getIssueIdsWithAffectsVersion(version).size();
    }

    public long getUnresolvedIssuesCount(@Nullable ApplicationUser user, @Nonnull Version version) {
        return this.getUnresolvedIssues(user, version).size();
    }

    @Nonnull
    public VersionService.VersionBuilderValidationResult validateCreate(@Nullable ApplicationUser user, @Nonnull VersionBuilder versionBuilder) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Long projectId = ((VersionBuilderImpl)versionBuilder).getProjectId();
        if (projectId == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.specify.valid.project"));
            return new VersionService.VersionBuilderValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.BAD_PROJECT));
        }
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.specify.valid.project"));
            return new VersionService.VersionBuilderValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.BAD_PROJECT));
        }
        if (!this.hasCreatePermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new VersionService.VersionBuilderValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN));
        }
        return this.validateUpdate(i18nBean, (ErrorCollection)errors, versionBuilder);
    }

    @Nonnull
    public ServiceOutcome<Version> create(@Nullable ApplicationUser user, @Nonnull VersionService.VersionBuilderValidationResult validationResult) {
        this.check(validationResult);
        try {
            VersionBuilderImpl builder = (VersionBuilderImpl)validationResult.getResult();
            Version version = this.versionManager.createVersion(builder.getName(), builder.getStartDate(), builder.getReleaseDate(), builder.getDescription(), builder.getProjectId(), builder.getScheduleAfterVersion(), builder.isReleased());
            return ServiceOutcomeImpl.ok(version);
        }
        catch (CreateException ex) {
            log.error("Unable to create version", (Throwable)ex);
            return ServiceOutcomeImpl.error("Unable to create version: " + ex.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    public VersionBuilder newVersionBuilder(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Version object is required when updating version");
        }
        return new VersionBuilderImpl(version);
    }

    public VersionBuilder newVersionBuilder() {
        return new VersionBuilderImpl();
    }

    @Nonnull
    public VersionService.VersionBuilderValidationResult validateUpdate(@Nullable ApplicationUser user, @Nonnull VersionBuilder versionBuilder) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (((VersionBuilderImpl)versionBuilder).getVersion() == null) {
            throw new IllegalArgumentException("Version object is required when updating version");
        }
        Project project = this.projectManager.getProjectObj(((VersionBuilderImpl)versionBuilder).getProjectId());
        if (!this.hasCreatePermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new VersionService.VersionBuilderValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN));
        }
        return this.validateUpdate(i18nBean, (ErrorCollection)errors, versionBuilder);
    }

    public ServiceOutcome<Version> update(ApplicationUser user, VersionService.VersionBuilderValidationResult validationResult) {
        this.check(validationResult);
        VersionBuilder versionBuilder = (VersionBuilder)validationResult.getResult();
        Version version = versionBuilder.build();
        return ServiceOutcomeImpl.ok(this.versionManager.update(version));
    }

    public ServiceOutcome<Page<Version>> getVersionsByProject(@Nullable ApplicationUser user, @Nonnull Project project, @Nonnull PageRequest pageRequest, Option<OrderByRequest<VersionService.VersionExtractableField>> orderBy) {
        final VersionService.VersionsResult versionsByProject = this.getVersionsByProject(user, project);
        if (!versionsByProject.isValid()) {
            return ServiceOutcomeImpl.from(versionsByProject.getErrorCollection());
        }
        Collection sorted = (Collection)orderBy.fold(() -> Lists.newArrayList((Iterable)versionsByProject.getVersions()), (Function)new Function<OrderByRequest<VersionService.VersionExtractableField>, Collection<Version>>(){

            public Collection<Version> apply(OrderByRequest<VersionService.VersionExtractableField> orderBy) {
                return OrderByRequests.toOrdering(orderBy).sortedCopy((Iterable)versionsByProject.getVersions());
            }
        });
        return ServiceOutcomeImpl.ok(Pages.toPage((Iterable)sorted, (PageRequest)pageRequest));
    }

    @Nullable
    protected Date parseDate(@Nullable ApplicationUser user, DateField field, String date) throws DateParseException {
        if (StringUtils.isEmpty((String)date)) {
            return null;
        }
        try {
            return this.dateFieldFormat.parseDatePicker(date);
        }
        catch (IllegalArgumentException e) {
            I18nHelper i18n = this.getI18nBean(user);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addError(field.name, i18n.getText("admin.errors.incorrect.date.format", this.dateFieldFormat.getFormatHint()));
            throw new DateParseException((ErrorCollection)errors);
        }
    }

    protected ServiceOutcome<Void> validateStartReleaseDates(ApplicationUser user, DateField field, Date startDate, Date releaseDate) {
        if (startDate != null && releaseDate != null && startDate.after(releaseDate)) {
            I18nHelper i18n = this.getI18nBean(user);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addError(field.name, i18n.getText("admin.errors.version.start.release.date.order"));
            return ServiceOutcomeImpl.from((ErrorCollection)errors, null);
        }
        return ServiceOutcomeImpl.ok(null);
    }

    I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18n.getInstance(user);
    }

    ValidateResult validateCreateParameters(ApplicationUser appUser, Project project, String versionName, String startDateStr, String releaseDateStr) {
        I18nHelper i18nBean = this.getI18nBean(appUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (project == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.specify.valid.project"));
            return new ValidateResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.BAD_PROJECT));
        }
        if (!this.permissionManager.hasPermission(0, appUser) && !this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, appUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new ValidateResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN));
        }
        EnumSet<VersionService.CreateVersionValidationResult.Reason> reasons = EnumSet.noneOf(VersionService.CreateVersionValidationResult.Reason.class);
        if (StringUtils.isEmpty((String)versionName)) {
            errors.addError("name", i18nBean.getText("admin.errors.enter.valid.version.name"));
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_NAME);
        } else {
            List versions = this.versionManager.getVersions(project.getId());
            for (Version version : versions) {
                if (!versionName.equalsIgnoreCase(version.getName())) continue;
                errors.addError("name", i18nBean.getText("admin.errors.version.already.exists"));
                reasons.add(VersionService.CreateVersionValidationResult.Reason.DUPLICATE_NAME);
            }
            if (versionName.length() > 255) {
                errors.addError("name", i18nBean.getText("admin.errors.version.name.toolong"));
                reasons.add(VersionService.CreateVersionValidationResult.Reason.VERSION_NAME_TOO_LONG);
            }
        }
        Date startDate = null;
        try {
            startDate = this.parseDate(appUser, DateField.START_DATE, startDateStr);
        }
        catch (DateParseException e) {
            errors.addErrorCollection(e.parseErrors);
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_START_DATE);
        }
        Date releaseDate = null;
        try {
            releaseDate = this.parseDate(appUser, DateField.RELEASE_DATE, releaseDateStr);
        }
        catch (DateParseException e) {
            errors.addErrorCollection(e.parseErrors);
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_RELEASE_DATE);
        }
        ServiceOutcome<Void> validateDatesOutcome = this.validateStartReleaseDates(appUser, DateField.START_DATE, startDate, releaseDate);
        if (!validateDatesOutcome.isValid()) {
            errors.addErrorCollection(validateDatesOutcome.getErrorCollection());
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_START_RELEASE_DATE_ORDER);
        }
        return new ValidateResult((ErrorCollection)errors, reasons, startDate, releaseDate);
    }

    private void check(VersionService.VersionBuilderValidationResult validatedData) {
        if (validatedData == null) {
            throw new IllegalArgumentException("You can not create a version with a null validation result.");
        }
        if (!validatedData.isValid()) {
            throw new IllegalStateException("You can not create a version with an invalid validation result.");
        }
        if (validatedData.getResult() == null) {
            throw new IllegalArgumentException("You can not create a null version.");
        }
    }

    private VersionService.VersionBuilderValidationResult validateUpdate(I18nHelper i18nBean, ErrorCollection errors, VersionBuilder versionBuilder) {
        VersionBuilderImpl versionBuilderImpl = (VersionBuilderImpl)versionBuilder;
        EnumSet<VersionService.CreateVersionValidationResult.Reason> reasons = EnumSet.noneOf(VersionService.CreateVersionValidationResult.Reason.class);
        String versionName = versionBuilderImpl.getName();
        if (StringUtils.isEmpty((String)versionName)) {
            errors.addError("name", i18nBean.getText("admin.errors.enter.valid.version.name"));
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_NAME);
        } else {
            if (versionName.length() > 255) {
                errors.addError("name", i18nBean.getText("admin.errors.version.name.toolong"));
                reasons.add(VersionService.CreateVersionValidationResult.Reason.VERSION_NAME_TOO_LONG);
            }
            if (versionBuilderImpl.getVersion() != null) {
                if (this.versionManager.isDuplicateName(versionBuilderImpl.getVersion(), versionName)) {
                    String message = i18nBean.getText("admin.errors.projectversions.version.exists");
                    errors.addError("name", message, ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else {
                this.versionManager.getVersions(versionBuilderImpl.getProjectId()).stream().filter(version -> versionName.equalsIgnoreCase(version.getName())).forEach(version -> {
                    if (version.isArchived()) {
                        errors.addError("name", i18nBean.getText("admin.errors.version.cannot.add.archived.version"));
                    } else {
                        errors.addError("name", i18nBean.getText("admin.errors.version.already.exists"));
                    }
                    reasons.add(VersionService.CreateVersionValidationResult.Reason.DUPLICATE_NAME);
                });
            }
        }
        Locale locale = i18nBean.getLocale();
        if (versionBuilderImpl.getStartDate() != null) {
            versionBuilderImpl.startDate(DefaultVersionService.makeMidnight(versionBuilderImpl.getStartDate(), locale));
        }
        if (versionBuilderImpl.getReleaseDate() != null) {
            versionBuilderImpl.releaseDate(DefaultVersionService.makeMidnight(versionBuilderImpl.getReleaseDate(), locale));
        }
        if (versionBuilderImpl.getStartDate() != null && versionBuilderImpl.getReleaseDate() != null && versionBuilderImpl.getStartDate().after(versionBuilderImpl.getReleaseDate())) {
            String sourceField = "startDate";
            if (versionBuilderImpl.getVersion() != null && versionBuilderImpl.getStartDate().equals(versionBuilderImpl.getVersion().getStartDate())) {
                sourceField = "releaseDate";
            }
            errors.addError(sourceField, i18nBean.getText("admin.errors.version.start.release.date.order"), ErrorCollection.Reason.VALIDATION_FAILED);
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_START_RELEASE_DATE_ORDER);
        }
        return new VersionService.VersionBuilderValidationResult(errors, reasons, (VersionBuilder)versionBuilderImpl);
    }

    private VersionService.CreateVersionValidationResult newCreateResult(VersionService.VersionBuilderValidationResult versionBuilderValidationResult) {
        if (!versionBuilderValidationResult.isValid()) {
            return new VersionService.CreateVersionValidationResult(versionBuilderValidationResult.getErrorCollection(), versionBuilderValidationResult.getSpecificReasons());
        }
        VersionBuilderImpl builder = (VersionBuilderImpl)versionBuilderValidationResult.getResult();
        Project project = this.projectManager.getProjectObj(builder.getProjectId());
        return new VersionService.CreateVersionValidationResult(versionBuilderValidationResult.getErrorCollection(), project, builder.getName(), builder.getStartDate(), builder.getReleaseDate(), builder.getDescription(), builder.getScheduleAfterVersion());
    }

    private boolean hasReadPermission(ApplicationUser user, Project project) {
        return this.hasEditPermission(user, project) || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
    }

    private boolean hasCreatePermission(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    private boolean hasEditPermission(ApplicationUser user, Project project) {
        return this.hasCreatePermission(user, project);
    }

    private ServiceOutcome<Version> setReleaseDate(ApplicationUser user, Version version, Either<String, Date> releaseDate) {
        ServiceOutcome<Date> releaseDateOutcome = this.parseDateFromEither(user, DateField.RELEASE_DATE, releaseDate);
        if (!releaseDateOutcome.isValid()) {
            return ServiceOutcomeImpl.error(releaseDateOutcome);
        }
        return this.setReleaseDate(user, version, (Date)releaseDateOutcome.getReturnedValue());
    }

    private void checkVersionValid(ErrorCollection errors, I18nHelper i18nHelper, @Nullable ApplicationUser user, @Nonnull Version version) {
        Assertions.notNull((String)"version", (Object)version);
        Project project = version.getProject();
        if (project == null) {
            errors.addErrorMessage(i18nHelper.getText("admin.errors.must.specify.valid.project"));
            return;
        }
        if (!this.hasCreatePermission(user, project)) {
            errors.addErrorMessage(i18nHelper.getText("admin.errors.version.no.permission"));
            return;
        }
        if (StringUtils.isEmpty((String)version.getName())) {
            errors.addError("name", i18nHelper.getText("admin.errors.enter.valid.version.name"));
        }
    }

    private List<Issue> getUnresolvedIssues(ApplicationUser user, Version toRelease) {
        try {
            Long pid = toRelease.getProjectId();
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{pid}).and().unresolved();
            builder.and().fixVersion(toRelease.getId());
            SearchResults results = this.searchProvider.search(builder.buildQuery(), user, PagerFilter.getUnlimitedFilter());
            List issues = results.getIssues();
            return issues == null ? Collections.emptyList() : issues;
        }
        catch (Exception e) {
            log.error("Exception whilst getting unresolved issues " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private VersionService.MoveVersionValidationResult validateMove(@Nullable ApplicationUser user, long versionId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Version version = this.versionManager.getVersion(Long.valueOf(versionId));
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", String.valueOf(versionId)));
            return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.NOT_FOUND));
        }
        Project project = version.getProject();
        if (!this.hasCreatePermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.FORBIDDEN));
        }
        return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, version);
    }

    private static Date makeMidnight(Date date, Locale locale) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private ServiceOutcome<Date> parseDateFromEither(ApplicationUser user, DateField field, Either<String, Date> date) {
        if (date.isLeft()) {
            try {
                return ServiceOutcomeImpl.ok(this.parseDate(user, field, (String)date.left().get()));
            }
            catch (DateParseException e) {
                return new ServiceOutcomeImpl<Date>(e.parseErrors);
            }
        }
        return ServiceOutcomeImpl.ok(date.right().get());
    }

    static enum DateField {
        START_DATE("startDate"),
        RELEASE_DATE("releaseDate");

        public final String name;

        private DateField(String name) {
            this.name = name;
        }
    }

    static class DateParseException
    extends Exception {
        final ErrorCollection parseErrors;

        DateParseException(ErrorCollection parseErrors) {
            this.parseErrors = parseErrors;
        }
    }

    static class ValidateResult {
        private final ErrorCollection errors;
        private final Set<VersionService.CreateVersionValidationResult.Reason> reasons;
        private final Date parsedStartDate;
        private final Date parsedReleaseDate;

        ValidateResult(ErrorCollection errors, Set<VersionService.CreateVersionValidationResult.Reason> reasons) {
            this(errors, reasons, null, null);
        }

        ValidateResult(ErrorCollection errors, Set<VersionService.CreateVersionValidationResult.Reason> reasons, Date parsedStartDate, Date parsedReleaseDate) {
            if (!reasons.isEmpty() && !errors.hasAnyErrors()) {
                throw new IllegalArgumentException("Cannot have reasons without error messages.");
            }
            this.errors = errors;
            this.reasons = reasons;
            this.parsedStartDate = parsedStartDate;
            this.parsedReleaseDate = parsedReleaseDate;
        }

        boolean isValid() {
            return !this.errors.hasAnyErrors();
        }

        ErrorCollection getErrors() {
            return this.errors;
        }

        Set<VersionService.CreateVersionValidationResult.Reason> getReasons() {
            return this.reasons;
        }

        Date getParsedStartDate() {
            return this.parsedStartDate;
        }

        Date getParsedReleaseDate() {
            return this.parsedReleaseDate;
        }
    }
}

