/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.projectroles;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.event.role.ProjectRoleDeletedEvent;
import com.atlassian.jira.event.role.ProjectRoleUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectRoleService
implements ProjectRoleService {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectRoleService.class);
    private ProjectRoleManager projectRoleManager;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private RoleActorFactory roleActorFactory;
    private NotificationSchemeManager notificationSchemeManager;
    private PermissionSchemeManager permissionSchemeManager;
    private WorkflowManager workflowManager;
    private ProjectManager projectManager;
    private SchemeFactory schemeFactory;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private IssueSecuritySchemeManager issueSecuritySchemeManager;
    private EventPublisher eventPublisher;
    private final WorklogManager worklogManager;
    private final CommentManager commentManager;

    public DefaultProjectRoleService(ProjectRoleManager projectRoleManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, RoleActorFactory roleActorFactory, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, WorkflowManager workflowManager, ProjectManager projectManager, SchemeFactory schemeFactory, IssueSecurityLevelManager issueSecurityLevelManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, IssueSecuritySchemeManager issueSecuritySchemeManager, EventPublisher eventPublisher, WorklogManager worklogManager, CommentManager commentManager) {
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.roleActorFactory = roleActorFactory;
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
        this.schemeFactory = schemeFactory;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.eventPublisher = eventPublisher;
        this.worklogManager = worklogManager;
        this.commentManager = commentManager;
    }

    public Collection<ProjectRole> getProjectRoles(ApplicationUser currentUser, ErrorCollection errorCollection) {
        return this.getProjectRoles(errorCollection);
    }

    public ProjectRole getProjectRole(ApplicationUser currentUser, Long id, ErrorCollection errorCollection) {
        return this.getProjectRole(id, errorCollection);
    }

    public ProjectRole getProjectRoleByName(ApplicationUser currentUser, String name, ErrorCollection errorCollection) {
        return this.getProjectRoleByName(name, errorCollection);
    }

    private boolean isRoleNameValidString(String roleName, ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)roleName)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.create"));
            return false;
        }
        if (!roleName.trim().equals(roleName)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.trim.whitespace"));
            return false;
        }
        if (roleName.length() > 255) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.cannot.be.longer.255"));
            return false;
        }
        return true;
    }

    public ProjectRole createProjectRole(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        ProjectRole createdProjectRole = null;
        boolean internalError = false;
        String roleName = null;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.create"));
            internalError = true;
        } else {
            roleName = projectRole.getName();
        }
        if (!this.isRoleNameValidString(roleName, errorCollection)) {
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!this.isProjectRoleNameUnique(currentUser, roleName, errorCollection)) {
            internalError = true;
        }
        if (!internalError) {
            createdProjectRole = this.projectRoleManager.createRole(projectRole);
        }
        return createdProjectRole;
    }

    public boolean isProjectRoleNameUnique(ApplicationUser currentUser, String name, ErrorCollection errorCollection) {
        boolean roleNameUnique = false;
        if (this.hasAdminPermission(currentUser)) {
            roleNameUnique = this.projectRoleManager.isRoleNameUnique(name);
            if (!roleNameUnique) {
                errorCollection.addError("name", this.getText("admin.projectroles.duplicate.role.name.error", name), ErrorCollection.Reason.CONFLICT);
            }
        } else {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
        }
        return roleNameUnique;
    }

    public void deleteProjectRole(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.delete"));
            internalError = true;
        }
        if (!internalError && projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.id.delete"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!internalError) {
            try {
                this.notificationSchemeManager.removeEntities("Project_Role", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error("Unable to remove notification scheme entites for project role: " + projectRole.getName());
            }
            try {
                this.permissionSchemeManager.removeEntities("projectrole", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error("Unable to remove permission scheme entites for project role: " + projectRole.getName());
            }
            try {
                this.issueSecuritySchemeManager.removeEntities("projectrole", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error("Unable to remove issue security scheme entites for project role: " + projectRole.getName());
            }
            this.sharePermissionDeleteUtils.deleteRoleSharePermissions(projectRole.getId());
            this.projectRoleManager.deleteRole(projectRole);
            this.clearIssueSecurityLevelCache();
            this.eventPublisher.publish((Object)new ProjectRoleDeletedEvent(projectRole));
        }
    }

    public void updateProjectRole(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.update"));
            internalError = true;
        }
        if (!internalError && projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.id.update"));
            internalError = true;
        }
        if (internalError || this.isRoleNameValidString(projectRole.getName(), errorCollection)) {
            // empty if block
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!internalError) {
            ProjectRole roleByName = this.projectRoleManager.getProjectRole(projectRole.getName());
            if (roleByName != null && !roleByName.getId().equals(projectRole.getId())) {
                errorCollection.addErrorMessage(this.getText("admin.projectroles.duplicate.role.name.error", projectRole.getName()));
            } else {
                this.projectRoleManager.updateRole(projectRole);
            }
        }
    }

    public ProjectRoleActors getProjectRoleActors(ApplicationUser currentUser, ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project.role"));
            internalError = true;
        }
        if (project == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project"));
            internalError = true;
        }
        ProjectRoleActors projectRoleActors = null;
        if (!internalError && this.hasProjectRolePermission(currentUser, project)) {
            projectRoleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        return projectRoleActors;
    }

    private void removeActorsFromProjectRole(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection, boolean triggerEvent) {
        if (this.hasProjectRolePermission(currentUser, project)) {
            if (this.canRemoveCurrentUser(currentUser, actors, projectRole, project, actorType)) {
                this.updateActorsToProjectRole(currentUser, actors, projectRole, project, actorType, errorCollection, false, triggerEvent);
            } else {
                errorCollection.addErrorMessage(this.getText("project.roles.service.error.removeself.actor"));
            }
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.no.permission.to.remove"), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    public void setActorsForProjectRole(ApplicationUser currentUser, Map<String, Set<String>> newRoleActors, ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        ProjectRoleActors projectRoleActors = this.getProjectRoleActors(currentUser, projectRole, project, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        if (projectRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        if (newRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.new.role.actors.null"));
            return;
        }
        Set roleActors = projectRoleActors.getRoleActors();
        HashMap existingRoleActors = Maps.newHashMap();
        for (RoleActor roleActor : roleActors) {
            String actorType = roleActor.getType();
            String actorName = roleActor.getParameter();
            Set actorNames = (Set)existingRoleActors.get(actorType);
            if (actorNames == null) {
                actorNames = Sets.newHashSet();
            }
            actorNames.add(actorName);
            existingRoleActors.put(actorType, actorNames);
        }
        Set allActorTypes = CollectionBuilder.newBuilder().addAll(existingRoleActors.keySet()).addAll(newRoleActors.keySet()).asSet();
        HashMap toDelete = Maps.newHashMap((Map)existingRoleActors);
        HashMap toAdd = Maps.newHashMap(newRoleActors);
        for (String actorType : allActorTypes) {
            Set<String> newActors = newRoleActors.get(actorType);
            Set actorsToDelete = (Set)toDelete.get(actorType);
            if (newActors != null && actorsToDelete != null) {
                HashSet actorsToDeleteCopy = Sets.newHashSet((Iterable)actorsToDelete);
                actorsToDeleteCopy.removeAll(newActors);
                toDelete.put(actorType, actorsToDeleteCopy);
            }
            Set existingActors = (Set)existingRoleActors.get(actorType);
            Set actorsToAdd = (Set)toAdd.get(actorType);
            if (existingActors == null || actorsToAdd == null) continue;
            HashSet actorsToAddCopy = Sets.newHashSet((Iterable)actorsToAdd);
            actorsToAddCopy.removeAll(existingActors);
            toAdd.put(actorType, actorsToAddCopy);
        }
        for (String actorType : allActorTypes) {
            Set actorNamesToDelete;
            Set actorNamesToAdd = (Set)toAdd.get(actorType);
            if (actorNamesToAdd != null && actorNamesToAdd.size() > 0) {
                this.updateActorsToProjectRole(this.jiraAuthenticationContext.getUser(), actorNamesToAdd, projectRole, project, actorType, errorCollection, true, false);
            }
            if ((actorNamesToDelete = (Set)toDelete.get(actorType)) == null || actorNamesToDelete.size() <= 0) continue;
            this.removeActorsFromProjectRole(this.jiraAuthenticationContext.getUser(), actorNamesToDelete, projectRole, project, actorType, errorCollection, false);
        }
        this.eventPublisher.publish((Object)new ProjectRoleUpdatedEvent(project, projectRole, this.projectRoleManager.getProjectRoleActors(projectRole, project), projectRoleActors));
    }

    boolean canRemoveCurrentUser(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType) {
        if (this.permissionManager.hasPermission(0, currentUser)) {
            return true;
        }
        if (!this.doesProjectRoleExistForAdministerProjectsPermission(project, projectRole)) {
            return true;
        }
        ProjectRoleActors projectRoleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
        ArrayList<ApplicationUser> allUsers = new ArrayList<ApplicationUser>();
        int rolesRemovedWithMeInIt = 0;
        for (RoleActor roleActorFromProjectRole : projectRoleActors.getRoleActors()) {
            Set roleActorFromProjectRoleUsers = roleActorFromProjectRole.getUsers();
            allUsers.addAll(roleActorFromProjectRoleUsers);
            if (!this.roleActorsToRemoveContainsRoleActorFromProjectRole(roleActorFromProjectRole, actorType, currentUser, actors, projectRole, project)) continue;
            ++rolesRemovedWithMeInIt;
        }
        int amountOfTimesIAmReferenced = this.getAmountOfTimesUsernameInList(allUsers, currentUser);
        return amountOfTimesIAmReferenced > rolesRemovedWithMeInIt;
    }

    boolean doesProjectRoleExistForAdministerProjectsPermission(Project project, ProjectRole projectRole) {
        List schemesGvs;
        if (this.permissionSchemeManager == null) {
            throw new NullPointerException("Instance of " + PermissionSchemeManager.class.getName() + " required.");
        }
        if (this.schemeFactory == null) {
            throw new NullPointerException("Instance of " + SchemeFactory.class.getName() + " required.");
        }
        if (project == null) {
            throw new NullPointerException("Instance of " + Project.class.getName() + " required.");
        }
        if (projectRole == null) {
            throw new NullPointerException("Instance of " + ProjectRole.class.getName() + " required.");
        }
        try {
            schemesGvs = this.permissionSchemeManager.getSchemes(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        for (GenericValue schemeGv : schemesGvs) {
            Scheme scheme = this.schemeFactory.getSchemeWithEntitiesComparable(schemeGv);
            List entitiesForProjectAdmin = scheme.getEntitiesByType((Object)23L);
            for (SchemeEntity schemeEntity : entitiesForProjectAdmin) {
                boolean schemeEntityIsForProjectRole;
                boolean bl = schemeEntityIsForProjectRole = schemeEntity.getParameter() != null && projectRole.getId().toString().equals(schemeEntity.getParameter());
                boolean schemeEntityIsOfTypeProjectRole = "projectrole".equals(schemeEntity.getType());
                if (!schemeEntityIsOfTypeProjectRole || !schemeEntityIsForProjectRole) continue;
                return true;
            }
        }
        return false;
    }

    public DefaultRoleActors getDefaultRoleActors(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project.role"));
            internalError = true;
        }
        DefaultRoleActors defaultRoleActors = null;
        if (!internalError && this.hasAdminPermission(currentUser)) {
            defaultRoleActors = this.projectRoleManager.getDefaultRoleActors(projectRole);
        } else if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
        }
        return defaultRoleActors;
    }

    public void removeAllRoleActorsByNameAndType(ApplicationUser currentUser, String name, String type, ErrorCollection errorCollection) {
        ErrorCollection errors = this.validateRemoveAllRoleActorsByNameAndType(currentUser, name, type);
        if (errors.hasAnyErrors()) {
            errorCollection.addErrorCollection(errors);
        } else {
            this.removeAllRoleActorsByNameAndType(name, type);
        }
    }

    public ErrorCollection validateRemoveAllRoleActorsByNameAndType(ApplicationUser currentUser, String name, String type) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.remove"));
        }
        if (!TextUtils.stringSet((String)type)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.type.null.remove"));
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage((ErrorCollection)errorCollection);
        }
        return errorCollection;
    }

    public void removeAllRoleActorsByNameAndType(String name, String type) {
        this.projectRoleManager.removeAllRoleActorsByNameAndType(name, type);
    }

    public void removeAllRoleActorsByProject(ApplicationUser currentUser, Project project, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (project == null || project.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.null"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!internalError) {
            this.projectRoleManager.removeAllRoleActorsByProject(project);
        }
    }

    public Collection getAssociatedNotificationSchemes(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.getAssociatedNotificationSchemes(projectRole, errorCollection);
    }

    public Collection<GenericValue> getAssociatedIssueSecuritySchemes(ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            return this.issueSecuritySchemeManager.getSchemesContainingEntity("projectrole", projectRole.getId().toString());
        }
        return Lists.newArrayList();
    }

    public Collection getAssociatedIssueSecuritySchemes(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.getAssociatedIssueSecuritySchemes(projectRole, errorCollection);
    }

    public Collection getAssociatedPermissionSchemes(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.getAssociatedPermissionSchemes(projectRole, errorCollection);
    }

    public MultiMap getAssociatedWorkflows(ApplicationUser currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.getAssociatedWorkflows(projectRole, errorCollection);
    }

    public Collection<Project> getProjectsContainingRoleActorByNameAndType(ApplicationUser currentUser, String name, String type, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.remove"));
            internalError = true;
        }
        if (!TextUtils.stringSet((String)type)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.type.null.remove"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (internalError) {
            return Collections.emptyList();
        }
        Collection projectIds = this.projectRoleManager.getProjectIdsContainingRoleActorByNameAndType(name, type);
        if (projectIds == null) {
            return Collections.emptyList();
        }
        return this.projectManager.convertToProjectObjects(projectIds);
    }

    public List<Long> roleActorOfTypeExistsForProjects(ApplicationUser currentUser, List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter, ErrorCollection errorCollection) {
        ArrayList<Long> projectsRoleActorExistsFor = new ArrayList<Long>();
        boolean internalError = false;
        if (projectsToLimitBy == null || projectsToLimitBy.isEmpty()) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.projects.to.limit.needed"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!internalError) {
            projectsRoleActorExistsFor.addAll(this.projectRoleManager.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter));
        }
        return projectsRoleActorExistsFor;
    }

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(ApplicationUser currentUser, List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (!this.hasAdminPermission(currentUser)) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
            internalError = true;
        }
        if (!internalError) {
            return this.projectRoleManager.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userName);
        }
        return new HashMap<Long, List<String>>();
    }

    private boolean conditionsDescriptorContainsProjectRoleCondition(ConditionsDescriptor conditionsDescriptor, Long projectRoleId) {
        for (Object o : conditionsDescriptor.getConditions()) {
            ConditionDescriptor conditionDescriptor;
            Map args;
            String foundProjectRoleId;
            if (!(o instanceof ConditionsDescriptor ? this.conditionsDescriptorContainsProjectRoleCondition((ConditionsDescriptor)o, projectRoleId) : (foundProjectRoleId = (String)(args = (conditionDescriptor = (ConditionDescriptor)o).getArgs()).get("jira.projectrole.id")) != null && foundProjectRoleId.equals(projectRoleId.toString()))) continue;
            return true;
        }
        return false;
    }

    private void updateActorsToProjectRole(ApplicationUser currentUser, Collection<String> actorKeys, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection, boolean add, boolean triggerEvent) {
        ProjectRoleActors originalRoleActors = this.getProjectRoleActors(currentUser, projectRole, project, errorCollection);
        if (originalRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        ArrayList<RoleActor> actors = new ArrayList<RoleActor>();
        boolean internalError = this.createRoleActors(actorKeys, projectRole, project, actorType, (DefaultRoleActors)originalRoleActors, errorCollection, actors, add);
        Project projectRoleProject = this.projectManager.getProjectObj(originalRoleActors.getProjectId());
        boolean hasPermission = this.hasProjectRolePermission(currentUser, projectRoleProject);
        if (!internalError && hasPermission && actors.size() > 0) {
            ProjectRoleActors newRoleActors = add ? (ProjectRoleActors)originalRoleActors.addRoleActors(actors) : (ProjectRoleActors)originalRoleActors.removeRoleActors(actors);
            this.projectRoleManager.updateProjectRoleActors(newRoleActors);
            this.clearIssueSecurityLevelCache();
            if (triggerEvent) {
                this.eventPublisher.publish((Object)new ProjectRoleUpdatedEvent(projectRoleProject, projectRole, newRoleActors, originalRoleActors));
            }
        } else if (!hasPermission) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.permission"));
        }
    }

    private boolean validateAllUsersAreActive(List<RoleActor> roleActors, ErrorCollection errorCollection) {
        boolean result = true;
        for (RoleActor actor : roleActors) {
            for (ApplicationUser user : actor.getUsers()) {
                if (user.isActive()) continue;
                errorCollection.addErrorMessage("User '" + user.getName() + "' does not exist.");
                result = false;
            }
        }
        return result;
    }

    public boolean hasProjectRolePermission(ApplicationUser currentUser, Project project) {
        return this.hasAdminPermission(currentUser) || this.hasProjectAdminPermission(currentUser, project);
    }

    public ServiceResult validateNoRoleUsage(ProjectRole projectRole) {
        return new ServiceResultImpl(ErrorCollections.join((ErrorCollection[])new ErrorCollection[]{this.validateNoSchemeAssociationsForRole(projectRole), this.validateNoUsageOfRoleInWorkflows(projectRole), this.validateNoUsageOfRoleInComments(projectRole), this.validateNoUsageOfRoleInWorklogs(projectRole)}));
    }

    public void swapRole(ProjectRole role, ProjectRole swapRole) {
        this.swapRoleInSchemes(role, swapRole);
        this.swapRoleInWorkflows(role, swapRole);
        this.worklogManager.swapWorklogRoleRestriction(role.getId(), swapRole.getId());
        this.commentManager.swapCommentRoleRestriction(role.getId(), swapRole.getId());
    }

    private ErrorCollection validateNoSchemeAssociationsForRole(ProjectRole projectRole) {
        return ErrorCollections.join((ErrorCollection[])new ErrorCollection[]{this.validateNoAssociations(projectRole, this::getAssociatedNotificationSchemes, "rest.role.used.in.notification.schemes"), this.validateNoAssociations(projectRole, this::getAssociatedIssueSecuritySchemes, "rest.role.used.in.security.schemes"), this.validateNoAssociations(projectRole, this::getAssociatedPermissionSchemes, "rest.role.used.in.permission.schemes")});
    }

    private ErrorCollection validateNoUsageOfRoleInWorkflows(ProjectRole projectRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Set workflows = this.getAssociatedWorkflows(projectRole, (ErrorCollection)errorCollection).keySet();
        if (!workflows.isEmpty()) {
            List workflowNames = workflows.stream().map(JiraWorkflow::getDisplayName).collect(Collectors.toList());
            String workflowListString = "[" + StringUtils.join(workflowNames, (String)",") + "]";
            errorCollection.addErrorMessage(this.getText("rest.role.used.in.workflows", workflowListString), ErrorCollection.Reason.CONFLICT);
        }
        return errorCollection;
    }

    private ErrorCollection validateNoUsageOfRoleInWorklogs(ProjectRole projectRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        long countForWorklogsRestrictedByRole = this.worklogManager.getCountForWorklogsRestrictedByRole(projectRole.getId());
        if (countForWorklogsRestrictedByRole != 0L) {
            errorCollection.addErrorMessage(this.getText("rest.role.used.in.worklogs"), ErrorCollection.Reason.CONFLICT);
        }
        return errorCollection;
    }

    private ErrorCollection validateNoUsageOfRoleInComments(ProjectRole projectRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        long countForCommentsRestrictedByRole = this.commentManager.getCountForCommentsRestrictedByRole(projectRole.getId());
        if (countForCommentsRestrictedByRole != 0L) {
            errorCollection.addErrorMessage(this.getText("rest.role.used.in.comments"), ErrorCollection.Reason.CONFLICT);
        }
        return errorCollection;
    }

    private ErrorCollection validateNoAssociations(ProjectRole projectRole, BiFunction<ProjectRole, ErrorCollection, Collection> function, String errorMessageKey) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection associations = function.apply(projectRole, (ErrorCollection)errorCollection);
        if (!associations.isEmpty()) {
            Collection schemes = associations;
            List schemeNames = schemes.stream().map(value -> value.get("name").toString()).collect(Collectors.toList());
            String schemeListString = "[" + StringUtils.join(schemeNames, (String)",") + "]";
            errorCollection.addErrorMessage(this.getText(errorMessageKey, schemeListString), ErrorCollection.Reason.CONFLICT);
        }
        return errorCollection;
    }

    private void swapRoleInSchemes(ProjectRole role, ProjectRole swapRole) {
        String roleToReplaceId = role.getId().toString();
        String resultingRoleId = swapRole.getId().toString();
        this.notificationSchemeManager.swapParameterForEntitiesOfType("Project_Role", roleToReplaceId, resultingRoleId);
        this.issueSecuritySchemeManager.swapParameterForEntitiesOfType("projectrole", roleToReplaceId, resultingRoleId);
        this.permissionSchemeManager.swapParameterForEntitiesOfType("projectrole", roleToReplaceId, resultingRoleId);
    }

    private void swapRoleInWorkflows(ProjectRole role, ProjectRole swapRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MultiMap associatedWorkflows = this.getAssociatedWorkflows(role, (ErrorCollection)errorCollection);
        String moduleKey = "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition";
        String className = "com.atlassian.jira.workflow.condition.InProjectRoleCondition";
        for (Object o : associatedWorkflows.keySet()) {
            if (!(associatedWorkflows.get(o) instanceof Collection)) {
                throw new IllegalStateException("Associated workflows returned an unexpected map");
            }
            for (ActionDescriptor actionDescriptor : (Collection)associatedWorkflows.get(o)) {
                JiraWorkflow jiraWorkflow = (JiraWorkflow)o;
                this.workflowManager.replaceConditionInTransition(actionDescriptor, (Map)ImmutableMap.of((Object)"jira.projectrole.id", (Object)role.getId().toString(), (Object)"class.name", (Object)className), (Map)ImmutableMap.of((Object)"jira.projectrole.id", (Object)swapRole.getId().toString()));
                this.workflowManager.saveWorkflowWithoutAudit(jiraWorkflow);
            }
        }
    }

    private boolean createRoleActors(Collection<String> actors, ProjectRole projectRole, Project project, String actorType, DefaultRoleActors roleActors, ErrorCollection errorCollection, List<RoleActor> actorsTo, boolean add) {
        boolean internalError = false;
        for (String actorKey : actors) {
            try {
                Long projectId = project != null ? project.getId() : null;
                Long projectRoleId = projectRole != null ? projectRole.getId() : null;
                ProjectRoleActor projectRoleActor = this.roleActorFactory.createRoleActor(null, projectRoleId, projectId, actorType, actorKey);
                if (add) {
                    if (roleActors.getRoleActors().contains(projectRoleActor)) {
                        ApplicationUser actorUser;
                        Iterator actorUserIterator;
                        String actorIdForErrorMessage = actorKey;
                        if ("atlassian-user-role-actor".equals(projectRoleActor.getType()) && (actorUserIterator = projectRoleActor.getUsers().iterator()).hasNext() && (actorUser = (ApplicationUser)actorUserIterator.next()) != null) {
                            actorIdForErrorMessage = actorUser.getName();
                        }
                        errorCollection.addErrorMessage(this.getText("admin.user.role.actor.action.error.exists", actorIdForErrorMessage));
                        internalError = true;
                        continue;
                    }
                    if (!projectRoleActor.isActive()) {
                        errorCollection.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.user.role.actor.action.error.inactive", projectRoleActor.getParameter(), String.valueOf(projectRoleActor.getProjectRoleId())));
                        internalError = true;
                        continue;
                    }
                    actorsTo.add((RoleActor)projectRoleActor);
                    continue;
                }
                actorsTo.add((RoleActor)projectRoleActor);
            }
            catch (RoleActorDoesNotExistException ex) {
                errorCollection.addErrorMessage(this.getText("admin.user.role.actor.action.error.invalid", actorKey));
                internalError = true;
            }
        }
        return internalError;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    private boolean hasProjectAdminPermission(ApplicationUser currentUser, Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, currentUser);
    }

    private boolean hasAdminPermission(ApplicationUser currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private void updateActorsToDefaultRole(ApplicationUser currentUser, Collection<String> actorNames, ProjectRole projectRole, String actorType, ErrorCollection errorCollection, boolean add) {
        DefaultRoleActors defaultRoleActors = this.getDefaultRoleActors(currentUser, projectRole, errorCollection);
        if (defaultRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        ArrayList<RoleActor> actors = new ArrayList<RoleActor>();
        boolean internalError = this.createRoleActors(actorNames, projectRole, null, actorType, defaultRoleActors, errorCollection, actors, add);
        boolean hasAdminPermission = this.hasAdminPermission(currentUser);
        if (!internalError && hasAdminPermission && actors.size() > 0) {
            defaultRoleActors = add ? defaultRoleActors.addRoleActors(actors) : defaultRoleActors.removeRoleActors(actors);
            this.projectRoleManager.updateDefaultRoleActors(defaultRoleActors);
        } else if (!hasAdminPermission) {
            this.addRequiredAdminPermissionErrorMessage(errorCollection);
        }
    }

    private int getAmountOfTimesUsernameInList(List<ApplicationUser> allUsers, ApplicationUser currentUser) {
        int numberOfTimesIAmReferenced = 0;
        for (ApplicationUser user : allUsers) {
            if (!user.getName().equals(currentUser.getName())) continue;
            ++numberOfTimesIAmReferenced;
        }
        return numberOfTimesIAmReferenced;
    }

    private boolean roleActorsToRemoveContainsRoleActorFromProjectRole(RoleActor roleActorFromProjectRole, String actorType, ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, Project project) {
        if (roleActorFromProjectRole.getType().equals(actorType) && roleActorFromProjectRole.contains(currentUser)) {
            for (String actorKey : actors) {
                ProjectRoleActor roleActorToRemove;
                try {
                    roleActorToRemove = this.roleActorFactory.createRoleActor(null, projectRole.getId(), project.getId(), actorType, actorKey);
                }
                catch (RoleActorDoesNotExistException e) {
                    throw new IllegalArgumentException("Unexpected error: the role actor '" + actorKey + "' of type '" + actorType + "' does not exist.");
                }
                if (!roleActorToRemove.equals(roleActorFromProjectRole)) continue;
                return true;
            }
        }
        return false;
    }

    private void clearIssueSecurityLevelCache() {
        try {
            if (this.issueSecurityLevelManager != null) {
                this.issueSecurityLevelManager.clearUsersLevels();
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.debug("Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }

    public Collection<ProjectRole> getProjectRoles(ErrorCollection errorCollection) {
        return this.projectRoleManager.getProjectRoles();
    }

    public ProjectRole getProjectRole(Long id, ErrorCollection errorCollection) {
        ProjectRole projectRole = null;
        if (id == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.id.null"));
        } else {
            projectRole = this.projectRoleManager.getProjectRole(id);
        }
        return projectRole;
    }

    public ProjectRole getProjectRoleByName(String name, ErrorCollection errorCollection) {
        ProjectRole projectRole = null;
        if (StringUtils.isBlank((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null"));
        } else {
            projectRole = this.projectRoleManager.getProjectRole(name);
        }
        return projectRole;
    }

    public ProjectRole createProjectRole(ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.createProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), projectRole, errorCollection);
    }

    public boolean isProjectRoleNameUnique(String name, ErrorCollection errorCollection) {
        return this.isProjectRoleNameUnique(this.jiraAuthenticationContext.getLoggedInUser(), name, errorCollection);
    }

    public void deleteProjectRole(ProjectRole projectRole, ErrorCollection errorCollection) {
        this.deleteProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), projectRole, errorCollection);
    }

    public void updateProjectRole(ProjectRole projectRole, ErrorCollection errorCollection) {
        this.updateProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), projectRole, errorCollection);
    }

    public ProjectRoleActors getProjectRoleActors(ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        return this.getProjectRoleActors(this.jiraAuthenticationContext.getLoggedInUser(), projectRole, project, errorCollection);
    }

    public DefaultRoleActors getDefaultRoleActors(ProjectRole projectRole, ErrorCollection errorCollection) {
        return this.getDefaultRoleActors(this.jiraAuthenticationContext.getLoggedInUser(), projectRole, errorCollection);
    }

    public void addActorsToProjectRole(Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, project, actorType, errorCollection, true, true);
    }

    public void addActorsToProjectRole(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToProjectRole(currentUser, actors, projectRole, project, actorType, errorCollection, true, true);
    }

    public void removeActorsFromProjectRole(Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        this.removeActorsFromProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, project, actorType, errorCollection, true);
    }

    public void removeActorsFromProjectRole(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        this.removeActorsFromProjectRole(currentUser, actors, projectRole, project, actorType, errorCollection, true);
    }

    public void setActorsForProjectRole(Map<String, Set<String>> newRoleActors, ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        this.setActorsForProjectRole(this.jiraAuthenticationContext.getLoggedInUser(), newRoleActors, projectRole, project, errorCollection);
    }

    public void addDefaultActorsToProjectRole(Collection<String> actors, ProjectRole projectRole, String type, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, type, errorCollection, true);
    }

    public void addDefaultActorsToProjectRole(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, String type, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, type, errorCollection, true);
    }

    public void removeDefaultActorsFromProjectRole(Collection<String> actors, ProjectRole projectRole, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, actorType, errorCollection, false);
    }

    public void removeDefaultActorsFromProjectRole(ApplicationUser currentUser, Collection<String> actors, ProjectRole projectRole, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(this.jiraAuthenticationContext.getLoggedInUser(), actors, projectRole, actorType, errorCollection, false);
    }

    public ErrorCollection validateRemoveAllRoleActorsByNameAndType(String name, String type) {
        return this.validateRemoveAllRoleActorsByNameAndType(this.jiraAuthenticationContext.getLoggedInUser(), name, type);
    }

    public void removeAllRoleActorsByNameAndType(String name, String type, ErrorCollection errorCollection) {
        this.removeAllRoleActorsByNameAndType(this.jiraAuthenticationContext.getLoggedInUser(), name, type, errorCollection);
    }

    public void removeAllRoleActorsByProject(Project project, ErrorCollection errorCollection) {
        this.removeAllRoleActorsByProject(this.jiraAuthenticationContext.getLoggedInUser(), project, errorCollection);
    }

    public Collection getAssociatedNotificationSchemes(ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            return this.notificationSchemeManager.getSchemesContainingEntity("Project_Role", projectRole.getId().toString());
        }
        return Lists.newArrayList();
    }

    public Collection<GenericValue> getAssociatedPermissionSchemes(ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            return this.permissionSchemeManager.getSchemesContainingEntity("projectrole", projectRole.getId().toString());
        }
        return Lists.newArrayList();
    }

    public MultiMap getAssociatedWorkflows(ProjectRole projectRole, ErrorCollection errorCollection) {
        Collection workflows = this.workflowManager.getWorkflows();
        MultiHashMap associatedWorkflows = new MultiHashMap(workflows.size());
        for (JiraWorkflow jiraWorkflow : workflows) {
            Collection actions = jiraWorkflow.getAllActions();
            for (ActionDescriptor actionDescriptor : actions) {
                ConditionsDescriptor conditionsDescriptor;
                RestrictionDescriptor restriction = actionDescriptor.getRestriction();
                if (restriction == null || !this.conditionsDescriptorContainsProjectRoleCondition(conditionsDescriptor = restriction.getConditionsDescriptor(), projectRole.getId())) continue;
                associatedWorkflows.put((Object)jiraWorkflow, (Object)actionDescriptor);
            }
        }
        return associatedWorkflows;
    }

    public Collection<Project> getProjectsContainingRoleActorByNameAndType(String name, String type, ErrorCollection errorCollection) {
        return this.getProjectsContainingRoleActorByNameAndType(this.jiraAuthenticationContext.getLoggedInUser(), name, type, errorCollection);
    }

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter, ErrorCollection errorCollection) {
        return this.roleActorOfTypeExistsForProjects(this.jiraAuthenticationContext.getLoggedInUser(), projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter, errorCollection);
    }

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName, ErrorCollection errorCollection) {
        return this.getProjectIdsForUserInGroupsBecauseOfRole(this.jiraAuthenticationContext.getLoggedInUser(), projectsToLimitBy, projectRole, projectRoleType, userName, errorCollection);
    }

    public boolean hasProjectRolePermission(Project project) {
        return this.hasProjectRolePermission(this.jiraAuthenticationContext.getLoggedInUser(), project);
    }

    private void addRequiredAdminPermissionErrorMessage(ErrorCollection errorCollection) {
        errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
    }
}

