/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.board.BoardWorkflowService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.Query;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBoardWorkflowService
implements BoardWorkflowService {
    private final SearchService searchService;
    private final ProjectManager projectManager;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DefaultBoardWorkflowService(SearchService searchService, ProjectManager projectManager, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager) {
        this.searchService = searchService;
        this.projectManager = projectManager;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public Set<Status> getAccessibleStatuses(ApplicationUser user, Query query) {
        Collection<JiraWorkflow> workflows = this.getWorkflowsGivenQuery(user, query);
        return this.allStatusesFromWorkflowCollection(workflows);
    }

    public Set<Status> getAllActiveWorkflowStatuses() {
        Collection activeWorkflows = this.workflowManager.getActiveWorkflows();
        return this.allStatusesFromWorkflowCollection(activeWorkflows);
    }

    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj) {
        return this.getJiraWorkflows(projectObj, null);
    }

    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj, String issueTypeId) {
        try {
            AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(projectObj);
            if (issueTypeId == null) {
                return this.getWorkflowsFromWorkflowScheme((WorkflowScheme)workflowScheme);
            }
            return Collections.singleton(this.workflowManager.getWorkflowFromScheme((WorkflowScheme)workflowScheme, issueTypeId));
        }
        catch (DataAccessException e) {
            this.logger.error("Tried to retrieve workflows for a project and got an error: %s", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<Status> getInitialStatusesForQuery(ApplicationUser user, Query query) {
        return (Set)this.getWorkflowsGivenQuery(user, query).stream().map(this::getInitialStatusesForWorkflow).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private Collection<JiraWorkflow> getWorkflowsGivenQuery(ApplicationUser user, Query query) {
        if (this.containsGlobalContext(this.projectAndIssueTypeContextsForQuery(user, query))) {
            return this.workflowManager.getActiveWorkflows();
        }
        Map<Long, Set<String>> projectIssueTypeMappings = this.getProjectToIssueTypeMappingForQuery(user, query);
        return this.workflowsGivenProjectAndIssueTypeMappings(projectIssueTypeMappings);
    }

    private Set<Status> allStatusesFromWorkflowCollection(Collection<JiraWorkflow> workflows) {
        return (Set)workflows.stream().map(JiraWorkflow::getLinkedStatusObjects).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private boolean containsGlobalContext(Collection<QueryContext.ProjectIssueTypeContexts> contexts) {
        return contexts.stream().anyMatch(context -> context.getProjectContext().isAll());
    }

    private Collection<QueryContext.ProjectIssueTypeContexts> projectAndIssueTypeContextsForQuery(ApplicationUser user, Query query) {
        return this.searchService.getQueryContext(user, query).getProjectIssueTypeContexts();
    }

    private Map<Long, Set<String>> getProjectToIssueTypeMappingForQuery(ApplicationUser user, Query query) {
        return this.projectAndIssueTypeContextsForQuery(user, query).stream().collect(Collectors.toMap(context -> context.getProjectContext().getProjectId(), this::getIssueTypeIdsFromProjectIssueTypeContext));
    }

    private Set<String> getIssueTypeIdsFromProjectIssueTypeContext(QueryContext.ProjectIssueTypeContexts projectIssueTypeContext) {
        return (Set)projectIssueTypeContext.getIssueTypeContexts().stream().map(IssueTypeContext::getIssueTypeId).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<JiraWorkflow> workflowsGivenProjectAndIssueTypeMappings(Map<Long, Set<String>> projectAndIssueTypeMappings) {
        return (Set)projectAndIssueTypeMappings.entrySet().stream().map(entry -> this.getWorkflowsForProjectAndIssueTypeIds((Long)entry.getKey(), (Set)entry.getValue())).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<JiraWorkflow> getWorkflowsForProjectAndIssueTypeIds(Long projectId, Set<String> issueTypeIds) {
        Project project = this.projectManager.getProjectObj(projectId);
        if (issueTypeIds.isEmpty()) {
            return (Set)this.getJiraWorkflows(project).stream().collect(CollectorsUtil.toImmutableSet());
        }
        return (Set)issueTypeIds.stream().map(issueTypeId -> this.getJiraWorkflows(project, (String)issueTypeId)).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<Status> getInitialStatusesForWorkflow(JiraWorkflow workflow) {
        List initialActions = workflow.getDescriptor().getInitialActions();
        return (Set)initialActions.stream().map(actionDescriptor -> actionDescriptor.getUnconditionalResult().getStep()).map(stepId -> workflow.getDescriptor().getStep(stepId.intValue())).map(arg_0 -> ((JiraWorkflow)workflow).getLinkedStatus(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
    }

    private Collection<JiraWorkflow> getWorkflowsFromWorkflowScheme(@NotNull WorkflowScheme workflowScheme) {
        Set result = this.workflowManager.getWorkflowsFromScheme(this.workflowSchemeManager.getSchemeObject(workflowScheme.getId()));
        if (result == null) {
            result = Collections.emptySet();
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(result, (Predicate)Predicates.notNull()));
    }
}

