/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.cluster.NodeActivatedEvent;
import com.atlassian.jira.event.cluster.NodeActivatingEvent;
import com.atlassian.jira.event.cluster.NodePassivatedEvent;
import com.atlassian.jira.event.cluster.NodePassivatingEvent;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.util.DirectorySynchroniserBarrier;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultNodeStateManager
implements NodeStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNodeStateManager.class);
    private static final int WAIT_SECONDS = 20;
    private final CacheManager cacheManager;
    private final EventPublisher eventPublisher;
    private final ClusterNodeProperties clusterNodeProperties;
    private final LifecycleAwareSchedulerService schedulerService;
    private final ComponentFactory componentFactory;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final MailQueue mailQueue;
    private final OfBizClusterNodeStore ofBizClusterNodeStore;
    private final String hostname;
    @ClusterSafe
    private final ResettableLazyReference<Node> nodeRef = new ResettableLazyReference<Node>(){

        protected Node create() {
            return DefaultNodeStateManager.this.initializeNode();
        }
    };

    public DefaultNodeStateManager(OfBizClusterNodeStore ofBizClusterNodeStore, ClusterNodeProperties clusterNodeProperties, LifecycleAwareSchedulerService schedulerService, ComponentFactory componentFactory, MailQueue mailQueue, EventPublisher eventPublisher, JiraSystemRestarter jiraSystemRestarter, CacheManager cacheManager) {
        this.ofBizClusterNodeStore = ofBizClusterNodeStore;
        this.clusterNodeProperties = clusterNodeProperties;
        this.schedulerService = schedulerService;
        this.componentFactory = componentFactory;
        this.mailQueue = mailQueue;
        this.eventPublisher = eventPublisher;
        this.jiraSystemRestarter = jiraSystemRestarter;
        this.cacheManager = cacheManager;
        this.hostname = this.buildHostname();
    }

    @EventListener
    public void clearCache(ClearCacheEvent event) {
        this.nodeRef.reset();
    }

    @Override
    public void shutdownNode() {
        Node node = this.getNode();
        if (node != null && node.getNodeId() != null && this.ofBizClusterNodeStore.getNode(node.getNodeId()) != null) {
            this.ofBizClusterNodeStore.updateNode(node.getNodeId(), Node.NodeState.OFFLINE, this.hostname, this.getCacheListenerPort());
        }
    }

    @Override
    public Node getNode() {
        return (Node)this.nodeRef.get();
    }

    @Override
    public Node getNodeWithRefresh() {
        this.nodeRef.reset();
        return this.getNode();
    }

    @Override
    public Set<Node> getAllNodes() {
        return ImmutableSet.copyOf(this.ofBizClusterNodeStore.getAllNodes());
    }

    Node initializeNode() {
        String nodeId = this.clusterNodeProperties.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Node.NOT_CLUSTERED;
        }
        return this.getOrCreateNode(nodeId);
    }

    private Node getOrCreateNode(String nodeId) {
        Node node = this.ofBizClusterNodeStore.getNode(nodeId);
        if (node == null) {
            node = this.ofBizClusterNodeStore.createNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort());
        } else if (this.stateHasChanged(node)) {
            node = this.ofBizClusterNodeStore.updateNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort());
        }
        return node;
    }

    @Override
    @ClusterSafe(value="This is a local node instance behaviour.")
    public synchronized void activate() throws ClusterStateException {
        Node currentNode = this.getNode();
        String nodeId = DefaultNodeStateManager.requireNodeId(currentNode);
        LOG.info("Activating cluster instance: '" + nodeId + '\'');
        this.eventPublisher.publish((Object)NodeActivatingEvent.INSTANCE);
        this.updateState(currentNode, Node.NodeState.ACTIVATING);
        this.nodeRef.reset();
        this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
        this.cacheManager.flushCaches();
        this.startServices();
        this.updateState(currentNode, Node.NodeState.ACTIVE);
        this.eventPublisher.publish((Object)NodeActivatedEvent.INSTANCE);
        LOG.info("Activated cluster instance: '" + currentNode.getNodeId() + '\'');
    }

    private void startServices() {
        try {
            this.schedulerService.start();
        }
        catch (SchedulerServiceException e) {
            throw new IllegalStateException(e);
        }
        DefaultNodeStateManager.getTaskManager().start();
    }

    private void updateState(Node node, Node.NodeState state) throws NotClusteredException {
        this.ofBizClusterNodeStore.updateNode(DefaultNodeStateManager.requireNodeId(node), state, this.hostname, this.getCacheListenerPort());
        this.nodeRef.reset();
    }

    @Override
    @ClusterSafe(value="This is a local node instance behaviour.")
    public synchronized void quiesce() throws NotClusteredException {
        String nodeId = DefaultNodeStateManager.requireNodeId(this.getNode());
        LOG.info("Quiescing cluster instance: '" + nodeId + '\'');
        this.shutdownAndFlushAsyncServices();
    }

    @Override
    public void restart() {
        if (ComponentManager.getInstance().getState().isStarted()) {
            this.jiraSystemRestarter.ariseSirJIRA();
        }
    }

    @Override
    @ClusterSafe(value="This is a local node instance behaviour.")
    public synchronized void deactivate() throws NotClusteredException {
        Node currentNode = this.getNodeWithRefresh();
        String nodeId = DefaultNodeStateManager.requireNodeId(currentNode);
        LOG.info("Passivating cluster instance: '" + nodeId + '\'');
        this.eventPublisher.publish((Object)NodePassivatingEvent.INSTANCE);
        this.updateState(currentNode, Node.NodeState.PASSIVATING);
        this.nodeRef.reset();
        this.shutdownAndFlushAsyncServices();
        this.updateState(currentNode, Node.NodeState.PASSIVE);
        this.nodeRef.reset();
        this.eventPublisher.publish((Object)NodePassivatedEvent.INSTANCE);
        LOG.info("Passivated cluster instance: '" + nodeId + '\'');
    }

    protected boolean stateHasChanged(Node node) {
        return node.getState() == Node.NodeState.OFFLINE || !StringUtils.equalsIgnoreCase((CharSequence)this.hostname, (CharSequence)node.getIp()) || !Objects.equal((Object)node.getCacheListenerPort(), (Object)this.getCacheListenerPort());
    }

    protected Long getCacheListenerPort() {
        String port = this.clusterNodeProperties.getProperty("ehcache.listener.port");
        return Long.valueOf(port != null ? port : "40001");
    }

    protected String buildHostname() {
        String hostname = this.clusterNodeProperties.getProperty("ehcache.listener.hostName");
        return hostname != null ? hostname : JiraUtils.getHostname();
    }

    private void shutdownAndFlushAsyncServices() {
        try {
            this.schedulerService.standby();
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
        this.cleanUpTaskManager();
        this.cleanUpCrowd();
        try {
            this.mailQueue.sendBuffer();
        }
        catch (RuntimeException e) {
            LOG.warn("Sending buffer failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void cleanUpCrowd() {
        DirectorySynchroniserBarrier barrier = this.componentFactory.createObject(DirectorySynchroniserBarrier.class);
        if (!barrier.await(20L, TimeUnit.SECONDS)) {
            LOG.error("Unable to stop remote directory synchronization.");
        }
    }

    private void cleanUpTaskManager() {
        DefaultNodeStateManager.getTaskManager().shutdownAndWait(20L);
    }

    private static TaskManager getTaskManager() {
        return (TaskManager)ComponentAccessor.getComponent(TaskManager.class);
    }

    @Nonnull
    private static String requireNodeId(@Nonnull Node node) throws NotClusteredException {
        String nodeId = node.getNodeId();
        if (nodeId == null) {
            throw new NotClusteredException();
        }
        return nodeId;
    }
}

