/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import java.io.File;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class JiraHomeChangeEvent {
    @Nonnull
    private Action action;
    @Nonnull
    private File[] files;
    @Nonnull
    private FileType fileType;

    public JiraHomeChangeEvent(@Nonnull Action action, @Nonnull FileType fileType, File ... files) {
        this.action = action;
        this.files = files;
        this.fileType = fileType;
    }

    @Nonnull
    public Action getAction() {
        return this.action;
    }

    @Nonnull
    public File[] getFiles() {
        return this.files;
    }

    @Nonnull
    public FileType getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraHomeChangeEvent)) {
            return false;
        }
        JiraHomeChangeEvent that = (JiraHomeChangeEvent)o;
        if (this.action != that.action) {
            return false;
        }
        if (this.fileType != that.fileType) {
            return false;
        }
        return Arrays.equals(this.files, that.files);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.fileType.hashCode();
        return result;
    }

    public static enum FileType {
        ATTACHMENT("jira.secondary.store.attachments.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateAttachments();
            }
        }
        ,
        INDEX_SNAPSHOT("jira.secondary.store.index.snapshots.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateIndexSnapshots();
            }
        }
        ,
        AVATAR("jira.secondary.store.avatars.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateAvatars();
            }
        }
        ,
        PLUGIN("jira.secondary.store.plugins.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicatePlugins();
            }
        };

        private String key;

        private FileType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        abstract JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService var1);
    }

    public static enum Action {
        FILE_ADD,
        FILE_DELETED;

    }
}

