/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.lifecycle.LifecycleState;

public class CachingMutablePicoContainer
implements MutablePicoContainer {
    private final MutablePicoContainer delegatePicoContainer;
    private final ConcurrentMap<Object, Object> componentCache = new ConcurrentHashMap<Object, Object>();

    public CachingMutablePicoContainer(MutablePicoContainer delegatePicoContainer) {
        this.delegatePicoContainer = delegatePicoContainer;
    }

    public MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Parameter ... parameters) {
        this.delegatePicoContainer.addComponent(componentKey, componentImplementationOrInstance, parameters);
        return this;
    }

    public MutablePicoContainer addComponent(Object implOrInstance) {
        this.delegatePicoContainer.addComponent(implOrInstance);
        return this;
    }

    public MutablePicoContainer addConfig(String name, Object val) {
        this.delegatePicoContainer.addConfig(name, val);
        return this;
    }

    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) {
        this.delegatePicoContainer.addAdapter(componentAdapter);
        return this;
    }

    public <T> ComponentAdapter<T> removeComponent(Object componentKey) {
        this.componentCache.remove(componentKey);
        return this.delegatePicoContainer.removeComponent(componentKey);
    }

    public <T> ComponentAdapter<T> removeComponentByInstance(T componentInstance) {
        ComponentAdapter removedComponent = this.delegatePicoContainer.removeComponentByInstance(componentInstance);
        if (removedComponent != null) {
            this.componentCache.remove(removedComponent.getComponentKey());
        }
        return removedComponent;
    }

    public MutablePicoContainer makeChildContainer() {
        this.delegatePicoContainer.makeChildContainer();
        return this;
    }

    public MutablePicoContainer addChildContainer(PicoContainer child) {
        this.delegatePicoContainer.addChildContainer(child);
        return this;
    }

    public boolean removeChildContainer(PicoContainer child) {
        return this.delegatePicoContainer.removeChildContainer(child);
    }

    public MutablePicoContainer change(Properties ... properties) {
        this.delegatePicoContainer.change(properties);
        return this;
    }

    public MutablePicoContainer as(Properties ... properties) {
        this.delegatePicoContainer.as(properties);
        return this;
    }

    public void setName(String name) {
        this.delegatePicoContainer.setName(name);
    }

    public void setLifecycleState(LifecycleState lifecycleState) {
        this.delegatePicoContainer.setLifecycleState(lifecycleState);
    }

    public String getName() {
        return this.delegatePicoContainer.getName();
    }

    public LifecycleState getLifecycleState() {
        return this.delegatePicoContainer.getLifecycleState();
    }

    public Object getComponent(Object componentKeyOrType) {
        return this.delegatePicoContainer.getComponent(componentKeyOrType);
    }

    public Object getComponent(Object componentKeyOrType, Type into) {
        return this.delegatePicoContainer.getComponent(componentKeyOrType, into);
    }

    public <T> T getComponent(Class<T> componentType) {
        Object component = this.componentCache.get(componentType);
        if (component != null) {
            return (T)component;
        }
        component = this.delegatePicoContainer.getComponent(componentType);
        if (component != null) {
            this.componentCache.putIfAbsent(componentType, component);
        }
        return (T)component;
    }

    public <T> T getComponent(Class<T> componentType, Class<? extends Annotation> binding) {
        return (T)this.delegatePicoContainer.getComponent(componentType, binding);
    }

    public List<Object> getComponents() {
        return this.delegatePicoContainer.getComponents();
    }

    public PicoContainer getParent() {
        return this.delegatePicoContainer.getParent();
    }

    public ComponentAdapter<?> getComponentAdapter(Object componentKey) {
        return this.delegatePicoContainer.getComponentAdapter(componentKey);
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, NameBinding componentNameBinding) {
        return this.delegatePicoContainer.getComponentAdapter(componentType, componentNameBinding);
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.delegatePicoContainer.getComponentAdapter(componentType, binding);
    }

    public Collection<ComponentAdapter<?>> getComponentAdapters() {
        return this.delegatePicoContainer.getComponentAdapters();
    }

    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType) {
        return this.delegatePicoContainer.getComponentAdapters(componentType);
    }

    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.delegatePicoContainer.getComponentAdapters(componentType, binding);
    }

    public <T> List<T> getComponents(Class<T> componentType) {
        return this.delegatePicoContainer.getComponents(componentType);
    }

    public void accept(PicoVisitor visitor) {
        this.delegatePicoContainer.accept(visitor);
    }

    public void start() {
        this.delegatePicoContainer.start();
    }

    public void stop() {
        this.delegatePicoContainer.stop();
    }

    public void dispose() {
        this.delegatePicoContainer.dispose();
        this.componentCache.clear();
    }
}

