/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.config.feature.FeaturesLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.io.ResourceLoader;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreFeaturesLoader
implements FeaturesLoader {
    public static final String FEATURE_RESOURCE_TYPE = "feature";
    public static final String CORE_FEATURES_RESOURCE = "/jira-features.properties";
    private static final Resources.TypeFilter FEATURE_TYPE_FILTER = new Resources.TypeFilter("feature");
    private static final Logger log = LoggerFactory.getLogger(CoreFeaturesLoader.class);
    private final JiraProperties jiraSystemProperties;
    private final ResourceLoader resourceLoader;
    private final PluginAccessor pluginAccessor;

    public CoreFeaturesLoader(JiraProperties jiraSystemProperties, PluginAccessor pluginAccessor, ResourceLoader resourceLoader) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.pluginAccessor = pluginAccessor;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Properties loadCoreProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getSalDarkFeatures());
        properties.putAll((Map<?, ?>)this.getCoreFeatures());
        properties.putAll(this.getSystemDarkFeatures());
        return properties;
    }

    @Override
    public Iterable<Properties> loadPluginsFeatureProperties() {
        Stream<Properties> allResources = this.pluginAccessor.getEnabledPlugins().stream().flatMap(this::getFeatureResources);
        return allResources.map(this::getPropertiesFromPlugin).collect(Collectors.toList());
    }

    @Override
    public boolean hasFeatureResources(Plugin plugin) {
        return this.getFeatureResources(plugin).findAny().isPresent();
    }

    private Properties getPropertiesFromPlugin(Pair<ResourceDescriptor, Plugin> pluginFeatureDesc) {
        return this.loadRequiredProperties((Function<String, Option<InputStream>>)((Function)path -> this.resourceLoader.getResourceAsStream((Plugin)pluginFeatureDesc.right(), (String)path)), ((ResourceDescriptor)pluginFeatureDesc.left()).getLocation());
    }

    private Properties loadRequiredProperties(Function<String, Option<InputStream>> resourceLoader, String path) {
        Function rethrowException = exception -> {
            throw new RuntimeIOException("Unable to load properties from " + path, exception);
        };
        Supplier missingFileExceptionSupplier = () -> {
            throw new IllegalStateException(String.format("Resource %s not found", path));
        };
        Function unFoldProperties = propertiesOption -> (Properties)propertiesOption.getOrThrow(missingFileExceptionSupplier);
        return (Properties)this.tryLoadProperties((Supplier<Option<InputStream>>)((Supplier)() -> (Option)resourceLoader.apply((Object)path))).fold(rethrowException, unFoldProperties);
    }

    private Either<IOException, Option<Properties>> tryLoadProperties(Supplier<Option<InputStream>> resourceSupplier) {
        Option streamOption = (Option)resourceSupplier.get();
        Supplier emptyPropertiesSupplier = () -> Either.right((Object)Option.none());
        return (Either)streamOption.map(this::tryLoadProperties).getOrElse(emptyPropertiesSupplier);
    }

    private Either<IOException, Option<Properties>> tryLoadProperties(InputStream propStream) {
        Properties props = new Properties();
        try {
            props.load(propStream);
        }
        catch (IOException e) {
            return Either.left((Object)e);
        }
        return Either.right((Object)Option.some((Object)props));
    }

    private Properties getCoreFeatures() {
        return this.loadRequiredProperties((Function<String, Option<InputStream>>)((Function)this.resourceLoader::getResourceAsStream), CORE_FEATURES_RESOURCE);
    }

    private Map<Object, Object> getSalDarkFeatures() {
        String salDarkFeaturesProperty = this.jiraSystemProperties.getProperty("darkfeatures.properties.file", "atlassian-darkfeatures.properties");
        Supplier emptyProperties = Properties::new;
        return (Map)this.tryLoadProperties((Supplier<Option<InputStream>>)((Supplier)() -> this.resourceLoader.getResourceAsStream(salDarkFeaturesProperty))).fold(ex -> Collections.emptyMap(), propertiesOption -> (Properties)propertiesOption.getOrElse(emptyProperties));
    }

    private Map<Object, Object> getSystemDarkFeatures() {
        Stream<String> systemFeatureNames = this.jiraSystemProperties.getProperties().stringPropertyNames().stream().filter(key -> key.startsWith("atlassian.darkfeature."));
        Map<Object, Object> systemProperties = systemFeatureNames.collect(Collectors.toMap(key -> key.substring("atlassian.darkfeature.".length(), key.length()), arg_0 -> ((JiraProperties)this.jiraSystemProperties).getProperty(arg_0)));
        if (log.isDebugEnabled()) {
            systemProperties.entrySet().stream().forEach(entry -> log.trace("Feature '{}' is set to '{}' by system properties", entry.getKey(), entry.getValue()));
        }
        return systemProperties;
    }

    private Stream<Pair<ResourceDescriptor, Plugin>> getFeatureResources(Plugin plugin) {
        return plugin.getResourceDescriptors().stream().filter(arg_0 -> ((Resources.TypeFilter)FEATURE_TYPE_FILTER).apply(arg_0)).map(resource -> new Pair(resource, (Object)plugin));
    }
}

