/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import com.atlassian.jira.config.feature.FeatureFlagModuleDescriptor;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class FeatureFlagProviderAccessor {
    private final PluginAccessor pluginAccessor;

    public FeatureFlagProviderAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Map<String, FeatureFlag> getFeatureFlags() {
        final HashMap flags = Maps.newHashMap();
        SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(FeatureFlagModuleDescriptor.class, (PluginPointFunction)new PluginPointFunction<FeatureFlagModuleDescriptor, FeatureFlagProvider, Unit>(){

            public Unit onModule(FeatureFlagModuleDescriptor moduleDescriptor, FeatureFlagProvider provider) {
                for (FeatureFlag flag : moduleDescriptor.getFeatureFlags()) {
                    flags.put(flag.featureKey(), flag);
                }
                return Unit.VALUE;
            }
        });
        return flags;
    }

    public Option<FeatureFlag> findFeatureFlag(String featureKey) {
        FeatureFlag featureFlag = this.getFeatureFlags().get(featureKey);
        return Option.option((Object)featureFlag);
    }
}

