/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraDirectorySynchroniser
implements JobRunner {
    public static final String CROWD_SYNC_INCREMENTAL_ENABLED = "crowd.sync.incremental.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(JobRunnerResponse.class);

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        SynchronisationStatusManager synchronisationStatusManager = (SynchronisationStatusManager)ComponentAccessor.getComponent(SynchronisationStatusManager.class);
        DirectorySynchroniser directorySynchroniser = (DirectorySynchroniser)ComponentAccessor.getComponent(DirectorySynchroniser.class);
        CrowdDirectoryService directoryService = (CrowdDirectoryService)ComponentAccessor.getComponent(CrowdDirectoryService.class);
        DirectoryInstanceLoader directoryInstanceLoader = (DirectoryInstanceLoader)ComponentAccessor.getComponent(DirectoryInstanceLoader.class);
        Map params = request.getJobConfig().getParameters();
        Long directoryId = (Long)params.get("DIRECTORY_ID");
        try {
            Directory directory = directoryService.findDirectoryById(directoryId.longValue());
            if (directory != null) {
                RemoteDirectory remoteDirectory = directoryInstanceLoader.getDirectory(directory);
                if (remoteDirectory instanceof SynchronisableDirectory) {
                    this.synchronizeDirectory(directorySynchroniser, directory, (SynchronisableDirectory)remoteDirectory);
                } else {
                    LOG.error("Unable to synchronise directory; not an instance of SynchronisableDirectory.class");
                }
                DirectorySynchronisationInformation info = synchronisationStatusManager.getDirectorySynchronisationInformation(directory);
                return JobRunnerResponse.success((String)("Directory '" + directory.getName() + "' synchronised in " + info.getLastRound().getDurationMs() + " milliseconds."));
            }
            throw new DirectoryNotFoundException(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            LOG.error("Unable to synchronise directory", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        catch (OperationFailedException e) {
            LOG.error("Unable to synchronise directory", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error("Unable to synchronise directory", (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    void synchronizeDirectory(DirectorySynchroniser directorySynchroniser, Directory directory, SynchronisableDirectory remoteDirectory) throws DirectoryNotFoundException, OperationFailedException {
        SynchronisationMode synchronisationMode = this.getSynchronisationMode(directory);
        directorySynchroniser.synchronise(remoteDirectory, synchronisationMode);
    }

    private SynchronisationMode getSynchronisationMode(Directory directory) {
        Map attributes = directory.getAttributes();
        if (attributes == null) {
            return SynchronisationMode.INCREMENTAL;
        }
        String syncMode = (String)attributes.get(CROWD_SYNC_INCREMENTAL_ENABLED);
        if (syncMode == null || "true".equals(syncMode)) {
            return SynchronisationMode.INCREMENTAL;
        }
        return SynchronisationMode.FULL;
    }
}

