/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.DashboardItemStateVisitor;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.dashboard.JiraDashboardChangeHandler;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraDashboardStateStoreManager
implements DashboardStateStore {
    private static final Logger log = LoggerFactory.getLogger(JiraDashboardStateStoreManager.class);
    private final ClusterLockService clusterLockService;
    private final PortalPageManager portalPageManager;
    private final PortalPageStore portalPageStore;
    private final PortletConfigurationStore portletConfigurationStore;
    private final Function<PortletConfiguration, DashboardItemState> toDashboardItemState = new Function<PortletConfiguration, DashboardItemState>(){

        public DashboardItemState apply(PortletConfiguration portletConfiguration) {
            Option openSocialSpecUri = portletConfiguration.getOpenSocialSpecUri();
            Option moduleKey = portletConfiguration.getCompleteModuleKey();
            if (openSocialSpecUri.isDefined() && moduleKey.isDefined()) {
                return this.createLocalDashboardItem(portletConfiguration);
            }
            if (moduleKey.isDefined()) {
                return this.createLocalDashboardItem(portletConfiguration);
            }
            if (openSocialSpecUri.isDefined()) {
                return this.createOpenSocialGadget(portletConfiguration, (URI)openSocialSpecUri.get());
            }
            URI uriToLegacyGadget = URI.create("/invalid/legacy/portlet/Please_remove_this_gadget_from_your_dashboard!");
            return this.createOpenSocialGadget(portletConfiguration, uriToLegacyGadget);
        }

        private DashboardItemState createLocalDashboardItem(PortletConfiguration portletConfiguration) {
            return LocalDashboardItemState.builder().gadgetId(this.getGadgetId(portletConfiguration)).color(portletConfiguration.getColor()).properties(portletConfiguration.getUserPrefs()).dashboardItemModuleId(this.getLocalDashboardItemModuleId(portletConfiguration)).build();
        }

        private LocalDashboardItemModuleId getLocalDashboardItemModuleId(PortletConfiguration portletConfiguration) {
            ModuleCompleteKey fullModuleKey = (ModuleCompleteKey)portletConfiguration.getCompleteModuleKey().get();
            Option openSocialId = portletConfiguration.getOpenSocialSpecUri().map((Function)new Function<URI, OpenSocialDashboardItemModuleId>(){

                public OpenSocialDashboardItemModuleId apply(URI openSocialSpecUri) {
                    return new OpenSocialDashboardItemModuleId(openSocialSpecUri);
                }
            });
            return new LocalDashboardItemModuleId(fullModuleKey, openSocialId);
        }

        private DashboardItemState createOpenSocialGadget(PortletConfiguration portletConfiguration, URI gadgetUri) {
            return GadgetState.gadget((GadgetId)this.getGadgetId(portletConfiguration)).specUri(gadgetUri).color(portletConfiguration.getColor()).userPrefs(portletConfiguration.getUserPrefs()).build();
        }

        private GadgetId getGadgetId(PortletConfiguration portletConfiguration) {
            return GadgetId.valueOf((String)portletConfiguration.getId().toString());
        }
    };

    public JiraDashboardStateStoreManager(PortalPageStore portalPageStore, PortletConfigurationStore portletConfigurationStore, PortalPageManager portalPageManager, ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
        this.portalPageManager = portalPageManager;
        this.portalPageStore = portalPageStore;
        this.portletConfigurationStore = portletConfigurationStore;
    }

    @VisibleForTesting
    static String getWriteLockName(DashboardId dashboardId) {
        return JiraDashboardStateStoreManager.class.getName() + ".dashboard-" + dashboardId;
    }

    public DashboardState retrieve(DashboardId dashboardId) throws DashboardNotFoundException, DashboardStateStoreException {
        DashboardState dashboardState;
        Long versionAfter;
        Long versionBefore;
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        Long portalPageId = DashboardUtil.toLong((DashboardId)dashboardId);
        do {
            versionBefore = this.getPortalPageVersion(portalPageId);
            dashboardState = this.getDashboardState(dashboardId, portalPageId);
        } while (!ObjectUtils.equals((Object)versionBefore, (Object)(versionAfter = this.getPortalPageVersion(portalPageId))));
        return dashboardState;
    }

    @Nullable
    private Long getPortalPageVersion(@Nullable Long portalPageId) {
        if (portalPageId == null) {
            return null;
        }
        PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
        return portalPage == null ? null : portalPage.getVersion();
    }

    private DashboardState getDashboardState(DashboardId dashboardId, Long portalPageId) {
        try {
            PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
            if (portalPage == null) {
                throw new DashboardNotFoundException(dashboardId);
            }
            List pcColumns = this.portalPageManager.getPortletConfigurations(portalPageId);
            Iterable dashboardColumns = Iterables.transform((Iterable)pcColumns, (Function)new Function<List<PortletConfiguration>, Iterable<DashboardItemState>>(){

                public Iterable<DashboardItemState> apply(List<PortletConfiguration> input) {
                    return Iterables.transform(input, (Function)JiraDashboardStateStoreManager.this.toDashboardItemState);
                }
            });
            return DashboardState.dashboard((DashboardId)dashboardId).title(portalPage.getName()).version(portalPage.getVersion() == null ? 1L : portalPage.getVersion()).dashboardColumns(dashboardColumns).layout(portalPage.getLayout()).build();
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Unknown error occurred while retrieving dashboard with id '" + portalPageId + "'.", (Throwable)e);
        }
    }

    public DashboardState update(DashboardState dashboardState, Iterable<DashboardChange> dashboardChanges) throws DashboardStateStoreException {
        Assertions.notNull((String)"dashboardState", (Object)dashboardState);
        Assertions.notNull((String)"dashboardChanges", dashboardChanges);
        DashboardId dashboardId = dashboardState.getId();
        ClusterLock writeLock = this.clusterLockService.getLockForName(JiraDashboardStateStoreManager.getWriteLockName(dashboardId));
        writeLock.lock();
        try {
            this.acquireOptimisticWriteLock(dashboardState);
            if (!dashboardChanges.iterator().hasNext()) {
                DashboardState dashboardState2 = this.storeDashboardState(dashboardState);
                return dashboardState2;
            }
            new JiraDashboardChangeHandler(dashboardState, this.portletConfigurationStore, this.portalPageStore).accept(dashboardChanges);
            DashboardState storedState = this.retrieve(dashboardId);
            if (!storedState.equals((Object)dashboardState)) {
                log.warn("Stored state for dashboard with id '{}' is not the same as in-memory state. Trying to rewrite the entire state...", (Object)dashboardId);
                DashboardState dashboardState3 = this.storeDashboardState(dashboardState);
                return dashboardState3;
            }
            DashboardState dashboardState4 = storedState;
            return dashboardState4;
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error updating dashboard state with id '" + dashboardId + "'.", (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void acquireOptimisticWriteLock(DashboardState dashboardState) {
        DashboardId dashboardId = dashboardState.getId();
        boolean optimisticLock = this.portalPageStore.updatePortalPageOptimisticLock(DashboardUtil.toLong((DashboardId)dashboardId), dashboardState.getVersion());
        if (!optimisticLock) {
            throw new DashboardStateStoreException("Dashboard with id '" + dashboardId + "' is out of sync with the currently persisted state.");
        }
    }

    public void remove(DashboardId dashboardId) throws DashboardStateStoreException {
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        Long portalPageId = DashboardUtil.toLong((DashboardId)dashboardId);
        ClusterLock writeLock = this.clusterLockService.getLockForName(JiraDashboardStateStoreManager.getWriteLockName(dashboardId));
        writeLock.lock();
        try {
            this.portalPageManager.delete(portalPageId);
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error removing dashboard state with id'" + dashboardId + "'.", (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public DashboardState findDashboardWithGadget(GadgetId gadgetId) throws DashboardNotFoundException {
        Assertions.notNull((String)"gagdetId", (Object)gadgetId);
        try {
            PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(DashboardUtil.toLong((GadgetId)gadgetId));
            if (portletConfiguration == null) {
                throw new DashboardStateStoreException("Gadget with id '" + gadgetId + "' not found!");
            }
            return this.retrieve(DashboardId.valueOf((String)Long.toString(portletConfiguration.getDashboardPageId())));
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error looking up gadget with id '" + gadgetId + "'.", (Throwable)e);
        }
    }

    private DashboardState storeDashboardState(DashboardState dashboardState) {
        Assertions.notNull((String)"dashboardState", (Object)dashboardState);
        DashboardId dashboardId = dashboardState.getId();
        long portalPageId = DashboardUtil.toLong((DashboardId)dashboardId);
        PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
        if (portalPage == null) {
            throw new DashboardStateStoreException("No portal page found with id '" + portalPageId + "'");
        }
        this.updatePortalPage(portalPage, dashboardState);
        Map<Long, PortletConfiguration> oldPortlets = this.portletSeqToMap(this.portletConfigurationStore.getByPortalPage(portalPageId));
        Map<Long, PortletConfiguration> newPortlets = this.portletSeqToMap(this.getPortletsFromDashboardState(dashboardState));
        MapDifference difference = Maps.difference(oldPortlets, newPortlets);
        Collection portletsToUpdate = Maps.transformValues((Map)difference.entriesDiffering(), (Function)new Function<MapDifference.ValueDifference<PortletConfiguration>, PortletConfiguration>(){

            public PortletConfiguration apply(MapDifference.ValueDifference<PortletConfiguration> input) {
                return (PortletConfiguration)input.rightValue();
            }
        }).values();
        Collection portletsToAdd = difference.entriesOnlyOnRight().values();
        Collection portletsToRemove = difference.entriesOnlyOnLeft().values();
        for (PortletConfiguration toUpdate : portletsToUpdate) {
            this.portletConfigurationStore.store(toUpdate);
        }
        for (PortletConfiguration toAdd : portletsToAdd) {
            this.portletConfigurationStore.addDashboardItem(toAdd.getDashboardPageId(), toAdd.getId(), toAdd.getColumn(), toAdd.getRow(), (Option<URI>)toAdd.getOpenSocialSpecUri(), toAdd.getColor(), toAdd.getUserPrefs(), (Option<ModuleCompleteKey>)toAdd.getCompleteModuleKey());
        }
        for (PortletConfiguration toRemove : portletsToRemove) {
            this.portletConfigurationStore.delete(toRemove);
        }
        return this.retrieve(dashboardId);
    }

    private void updatePortalPage(PortalPage portalPage, DashboardState dashboardState) {
        if (!portalPage.getLayout().equals((Object)dashboardState.getLayout()) || !StringUtils.equals((String)portalPage.getName(), (String)dashboardState.getTitle())) {
            PortalPage.Builder builder = PortalPage.portalPage((PortalPage)portalPage);
            builder.name(dashboardState.getTitle());
            builder.layout(dashboardState.getLayout());
            this.portalPageStore.update(builder.build());
        }
    }

    private Iterable<PortletConfiguration> getPortletsFromDashboardState(DashboardState dashboardState) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (DashboardState.ColumnIndex columnIndex : dashboardState.getLayout().getColumnRange()) {
            int row = 0;
            for (DashboardItemState dashboardItemState : dashboardState.getDashboardColumns().getItemsInColumn(columnIndex)) {
                listBuilder.add((Object)this.toPortletConfiguration(dashboardItemState, DashboardUtil.toLong((DashboardId)dashboardState.getId()), columnIndex.index(), row));
                ++row;
            }
        }
        return listBuilder.build();
    }

    private PortletConfiguration toPortletConfiguration(DashboardItemState dashboardItemState, final Long page, final Integer column, final Integer row) {
        final long itemId = DashboardUtil.toLong((GadgetId)dashboardItemState.getId());
        return (PortletConfiguration)dashboardItemState.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<PortletConfiguration>(){

            public PortletConfiguration visit(GadgetState state) {
                return new PortletConfigurationImpl(itemId, page, column, row, (Option<URI>)Option.some((Object)state.getGadgetSpecUri()), state.getColor(), state.getUserPrefs(), (Option<ModuleCompleteKey>)Option.none());
            }

            public PortletConfiguration visit(LocalDashboardItemState state) {
                Option openSocialSpecUri = state.getDashboardItemModuleId().getReplacedGadgetId().map((Function)new Function<OpenSocialDashboardItemModuleId, URI>(){

                    public URI apply(OpenSocialDashboardItemModuleId input) {
                        return input.getSpecUri();
                    }
                });
                Option moduleKey = Option.some((Object)state.getDashboardItemModuleId().getFullModuleKey());
                return new PortletConfigurationImpl(itemId, page, column, row, (Option<URI>)openSocialSpecUri, state.getColor(), Collections.emptyMap(), (Option<ModuleCompleteKey>)moduleKey);
            }
        });
    }

    private Map<Long, PortletConfiguration> portletSeqToMap(Iterable<PortletConfiguration> portlets) {
        return Maps.uniqueIndex(portlets, (Function)new Function<PortletConfiguration, Long>(){

            public Long apply(PortletConfiguration portletConfiguration) {
                return portletConfiguration.getId();
            }
        });
    }
}

