/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnectionImpl;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.mysema.query.sql.H2Templates;
import com.mysema.query.sql.HSQLDBTemplates;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.OracleTemplates;
import com.mysema.query.sql.PostgresTemplates;
import com.mysema.query.sql.SQLServerTemplates;
import com.mysema.query.sql.SQLTemplates;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConnectionManagerImpl
implements DbConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(DbConnectionManagerImpl.class);
    private final OfBizConnectionFactory ofBizConnectionFactory;
    private final SQLTemplates dialect;
    private final DelegatorInterface delegatorInterface;

    public DbConnectionManagerImpl(DatabaseConfigurationManager databaseConfigurationManager, DelegatorInterface delegatorInterface) {
        this.delegatorInterface = delegatorInterface;
        this.ofBizConnectionFactory = DefaultOfBizConnectionFactory.getInstance();
        DatabaseConfig databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
        SQLTemplates.Builder dialectBuilder = DbConnectionManagerImpl.findDialectBuilder(databaseConfig);
        if (!StringUtils.isEmpty((String)databaseConfig.getSchemaName())) {
            dialectBuilder.printSchema();
        }
        this.dialect = dialectBuilder.build();
    }

    private static SQLTemplates.Builder findDialectBuilder(DatabaseConfig databaseConfig) {
        if (databaseConfig.isMySql()) {
            return MySQLTemplates.builder();
        }
        if (databaseConfig.isPostgres()) {
            return PostgresTemplates.builder();
        }
        if (databaseConfig.isOracle()) {
            return OracleTemplates.builder();
        }
        if (databaseConfig.isSqlServer()) {
            return SQLServerTemplates.builder();
        }
        if (databaseConfig.isH2()) {
            return H2Templates.builder();
        }
        if (databaseConfig.isHSql()) {
            return HSQLDBTemplates.builder();
        }
        throw new IllegalStateException("Unrecognised database dialect '" + databaseConfig.getDatabaseType() + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
        Connection con = this.borrowConnection();
        try {
            T t = callback.runQuery(new DbConnectionImpl(con, this.getDialect(), this.delegatorInterface));
            return t;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error("Unable to close database connection.", (Throwable)ex);
            }
        }
    }

    private Connection borrowConnection() {
        try {
            return this.ofBizConnectionFactory.getConnection();
        }
        catch (SQLException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Override
    @Nonnull
    public SQLTemplates getDialect() {
        return this.dialect;
    }

    @Override
    public void execute(@Nonnull SqlCallback callback) {
        Connection con = this.borrowConnection();
        try {
            callback.run(new DbConnectionImpl(con, this.getDialect(), this.delegatorInterface));
        }
        catch (RuntimeException ex) {
            try {
                if (!con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException sqlEx) {
                log.error("Unable to rollback SQL connection.", (Throwable)sqlEx);
            }
            throw ex;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error("Unable to close SQL connection.", (Throwable)ex);
            }
        }
    }
}

