/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DebugListener
extends AbstractIssueEventListener
implements UserEventListener {
    public void init(Map params) {
        this.log("DebugListener.init");
        this.log(params.toString());
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    public void issueAssigned(IssueEvent event) {
        this.log("DebugListener.issueAssigned");
        this.logEvent((JiraEvent)event);
    }

    public void issueClosed(IssueEvent event) {
        this.log("DebugListener.issueClosed");
        this.logEvent((JiraEvent)event);
    }

    public void issueCreated(IssueEvent event) {
        this.log("DebugListener.issueCreated");
        this.logEvent((JiraEvent)event);
    }

    public void issueResolved(IssueEvent event) {
        this.log("DebugListener.issueResolved");
        this.logEvent((JiraEvent)event);
    }

    public void issueReopened(IssueEvent event) {
        this.log("DebugListener.issueReopened");
        this.logEvent((JiraEvent)event);
    }

    public void issueUpdated(IssueEvent event) {
        this.log("DebugListener.issueUpdated");
        try {
            List changeItems = event.getChangeLog().getRelated("ChildChangeItem");
            for (GenericValue changeItem : changeItems) {
                this.log("\t" + changeItem.get("field") + " changed from '" + changeItem.get("oldstring") + "' to '" + changeItem.get("newstring") + "'");
            }
        }
        catch (GenericEntityException e) {
            this.log("Error: " + (Object)((Object)e));
        }
        this.logEvent((JiraEvent)event);
    }

    public void issueCommented(IssueEvent event) {
        this.log("DebugListener.issueCommented");
        this.logEvent((JiraEvent)event);
    }

    public void issueDeleted(IssueEvent event) {
        this.log("DebugListener.issueCommented");
        this.logEvent((JiraEvent)event);
    }

    public void issueMoved(IssueEvent event) {
        this.log("DebugListener.issueMoved");
        this.logEvent((JiraEvent)event);
    }

    public void issueWorkLogged(IssueEvent event) {
        this.log("DebugListener.issueWorkLogged");
        this.logEvent((JiraEvent)event);
    }

    public void issueGenericEvent(IssueEvent event) {
        this.log("DebugListener.issueGenericEvent");
        this.logEvent((JiraEvent)event);
    }

    public void customEvent(IssueEvent event) {
        this.log("DebugListener.customEvent");
        this.logEvent((JiraEvent)event);
    }

    public void userSignup(UserEvent event) {
        this.log("DebugListener.userSignup");
        this.logEvent((JiraEvent)event);
    }

    public void userCreated(UserEvent event) {
        this.log("DebugListener.userCreated");
        this.logEvent((JiraEvent)event);
    }

    public void userForgotPassword(UserEvent event) {
        this.log("DebugListener.userForgotPassword");
        this.logEvent((JiraEvent)event);
    }

    public void userForgotUsername(UserEvent event) {
        this.log("DebugListener.userForgotUsername");
        this.logEvent((JiraEvent)event);
    }

    public void userCannotChangePassword(UserEvent event) {
        this.log("DebugListener.userCannotChangePassword");
        this.logEvent((JiraEvent)event);
    }

    private void logEvent(JiraEvent event) {
        try {
            if (event instanceof IssueEvent) {
                IssueEvent issueEvent = (IssueEvent)event;
                this.log("Issue: [#" + issueEvent.getIssue().getId() + "] " + issueEvent.getIssue().getSummary());
                this.log("Comment: " + issueEvent.getComment());
                this.log("Change Group: " + issueEvent.getChangeLog());
                this.log("Event Type: " + ComponentAccessor.getEventTypeManager().getEventType(issueEvent.getEventTypeId()).getName());
            } else if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                this.log("User: " + userEvent.getUser().getName() + " (" + userEvent.getUser().getEmailAddress() + ")");
            }
            this.log(" Time: " + event.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        System.err.println("[DebugListener]: " + msg);
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isUnique() {
        return false;
    }

    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.debug.desc");
    }
}

