/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.web.bean.i18n.TranslationStore;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapTranslationStore
implements TranslationStore {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTranslationStore.class);
    private final ResourceBundle resourceBundle;

    public BootstrapTranslationStore(Locale locale) {
        this.resourceBundle = DefaultResourceBundle.getDefaultResourceBundle(locale);
    }

    @Override
    public String get(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            LOG.warn("No bootstrap translation available for '{}'", (Object)key);
            LOG.debug("Missing resource: {}", (Object)key, (Object)mre);
            return key;
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.resourceBundle.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.resourceBundle.keySet();
    }
}

