/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.warmer.JiraWarmer;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nWarmer
implements JiraWarmer {
    private static final Logger log = LoggerFactory.getLogger(I18nWarmer.class);
    private final LocaleManager localeManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;

    public I18nWarmer(LocaleManager localeManager, I18nHelper.BeanFactory i18nBeanFactory) {
        this.localeManager = localeManager;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        log.info("Init i18n cache");
        try {
            this.getLocalesToWarm().forEach(arg_0 -> ((I18nHelper.BeanFactory)this.i18nBeanFactory).getInstance(arg_0));
        }
        catch (Exception e) {
            log.warn("Cannot eager init i18n cache failed", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        log.info("Initialised i18n cache in {}", (Object)(endTime - startTime));
    }

    private Set<Locale> getLocalesToWarm() {
        return ImmutableSet.builder().addAll((Iterable)this.localeManager.getInstalledLocales()).add((Object)Locale.ROOT).build();
    }
}

