/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizNodeIndexCounterStore {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizNodeIndexCounterStore.class);
    public static final String ENTITY_NAME = "NodeIndexCounter";
    public static final String ID = "id";
    public static final String VIEW_NAME = "IndexOperationMinId";
    public static final String NODE_ID = "nodeId";
    public static final String SENDING_NODE_ID = "sendingNodeId";
    public static final String INDEX_OP_ID = "indexOperationId";
    public static final String MIN = "min";
    private final OfBizDelegator ofBizDelegator;

    public OfBizNodeIndexCounterStore(OfBizDelegator ofBizDelegator, ClusterManager clusterManager) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public void storeHighestIdForNode(String receivingNodeId, String sendingNodeId, final long indexOperationId) {
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)receivingNodeId), (Object)new EntityExpr(SENDING_NODE_ID, EntityOperator.EQUALS, (Object)sendingNodeId));
        List gvs = this.ofBizDelegator.transform(ENTITY_NAME, (EntityCondition)new EntityConditionList((List)entityConditions, EntityOperator.AND), null, ID, new Transformation(){

            public void transform(GenericValue entity) {
                if (entity.getLong(OfBizNodeIndexCounterStore.INDEX_OP_ID) == null || entity.getLong(OfBizNodeIndexCounterStore.INDEX_OP_ID) < indexOperationId) {
                    entity.set(OfBizNodeIndexCounterStore.INDEX_OP_ID, (Object)indexOperationId);
                }
            }
        });
        if (gvs.isEmpty()) {
            try {
                gvs.add(this.ofBizDelegator.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)NODE_ID, (Object)receivingNodeId, (Object)SENDING_NODE_ID, (Object)sendingNodeId, (Object)INDEX_OP_ID, (Object)indexOperationId)));
            }
            catch (DataAccessException e) {
                LOG.warn("Error adding new entry to NodeIndexCounter", (Throwable)e);
            }
        }
    }

    private long getStartingPoint() {
        List gvs = this.ofBizDelegator.findByCondition(VIEW_NAME, null, (Collection)ImmutableList.of((Object)MIN));
        if (gvs.isEmpty() || ((GenericValue)gvs.get(0)).getLong(MIN) == null) {
            return 0L;
        }
        return ((GenericValue)gvs.get(0)).getLong(MIN) - 1L;
    }

    public long getIndexOperationCounterForNodeId(String receivingNodeId, String sendingNodeId) {
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)receivingNodeId), (Object)new EntityExpr(SENDING_NODE_ID, EntityOperator.EQUALS, (Object)sendingNodeId));
        List gvs = this.ofBizDelegator.findByAnd(ENTITY_NAME, (List)entityConditions);
        if (gvs.isEmpty()) {
            return this.getStartingPoint();
        }
        return ((GenericValue)gvs.get(0)).getLong(INDEX_OP_ID);
    }
}

