/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.attachment.AttachmentDeleteException;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentMoveException;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.AttachmentRuntimeException;
import com.atlassian.jira.issue.attachment.AttachmentStreamGetData;
import com.atlassian.jira.issue.attachment.AttachmentWriteException;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.RemoteAttachmentStore;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.UniqueIdentifierGenerator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import io.atlassian.blobstore.client.api.Access;
import io.atlassian.blobstore.client.api.BlobStoreService;
import io.atlassian.blobstore.client.api.Failure;
import io.atlassian.blobstore.client.api.GetResult;
import io.atlassian.blobstore.client.api.HeadResult;
import io.atlassian.blobstore.client.api.PutResult;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class BlobStoreAttachmentStore
implements RemoteAttachmentStore {
    private static final Access FOREVER_CACHE = Access.builder().setCacheControl(Access.CacheControl.FOREVER).build();
    private static final Logger log = LoggerFactory.getLogger(BlobStoreAttachmentStore.class);
    private final UniqueIdentifierGenerator uniqueIdentifierGenerator;

    public BlobStoreAttachmentStore(UniqueIdentifierGenerator uniqueIdentifierGenerator) {
        this.uniqueIdentifierGenerator = uniqueIdentifierGenerator;
    }

    private BlobStoreService getBlobStore() {
        BlobStoreService bss = (BlobStoreService)ComponentAccessor.getOSGiComponentInstanceOfType(BlobStoreService.class);
        return bss != null ? bss : FailingBlobStoreService.INSTANCE;
    }

    @Nonnull
    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, final com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        return this.getAttachmentData(attachmentKey, (com.atlassian.util.concurrent.Function<AttachmentGetData, A>)new com.atlassian.jira.util.Function<AttachmentGetData, A>(){

            public A get(AttachmentGetData attachmentGetData) {
                return inputStreamProcessor.get((Object)attachmentGetData.getInputStream());
            }
        });
    }

    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        final String attachmentId = attachmentKey.getAttachmentId().toString();
        Function<GetResult, AttachmentGetData> dataFromResult = new Function<GetResult, AttachmentGetData>(){

            public AttachmentGetData apply(GetResult getResult) {
                return new AttachmentStreamGetData(getResult.data(), getResult.head().contentLength());
            }
        };
        Function failure = BlobStoreAttachmentStore.reject(new Function<Failure, Throwable>(){

            public Throwable apply(Failure failure) {
                return new AttachmentReadException("Remote blobstore couldn't provide an input stream for attachment " + attachmentId + ": " + failure.message());
            }
        });
        Supplier notFound = new Supplier<Promise<A>>(){

            public Promise<A> get() {
                return Promises.rejected((Throwable)new NoAttachmentDataException("Remote blobstore couldn't find an entry for attachment " + attachmentId));
            }
        };
        Function result = BlobStoreAttachmentStore.fold(notFound, BlobStoreAttachmentStore.promise(Functions.identity()));
        Function fold = BlobStoreAttachmentStore.fold(failure, result);
        return this.getBlobStore().get(attachmentId, FOREVER_CACHE, Options.lift((Function)Functions.compose(this.toGoogleFunction(attachmentGetDataProcessor), (Function)dataFromResult))).flatMap(fold);
    }

    private <T, R> Function<T, R> toGoogleFunction(com.atlassian.util.concurrent.Function<T, R> inputStreamProcessor) {
        return com.atlassian.util.concurrent.Functions.toGoogleFunction(inputStreamProcessor);
    }

    @Nonnull
    public Promise<StoreAttachmentResult> putAttachment(@Nonnull StoreAttachmentBean storeAttachmentBean) {
        InputStream dataStream = storeAttachmentBean.getStream();
        String id = String.valueOf(storeAttachmentBean.getId());
        Long size = storeAttachmentBean.getSize();
        return this.putBlobToStore(dataStream, id, size);
    }

    private Promise<StoreAttachmentResult> putBlobToStore(final InputStream dataStream, String id, Long size) {
        Function failureFunction = BlobStoreAttachmentStore.reject(new Function<Failure, Throwable>(){

            public Throwable apply(Failure failure) {
                IOUtils.closeQuietly((InputStream)dataStream);
                return new AttachmentWriteException(failure.message());
            }
        });
        Function<PutResult, Promise<StoreAttachmentResult>> result = BlobStoreAttachmentStore.promise(new Function<PutResult, StoreAttachmentResult>(){

            public StoreAttachmentResult apply(PutResult result) {
                IOUtils.closeQuietly((InputStream)dataStream);
                PutResult.Status status = result.status();
                if (status == PutResult.Status.CREATED) {
                    return StoreAttachmentResult.created();
                }
                return StoreAttachmentResult.updated();
            }
        });
        Function<Either<Failure, PutResult>, Promise<StoreAttachmentResult>> fold = BlobStoreAttachmentStore.fold(failureFunction, result);
        return this.getBlobStore().put(id, dataStream, size).flatMap(fold);
    }

    @Nonnull
    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        final String attachmentId = attachmentKey.getAttachmentId().toString();
        Function failure = BlobStoreAttachmentStore.reject(new Function<Failure, Throwable>(){

            public Throwable apply(Failure failure) {
                return new AttachmentReadException("Remote blobstore couldn't provide an input stream for attachment " + attachmentId + ": " + failure.message());
            }
        });
        Function<Option<HeadResult>, Promise<Boolean>> result = BlobStoreAttachmentStore.promise(new Function<Option<HeadResult>, Boolean>(){

            public Boolean apply(Option<HeadResult> headResult) {
                return headResult.isDefined();
            }
        });
        Function<Either<Failure, Option<HeadResult>>, Promise<Boolean>> fold = BlobStoreAttachmentStore.fold(failure, result);
        return this.getBlobStore().head(attachmentId, FOREVER_CACHE).flatMap(fold);
    }

    @Nonnull
    public Promise<Unit> deleteAttachment(AttachmentKey attachmentKey) {
        return this.deleteBlob(attachmentKey.getAttachmentId().toString());
    }

    public Promise<Unit> deleteBlob(final String id) {
        Function<Failure, Throwable> failure = new Function<Failure, Throwable>(){

            public Throwable apply(Failure failure) {
                return new AttachmentDeleteException("Remote blobstore couldn't delete attachment " + id + ": " + failure.message());
            }
        };
        Function<Throwable, Unit> logFailure = new Function<Throwable, Unit>(){

            public Unit apply(Throwable t) {
                log.info("Logging and ignoring failure", t);
                return Unit.VALUE;
            }
        };
        Function<Boolean, Unit> success = new Function<Boolean, Unit>(){

            public Unit apply(Boolean wasDeleted) {
                if (!wasDeleted.booleanValue()) {
                    log.debug("Nothing to delete at id " + id);
                }
                return Unit.VALUE;
            }
        };
        Function fold = BlobStoreAttachmentStore.fold(BlobStoreAttachmentStore.promise(Functions.compose((Function)logFailure, (Function)failure)), BlobStoreAttachmentStore.promise(success));
        return this.getBlobStore().delete(id).flatMap(fold);
    }

    @Nonnull
    public Option<ErrorCollection> errors() {
        if (FailingBlobStoreService.INSTANCE.equals(this.getBlobStore())) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage("BlobStore client plugin is not available. Cannot access BlobStore attachment storage.");
            return Option.some((Object)errors);
        }
        return Option.none();
    }

    public Promise<Unit> moveAttachment(AttachmentKey oldAttachmentKey, AttachmentKey newAttachmentKey) {
        String newId;
        String oldId = oldAttachmentKey.getAttachmentId().toString();
        if (!oldId.equals(newId = newAttachmentKey.getAttachmentId().toString())) {
            return this.moveBlob(oldId, newId);
        }
        return Promises.promise((Object)Unit.VALUE);
    }

    private Promise<Unit> moveBlob(String oldId, String newId) {
        Function failure = BlobStoreAttachmentStore.reject(new Function<Failure, AttachmentMoveException>(){

            public AttachmentMoveException apply(Failure failure) {
                return new AttachmentMoveException(failure.message());
            }
        });
        Function fold = BlobStoreAttachmentStore.fold(failure, BlobStoreAttachmentStore.toUnitIgnoreResult());
        return this.getBlobStore().move(oldId, newId).flatMap(fold);
    }

    public Promise<Unit> copyAttachment(AttachmentKey sourceAttachmentKey, AttachmentKey newAttachmentKey) {
        String sourceId = sourceAttachmentKey.getAttachmentId().toString();
        String newId = newAttachmentKey.getAttachmentId().toString();
        Function reject = BlobStoreAttachmentStore.reject(new Function<Failure, Throwable>(){

            public Throwable apply(Failure failure) {
                return new AttachmentRuntimeException(failure.message());
            }
        });
        Function fold = BlobStoreAttachmentStore.fold(reject, BlobStoreAttachmentStore.toUnitIgnoreResult());
        return this.getBlobStore().copy(sourceId, newId).flatMap(fold);
    }

    @Nonnull
    public Promise<TemporaryAttachmentId> putTemporaryAttachment(InputStream inputStream, long size) {
        String tempId = this.uniqueIdentifierGenerator.getNextId();
        TemporaryAttachmentId temporaryAttachmentId = TemporaryAttachmentId.fromString((String)tempId);
        return this.putBlobToStore(inputStream, tempId, size).map(Functions.constant((Object)temporaryAttachmentId));
    }

    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        String destinationId = destinationKey.getAttachmentId().toString();
        return this.moveBlob(temporaryAttachmentId.toStringId(), destinationId);
    }

    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.deleteBlob(temporaryAttachmentId.toStringId());
    }

    private static <A> Function<A, Promise<Unit>> toUnitIgnoreResult() {
        return new Function<A, Promise<Unit>>(){

            public Promise<Unit> apply(Object ignore) {
                return Promises.promise((Object)Unit.VALUE);
            }
        };
    }

    private static <L, R, O> Function<Either<L, R>, O> fold(final Function<L, O> left, final Function<? super R, O> right) {
        return new Function<Either<L, R>, O>(){

            public O apply(Either<L, R> either) {
                return either.fold(left, right);
            }
        };
    }

    private static <A, B> Function<Option<A>, B> fold(final Supplier<B> none, final Function<A, B> some) {
        return new Function<Option<A>, B>(){

            public B apply(Option<A> op) {
                return op.fold(none, some);
            }
        };
    }

    private static <A, B> Function<A, Promise<B>> promise(Function<A, B> f) {
        return Functions.compose(BlobStoreAttachmentStore.promise(), f);
    }

    private static <A> Function<A, Promise<A>> promise() {
        return new Function<A, Promise<A>>(){

            public Promise<A> apply(A a) {
                return Promises.promise(a);
            }
        };
    }

    private static <A, B> Function<A, Promise<B>> reject(Function<A, ? extends Throwable> f) {
        return Functions.compose(BlobStoreAttachmentStore.reject(), f);
    }

    private static <A> Function<Throwable, Promise<A>> reject() {
        return new Function<Throwable, Promise<A>>(){

            public Promise<A> apply(Throwable t) {
                return Promises.rejected((Throwable)t);
            }
        };
    }

    private static final class FailingBlobStoreService
    implements BlobStoreService {
        private static final BlobStoreService INSTANCE = new FailingBlobStoreService();
        private static final String MESSAGE = "BlobStore Client Plugin not loaded";

        private FailingBlobStoreService() {
        }

        private <A> Promise<A> fail() {
            return Promises.rejected((Throwable)new UnsupportedOperationException(MESSAGE));
        }

        public <A> Promise<Either<Failure, A>> get(String key, Access options, Function<Option<GetResult>, A> f) {
            return this.fail();
        }

        public Promise<Either<Failure, PutResult>> put(String key, InputStream stream, Long contentLength) {
            return this.fail();
        }

        public Promise<Either<Failure, Boolean>> delete(String key) {
            return this.fail();
        }

        public Promise<Either<Failure, Boolean>> delete(String key, String hash) {
            return this.fail();
        }

        public Promise<Either<Failure, PutResult>> move(String sourceKey, String destinationKey) {
            return this.fail();
        }

        public Promise<Either<Failure, PutResult>> copy(String sourceKey, String destinationKey) {
            return this.fail();
        }

        public Promise<Either<Failure, Option<HeadResult>>> head(String key, Access options) {
            return this.fail();
        }

        public void reset() {
        }
    }
}

