/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy.get;

import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.store.strategy.get.AttachmentGetStrategy;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DualAttachmentGetStrategy
implements AttachmentGetStrategy {
    private static final Logger log = LoggerFactory.getLogger(DualAttachmentGetStrategy.class);
    private static final com.atlassian.util.concurrent.Function<InputStream, Integer> DISCARD_STREAM_FUNCTION = new com.atlassian.util.concurrent.Function<InputStream, Integer>(){

        public Integer get(InputStream input) {
            try {
                return IOUtils.copy((InputStream)input, (OutputStream)ByteStreams.nullOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    };
    private final StreamAttachmentStore primaryStore;
    private final StreamAttachmentStore secondaryStore;

    public DualAttachmentGetStrategy(StreamAttachmentStore primaryStore, StreamAttachmentStore secondaryStore) {
        this.primaryStore = primaryStore;
        this.secondaryStore = secondaryStore;
    }

    @Override
    public <A> Promise<A> getAttachmentData(final AttachmentKey attachmentKey, final com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        Effect<Throwable> handleBackgroundFailure = new Effect<Throwable>(){

            public void apply(Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("Error reading attachment from secondary store for attachment Id: {}", (Object)attachmentKey.getAttachmentId().toString(), (Object)throwable);
                }
            }
        };
        return this.primaryStore.getAttachmentData(attachmentKey, attachmentGetDataProcessor).done(new Effect<A>((Effect)handleBackgroundFailure){
            final /* synthetic */ Effect val$handleBackgroundFailure;
            {
                this.val$handleBackgroundFailure = effect;
            }

            public void apply(A ignore) {
                DualAttachmentGetStrategy.this.secondaryStore.getAttachment(attachmentKey, DISCARD_STREAM_FUNCTION).fail(this.val$handleBackgroundFailure);
            }
        }).fold(new Function<Throwable, Promise<A>>(){

            public Promise<A> apply(Throwable throwableFromPrimary) {
                return DualAttachmentGetStrategy.this.secondaryStore.getAttachmentData(attachmentKey, attachmentGetDataProcessor);
            }
        }, new Function<A, Promise<A>>(){

            public Promise<A> apply(A input) {
                return Promises.promise(input);
            }
        }).flatMap(Functions.identity());
    }

    @Override
    public Promise<Boolean> exists(final AttachmentKey attachmentKey) {
        return this.primaryStore.exists(attachmentKey).fold((Function)new Function<Throwable, Promise<Boolean>>(){

            public Promise<Boolean> apply(Throwable ignored) {
                return DualAttachmentGetStrategy.this.secondaryStore.exists(attachmentKey);
            }
        }, (Function)new Function<Boolean, Promise<Boolean>>(){

            public Promise<Boolean> apply(Boolean exists) {
                if (exists.booleanValue()) {
                    return Promises.promise((Object)true);
                }
                return DualAttachmentGetStrategy.this.secondaryStore.exists(attachmentKey);
            }
        }).flatMap(Functions.identity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DualAttachmentGetStrategy that = (DualAttachmentGetStrategy)o;
        return this.primaryStore.equals(that.primaryStore) && this.secondaryStore.equals(that.secondaryStore);
    }

    public int hashCode() {
        int result = this.primaryStore.hashCode();
        result = 31 * result + this.secondaryStore.hashCode();
        return result;
    }
}

