/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy.move;

import com.atlassian.fugue.Unit;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.store.strategy.move.ResendingAttachmentStreamCreator;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Function;
import com.google.common.util.concurrent.FutureCallback;
import java.io.InputStream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ResendToStoreFunction
implements Function<AttachmentGetData, Unit> {
    private final AttachmentKey attachmentKey;
    private final StreamAttachmentStore store;
    private final ResendingAttachmentStreamCreator resendingAttachmentStreamCreator;

    public ResendToStoreFunction(AttachmentKey attachmentKey, StreamAttachmentStore streamAttachmentStore, ResendingAttachmentStreamCreator resendingAttachmentStreamCreator) {
        this.attachmentKey = attachmentKey;
        this.store = streamAttachmentStore;
        this.resendingAttachmentStreamCreator = resendingAttachmentStreamCreator;
    }

    public Unit get(AttachmentGetData attachmentGetData) {
        Pair<InputStream, Effect<Object>> streamWithCloseHandler = this.resendingAttachmentStreamCreator.getInputStreamWithCloseHandler(attachmentGetData);
        Effect cleanup = (Effect)streamWithCloseHandler.second();
        try {
            StoreAttachmentBean storeAttachmentBean = new StoreAttachmentBean.Builder((InputStream)streamWithCloseHandler.first()).withSize(attachmentGetData.getSize()).withKey(this.attachmentKey).build();
            this.store.putAttachment(storeAttachmentBean).then(this.getFutureCallbackFromEffect((Effect<Object>)cleanup));
            return Unit.VALUE;
        }
        catch (RuntimeException e) {
            cleanup.apply((Object)Unit.VALUE);
            throw e;
        }
    }

    private FutureCallback<? super StoreAttachmentResult> getFutureCallbackFromEffect(final Effect<Object> cleanEffect) {
        return new FutureCallback<StoreAttachmentResult>(){

            public void onSuccess(StoreAttachmentResult result) {
                cleanEffect.apply((Object)result);
            }

            public void onFailure(Throwable t) {
                cleanEffect.apply((Object)t);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResendToStoreFunction that = (ResendToStoreFunction)o;
        return this.attachmentKey.equals((Object)that.attachmentKey) && this.resendingAttachmentStreamCreator.equals(that.resendingAttachmentStreamCreator) && this.store.equals(that.store);
    }

    public int hashCode() {
        int result = this.attachmentKey.hashCode();
        result = 31 * result + this.store.hashCode();
        result = 31 * result + this.resendingAttachmentStreamCreator.hashCode();
        return result;
    }
}

