/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class LongIdsValueHolder
extends LinkedList<Long> {
    public static final String NEW_VALUE_PREFIX = "nv_";
    private Set<String> valuesToAdd = Sets.newLinkedHashSet();
    private final Set<String> badStrings = Sets.newLinkedHashSet();

    public static LongIdsValueHolder fromFieldValuesHolder(String id, Map params) {
        Object o = params.get(id);
        if (o instanceof LongIdsValueHolder) {
            return (LongIdsValueHolder)o;
        }
        if (o instanceof Collection) {
            LongIdsValueHolder vh = new LongIdsValueHolder((List<Long>)new ArrayList<Long>((Collection)o));
            try {
                params.put(vh, id);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return vh;
        }
        return null;
    }

    public LongIdsValueHolder(List<Long> componentIds) {
        super(componentIds);
    }

    public LongIdsValueHolder(String[] value) {
        this((Collection<String>)(null == value ? null : Arrays.asList(value)));
    }

    public LongIdsValueHolder(Collection<String> value) {
        if (value != null && !value.isEmpty()) {
            for (String aValue : value) {
                try {
                    this.add(new Long(aValue));
                }
                catch (NumberFormatException e) {
                    this.handleNonNumericValue(aValue);
                }
            }
        }
    }

    public String getInputText() {
        LinkedHashSet allInputStrings = Sets.newLinkedHashSet(this.badStrings);
        return StringUtils.join((Collection)allInputStrings, (String)"");
    }

    public Set<String> getValuesToAdd() {
        return Collections.unmodifiableSet(this.valuesToAdd);
    }

    public void addBadId(Long componentId) {
        this.badStrings.add(Long.toString(componentId));
    }

    public void setValuesToAdd(Set<String> values) {
        this.valuesToAdd = Sets.newLinkedHashSet(values);
    }

    public void validateIds(Predicate<Long> predicate) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Long id = (Long)it.next();
            if (predicate.apply((Object)id)) continue;
            it.remove();
            this.addBadId(id);
        }
    }

    private void handleNonNumericValue(String aValue) {
        String normalizedValue = StringUtils.trim((String)StringUtils.remove((String)aValue, (String)NEW_VALUE_PREFIX));
        if (StringUtils.isBlank((String)normalizedValue)) {
            return;
        }
        if (StringUtils.startsWith((String)aValue, (String)NEW_VALUE_PREFIX)) {
            this.valuesToAdd.add(normalizedValue);
        } else {
            this.badStrings.add(normalizedValue);
        }
    }
}

