/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedImageRenderer;
import com.atlassian.renderer.embedded.EmbeddedResource;
import java.util.Map;

public class JiraEmbeddedImageRenderer
extends EmbeddedImageRenderer {
    private long attachmentId;
    private String attachmentSrc;
    private String attachmentName;
    private boolean isThumbNail;

    public JiraEmbeddedImageRenderer(RendererAttachmentManager attachmentManager) {
        super(attachmentManager);
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        EmbeddedImage image = (EmbeddedImage)resource;
        this.isThumbNail = image.isThumbNail();
        if (this.isThumbNail && !image.isExternal()) {
            try {
                RendererAttachment attachment = this.getAttachment(context, resource);
                this.attachmentId = attachment.getId();
                this.attachmentSrc = attachment.getSrc();
                this.attachmentName = attachment.getFileName();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return super.renderResource(resource, context);
    }

    protected String writeImage(String imageTag, Map<Object, Object> imageParams, RenderContext context) {
        if (this.isThumbNail) {
            String wrappedImageTag = "<a id=\"" + this.attachmentId + "_thumb\" href=\"" + this.attachmentSrc + "\" title=\"" + this.attachmentName + "\">" + imageTag + "</a>";
            return super.writeImage(wrappedImageTag, imageParams, context);
        }
        return super.writeImage(imageTag, imageParams, context);
    }
}

