/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class CzechAnalyzer
extends TextAnalyzer {
    private final Version matchVersion;
    private final Function<TokenStream, TokenStream> stemmingFilter;
    private final Function<TokenStream, TokenStream> stopWordFilter;

    public CzechAnalyzer(Version matchVersion, boolean indexing, Function<TokenStream, TokenStream> stemmingFilter, Function<TokenStream, TokenStream> stopWordFilter) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stemmingFilter = stemmingFilter;
        this.stopWordFilter = stopWordFilter;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingFilter.apply((Object)result);
        return result;
    }
}

