/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.managers.IssueAttachmentDeleteHelper;
import com.atlassian.jira.issue.managers.IssueDeleteHelper;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueDeleteHelper
implements IssueDeleteHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueDeleteHelper.class);
    private final IssueIndexManager indexManager;
    private final SubTaskManager subTaskManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final MailThreadManager mailThreadManager;
    private final CustomFieldManager customFieldManager;
    private final IssueManager issueManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final UserAssociationStore userAssociationStore;
    private final WorkflowManager workflowManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final IssueEventManager issueEventManager;
    private final EventPublisher eventPublisher;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final CommentManager commentManager;
    private final IssueAttachmentDeleteHelper attachmentDeleteHelper;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final WorklogManager worklogManager;

    public DefaultIssueDeleteHelper(IssueIndexManager indexManager, SubTaskManager subTaskManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, MailThreadManager mailThreadManager, CustomFieldManager customFieldManager, IssueManager issueManager, NodeAssociationStore nodeAssociationStore, WorkflowManager workflowManager, ChangeHistoryManager changeHistoryManager, IssueEventManager issueEventManager, UserAssociationStore userAssociationStore, EventPublisher eventPublisher, MovedIssueKeyStore movedIssueKeyStore, JsonEntityPropertyManager jsonEntityPropertyManager, CommentManager commentManager, IssueAttachmentDeleteHelper attachmentDeleteHelper, IssueEventBundleFactory issueEventBundleFactory, WorklogManager worklogManager) {
        this.indexManager = indexManager;
        this.subTaskManager = subTaskManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.mailThreadManager = mailThreadManager;
        this.customFieldManager = customFieldManager;
        this.issueManager = issueManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.userAssociationStore = userAssociationStore;
        this.workflowManager = workflowManager;
        this.changeHistoryManager = changeHistoryManager;
        this.issueEventManager = issueEventManager;
        this.eventPublisher = eventPublisher;
        this.movedIssueKeyStore = movedIssueKeyStore;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.commentManager = commentManager;
        this.attachmentDeleteHelper = attachmentDeleteHelper;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.worklogManager = worklogManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        try {
            Long issueId = issue.getId();
            GenericValue issueGV = issue.getGenericValue();
            if (issueGV == null) {
                throw new IllegalArgumentException("The provided issue has a null GenericValue.");
            }
            DeletedIssueEventData eventData = new DeletedIssueEventData(this.issueManager, this.customFieldManager, sendMail, eventDispatchOption.isEventBeingSent() ? issueId : null);
            if (eventDispatchOption.isEventBeingSent()) {
                this.dispatchPreDeleteEvent(user, eventDispatchOption, eventData);
            }
            Transaction txn = Txn.begin();
            try {
                this.removeChildActions(issue);
                this.worklogManager.deleteWorklogsForIssue(issue);
                this.removeSubTasks(user, issue, eventDispatchOption, sendMail);
                this.removeIssueLinks(user, issue);
                this.changeHistoryManager.removeAllChangeItems(issue);
                this.deleteMovedIssueKeyHistory(issue);
                this.removeIssueProperties(issue);
                this.removeAttachments(issue);
                this.nodeAssociationStore.removeAssociationsFromSource(issueGV);
                this.userAssociationStore.removeUserAssociationsFromSink(issueGV.getEntityName(), issueGV.getLong("id"));
                this.customFieldManager.removeCustomFieldValues(issueGV);
                this.workflowManager.removeWorkflowEntries(issueGV);
                issueGV.remove();
                this.removeNotifications(issueId);
                txn.commit();
                this.deindex(issue);
                this.dispatchDeleteEvent(user, eventDispatchOption, eventData);
            }
            finally {
                txn.finallyRollbackIfNotCommitted();
            }
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    private void removeChildActions(Issue issue) throws GenericEntityException {
        this.commentManager.deleteCommentsForIssue(issue);
    }

    private void deleteMovedIssueKeyHistory(Issue issue) {
        Long issueId = issue.getId();
        this.movedIssueKeyStore.deleteMovedIssueKeyHistory(issueId);
    }

    @Override
    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.deleteIssue(null, issue, EventDispatchOption.DO_NOT_DISPATCH, false);
    }

    private void removeIssueLinks(ApplicationUser user, Issue issue) {
        if (issue.isSubTask()) {
            Issue parentIssue = issue.getParentObject();
            this.issueLinkManager.removeIssueLinksNoChangeItems(issue);
            this.subTaskManager.resetSequences(parentIssue);
        } else {
            this.issueLinkManager.removeIssueLinksNoChangeItems(issue);
        }
        for (RemoteIssueLink remoteIssueLink : this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue)) {
            this.remoteIssueLinkManager.removeRemoteIssueLink(remoteIssueLink.getId(), user);
        }
    }

    private void removeIssueProperties(Issue issue) {
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), issue.getId());
    }

    private void removeAttachments(Issue issue) throws RemoveException {
        try {
            this.attachmentDeleteHelper.deleteAttachmentsForIssue(issue).claim();
        }
        catch (AttachmentCleanupException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    private void removeNotifications(Long issueId) {
        if (issueId != null) {
            try {
                this.mailThreadManager.removeAssociatedEntries(issueId);
            }
            catch (DataAccessException e) {
                log.error("Error removing Notification Instance records for issue with id '" + issueId + "': " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    protected void removeSubTasks(ApplicationUser user, Issue parentIssue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        for (IssueLink subTaskIssueLink : this.subTaskManager.getSubTaskIssueLinks(parentIssue.getId())) {
            Issue subTaskIssue = subTaskIssueLink.getDestinationObject();
            log.debug("Deleting sub-task issue with key: " + subTaskIssue.getKey());
            this.deleteIssue(user, subTaskIssue, eventDispatchOption, sendMail);
            log.debug("Deleted sub-task issue with key: " + subTaskIssue.getKey());
        }
    }

    private void deindex(Issue issue) {
        try {
            this.indexManager.deIndex(issue);
        }
        catch (Exception issueDeIndexException) {
            log.error("Error deindexing issue: [" + issue.getKey() + "] " + issue.getSummary() + ":" + issueDeIndexException, (Throwable)issueDeIndexException);
        }
    }

    private void dispatchPreDeleteEvent(ApplicationUser user, EventDispatchOption eventDispatchOption, DeletedIssueEventData eventData) {
        if (eventDispatchOption.isEventBeingSent()) {
            this.eventPublisher.publish((Object)new IssuePreDeleteEvent(eventData.issue, user));
        }
    }

    private void dispatchDeleteEvent(ApplicationUser user, EventDispatchOption eventDispatchOption, DeletedIssueEventData eventData) {
        if (eventDispatchOption.isEventBeingSent()) {
            this.issueEventManager.dispatchRedundantEvent(eventDispatchOption.getEventTypeId(), eventData.issue, eventData.paramsMap(), user, eventData.isSendMail());
            IssueEventBundle issueEventBundle = this.issueEventBundleFactory.createIssueDeleteEventBundle(eventData.issue, eventData, user);
            this.issueEventManager.dispatchEvent(issueEventBundle);
        }
    }

    public static class DeletedIssueEventData {
        private final Issue issue;
        private final Map<String, Object> customFieldValues;
        private final List<ApplicationUser> watchers;
        private final boolean sendMail;

        DeletedIssueEventData(IssueManager issueManager, CustomFieldManager customFieldManager, boolean sendMail, Long issueId) {
            if (issueId == null) {
                this.issue = null;
                this.customFieldValues = null;
                this.watchers = null;
            } else {
                this.issue = issueManager.getIssueObject(issueId);
                this.issue.getParentId();
                this.customFieldValues = this.collectCustomFieldValues(customFieldManager);
                this.watchers = issueManager.getWatchers(this.issue);
            }
            this.sendMail = sendMail;
        }

        DeletedIssueEventData(IssueManager issueManager, CustomFieldManager customFieldManager, boolean sendMail) {
            this(issueManager, customFieldManager, sendMail, null);
        }

        private Map<String, Object> collectCustomFieldValues(CustomFieldManager customFieldManager) {
            ImmutableMap.Builder answerBuilder = ImmutableMap.builder();
            for (CustomField customField : customFieldManager.getCustomFieldObjects(this.issue)) {
                Object value = customField.getValue(this.issue);
                if (value == null) continue;
                answerBuilder.put((Object)customField.getId(), value);
            }
            return answerBuilder.build();
        }

        public Map<String, Object> paramsMap() {
            HashMap builder = Maps.newHashMap();
            if (this.customFieldValues != null) {
                builder.put(IssueEvent.CUSTOM_FIELDS_PARAM_NAME, this.customFieldValues);
            }
            if (this.watchers != null) {
                builder.put(IssueEvent.WATCHERS_PARAM_NAME, this.watchers);
            }
            return !builder.isEmpty() ? ImmutableMap.copyOf((Map)builder) : null;
        }

        public boolean isSendMail() {
            return this.sendMail;
        }
    }
}

