/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.issue.comparator.CustomFieldComparators;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.managers.CachingCustomFieldManager;
import com.atlassian.jira.issue.managers.CustomFieldSearcherManager;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptors;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptors;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.PluginAccessor;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.Expression;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PreloadedCustomFieldManager
extends CachingCustomFieldManager {
    private final CachedReference<Map<Long, CustomField>> allCustomFields;

    public PreloadedCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, DbConnectionManager dbConnectionManager, FieldConfigSchemeManager fieldConfigSchemeManager, ConstantsManager constantsManager, ProjectManager projectManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, EventPublisher eventPublisher, CacheManager cacheManager, CustomFieldFactory customFieldFactory, CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors, CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors, CustomFieldSearcherManager customFieldSearcherManager, JiraProperties jiraProperties) {
        super(pluginAccessor, delegator, dbConnectionManager, fieldConfigSchemeManager, constantsManager, projectManager, contextPersister, fieldScreenManager, customFieldValuePersister, notificationSchemeManager, fieldManager, eventPublisher, cacheManager, customFieldFactory, customFieldTypeModuleDescriptors, customFieldSearcherModuleDescriptors, customFieldSearcherManager, jiraProperties);
        this.allCustomFields = cacheManager.getCachedReference(PreloadedCustomFieldManager.class, "allCustomFields", this::loadAllCustomFields);
    }

    private Map<Long, CustomField> loadAllCustomFields() {
        LinkedHashMap<Long, CustomField> customFields = new LinkedHashMap<Long, CustomField>();
        this.dbConnectionManager.execute(callback -> {
            QCustomField qcf = QCustomField.CUSTOM_FIELD;
            ((SQLQuery)callback.newSqlQuery().from((Expression)qcf)).list((Expression)qcf).stream().map(cf -> cf.toGenericValue(this.delegator)).map(this.customFieldFactory::create).sorted(CustomFieldComparators.byName()).filter(customField -> customField != null && customField.getCustomFieldType() != null).forEach(customFieldImpl -> customFields.put(customFieldImpl.getIdAsLong(), (CustomField)customFieldImpl));
        });
        return customFields;
    }

    @Override
    protected List<CustomField> getCustomFieldsFromIds(List<Long> ids) {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>(ids.size());
        for (Long id : ids) {
            CustomField customField = (CustomField)((Map)this.allCustomFields.get()).get(id);
            if (customField == null) continue;
            customFields.add(this.customFieldFactory.copyOf(customField));
        }
        return customFields;
    }

    @Override
    public List<CustomField> getCustomFieldObjects() {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>(((Map)this.allCustomFields.get()).size());
        customFields.addAll(((Map)this.allCustomFields.get()).values().stream().filter(customField -> customField != null).map(this.customFieldFactory::copyOf).collect(Collectors.toList()));
        return customFields;
    }

    @Override
    @Nullable
    public CustomField getCustomFieldObject(Long id) {
        CustomField customField = (CustomField)((Map)this.allCustomFields.get()).get(id);
        return customField == null ? null : this.customFieldFactory.copyOf(customField);
    }

    @Override
    protected void resetAllCustomFieldIds() {
        super.resetAllCustomFieldIds();
        this.allCustomFields.reset();
    }

    @Override
    public boolean exists(String key) {
        Long id = CustomFieldUtils.getCustomFieldId((String)key);
        return id != null && ((Map)this.allCustomFields.get()).containsKey(id);
    }
}

