/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.instrumentation.operations.SimpleOpTimer;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.instrumentation.InstrumentationListenerManager;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.search.SearchStatistics;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.SharedEntitySearchEvent;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.search.TimedSearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DefaultSearchRequestManager
implements SearchRequestManager,
FeatureFlagProvider {
    private final ColumnLayoutManager columnLayoutManager;
    private final SubscriptionManager subscriptionManager;
    private final ShareManager shareManager;
    private final SearchRequestStore searchRequestStore;
    private final SharedEntityIndexer indexer;
    private final SearchService searchService;
    private final FeatureManager featureManager;
    private final InstrumentationListenerManager instrumentationListenerManager;
    private final InstrumentationLogger instrumentationLogger;
    private final FeatureFlag databaseSearchFeature = FeatureFlag.featureFlag((String)"jira.shared.searchrequest.database.search");
    private final ExecutorService searchPool = Executors.newFixedThreadPool(1);
    private final Resolver<IndexableSharedEntity<SearchRequest>, SharedEntity> sharedEntityPermissionsResolver = this::setSharePermissions;

    public DefaultSearchRequestManager(ColumnLayoutManager columnLayoutManager, SubscriptionManager subscriptionManager, ShareManager shareManager, SearchRequestStore searchRequestStore, SharedEntityIndexer indexer, SearchService searchService, FeatureManager featureManager, InstrumentationListenerManager instrumentationListenerManager, InstrumentationLogger instrumentationLogger) {
        this.columnLayoutManager = (ColumnLayoutManager)Assertions.notNull((String)"columnLayoutManager", (Object)columnLayoutManager);
        this.subscriptionManager = (SubscriptionManager)Assertions.notNull((String)"subscriptionManager", (Object)subscriptionManager);
        this.shareManager = (ShareManager)Assertions.notNull((String)"shareManager", (Object)shareManager);
        this.searchRequestStore = (SearchRequestStore)Assertions.notNull((String)"searchRequestStore", (Object)searchRequestStore);
        this.indexer = (SharedEntityIndexer)Assertions.notNull((String)"indexer", (Object)indexer);
        this.searchService = (SearchService)Assertions.notNull((String)"searchService", (Object)searchService);
        this.featureManager = featureManager;
        this.instrumentationListenerManager = instrumentationListenerManager;
        this.instrumentationLogger = instrumentationLogger;
    }

    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), this::setSharePermissions);
    }

    public EnclosedIterable<SearchRequest> get(ApplicationUser user, SharedEntityAccessor.RetrievalDescriptor descriptor) {
        final java.util.function.Function<SearchRequest, SearchRequest> transformer = this.createPermissionSanitisingResolver(user);
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), (Function)new Function<SearchRequest, SearchRequest>(){

            public SearchRequest get(SearchRequest input) {
                return (SearchRequest)transformer.apply(input);
            }
        });
    }

    public EnclosedIterable<SearchRequest> getSearchRequests(ApplicationUser user, SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return CollectionEnclosedIterable.from((Collection)EnclosedIterable.Functions.toList(this.searchRequestStore.get(descriptor)).stream().map(this.createPermissionSanitisingResolver(user)).filter(sr -> this.isSharedWith((SearchRequest)sr, user)).collect(Collectors.toList()));
    }

    public EnclosedIterable<SearchRequest> getAll() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAll(), this::setSharePermissions);
    }

    public void visitAll(Visitor<SearchRequestEntity> visitor) {
        this.searchRequestStore.visitAll(visitor);
    }

    public EnclosedIterable<SharedEntity> getAllIndexableSharedEntities() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAllIndexableSharedEntities(), this.sharedEntityPermissionsResolver);
    }

    public Collection<SearchRequest> getAllOwnedSearchRequests(ApplicationUser user) {
        Collection<SearchRequest> searchRequests = this.searchRequestStore.getAllOwnedSearchRequests(user);
        if (searchRequests == null) {
            return Collections.emptyList();
        }
        return (Collection)searchRequests.stream().map(this.createPermissionSanitisingResolver(user)).collect(CollectorsUtil.toImmutableListWithSizeOf(searchRequests));
    }

    public SearchRequest getOwnedSearchRequestByName(ApplicationUser author, String name) {
        Assertions.notNull((String)"name", (Object)name);
        SearchRequest searchRequest = this.searchRequestStore.getRequestByAuthorAndName(author, name);
        return this.setSanitisedQuery(author, this.setSharePermissions(searchRequest));
    }

    public SearchRequest getSearchRequestById(ApplicationUser user, Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null && this.isSharedWith(searchRequest, user)) {
            return this.setSanitisedQuery(user, this.setSharePermissions(searchRequest));
        }
        return null;
    }

    public SearchRequest getSearchRequestById(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return this.setSharePermissions(searchRequest);
        }
        return null;
    }

    public List<SearchRequest> findByNameIgnoreCase(String name) {
        List<SearchRequest> searchRequests = this.searchRequestStore.findByNameIgnoreCase(name);
        for (SearchRequest searchRequest : searchRequests) {
            this.setSharePermissions(searchRequest);
        }
        return searchRequests;
    }

    public String getSearchRequestOwnerUserName(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return searchRequest.getOwner() == null ? null : searchRequest.getOwner().getUsername();
        }
        return null;
    }

    public ApplicationUser getSearchRequestOwner(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return searchRequest.getOwner();
        }
        return null;
    }

    public SearchRequest create(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        SearchRequest searchRequest = this.searchRequestStore.create(request);
        searchRequest.setPermissions(request.getPermissions());
        searchRequest.setPermissions(this.shareManager.updateSharePermissions((SharedEntity)searchRequest));
        this.indexer.index((SharedEntity)searchRequest).await();
        return this.setSanitisedQuery(searchRequest.getOwner(), searchRequest);
    }

    public SearchRequest update(SearchRequest request) {
        this.validateSearchRequestUpdate(request);
        SearchRequest searchRequest = this.searchRequestStore.update(request);
        searchRequest.setPermissions(this.shareManager.updateSharePermissions((SharedEntity)request));
        this.indexer.index((SharedEntity)searchRequest).await();
        return this.setSanitisedQuery(searchRequest.getOwner(), searchRequest);
    }

    public void delete(Long id) {
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest((Long)Assertions.notNull((String)"id", (Object)id));
        if (searchRequest != null) {
            this.deleteSearchRequest(searchRequest);
        }
    }

    private void deleteSearchRequest(SearchRequest searchRequest) {
        try {
            CollectionUtil.foreach((Iterable)this.subscriptionManager.getAllFilterSubscriptions(searchRequest.getId()), subscription -> {
                try {
                    this.subscriptionManager.deleteSubscription(subscription.getId());
                }
                catch (Exception e) {
                    throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
        }
        try {
            if (this.columnLayoutManager.hasColumnLayout(searchRequest)) {
                this.columnLayoutManager.restoreSearchRequestColumnLayout(searchRequest);
            }
        }
        catch (ColumnLayoutStorageException e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
        }
        this.shareManager.deletePermissions((SharedEntity)searchRequest);
        this.searchRequestStore.delete(searchRequest.getId());
        this.indexer.deIndex((SharedEntity)searchRequest).await();
    }

    public SharedEntity.TypeDescriptor<SearchRequest> getType() {
        return SearchRequest.ENTITY_TYPE;
    }

    public void adjustFavouriteCount(SharedEntity entity, int adjustmentValue) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.equals((String)"SearchRequestManager can only adjust favourite counts for Search Requests.", (Object)SearchRequest.ENTITY_TYPE, (Object)entity.getEntityType());
        SearchRequest searchRequest = this.searchRequestStore.adjustFavouriteCount(entity.getId(), adjustmentValue);
        this.setSharePermissions(searchRequest);
        this.indexer.index((SharedEntity)searchRequest).await();
    }

    SearchRequest setSanitisedQuery(ApplicationUser searcher, SearchRequest filter) {
        Query sanitisedQuery;
        Query query;
        if (filter != null && !(query = filter.getQuery()).equals(sanitisedQuery = this.searchService.sanitiseSearchQuery(searcher, query))) {
            boolean isModified = filter.isModified();
            filter.setQuery(sanitisedQuery);
            filter.setModified(isModified);
        }
        return filter;
    }

    private boolean isSharedWith(SearchRequest entity, ApplicationUser user) {
        return this.shareManager.isSharedWith(user, (SharedEntity)entity);
    }

    private SearchRequest setSharePermissions(SearchRequest filter) {
        if (filter != null) {
            filter.setPermissions(this.shareManager.getSharePermissions((SharedEntity)filter));
        }
        return filter;
    }

    private SharedEntity setSharePermissions(IndexableSharedEntity<SearchRequest> entity) {
        if (entity != null) {
            entity.setPermissions(this.shareManager.getSharePermissions(entity));
        }
        return entity;
    }

    private void validateSearchRequestCreate(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"request.owner.user.name", request.getOwner() == null ? null : request.getOwner().getUsername());
        Assertions.notNull((String)"request.name", (Object)request.getName());
    }

    private void validateSearchRequestUpdate(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        Assertions.notNull((String)"request.id", (Object)request.getId());
    }

    public SharedEntitySearchResult<SearchRequest> search(SharedEntitySearchParameters searchParameters, ApplicationUser user, int pagePosition, int pageWidth) {
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Assertions.not((String)"pagePosition < 0", (pagePosition < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth <= 0", (pageWidth <= 0 ? 1 : 0) != 0);
        TimedSearchResult<SearchRequest> indexResult = this.timedSearch("index", this.searchIndex(searchParameters, user, pagePosition, pageWidth));
        if (indexResult.getResult().getTotalResultCount() > -1) {
            SharedEntitySearchEvent sharedEntitySearchEvent = new SharedEntitySearchEvent(searchParameters);
            String currentTraceId = this.instrumentationListenerManager.getCurrentTraceId();
            String currentPath = this.instrumentationListenerManager.getCurrentPath();
            this.searchPool.submit(() -> {
                Integer databaseHash;
                SimpleOpTimer databaseTimer;
                if (this.featureManager.isEnabled(this.databaseSearchFeature) && this.isSearchDatabaseCapable(searchParameters)) {
                    TimedSearchResult<SearchRequest> databaseResult = this.timedSearch("database", this.searchDatabase(searchParameters, user, pagePosition, pageWidth));
                    databaseTimer = databaseResult.getTimer();
                    databaseHash = databaseResult.getResult().hashCode();
                } else {
                    databaseTimer = null;
                    databaseHash = null;
                }
                this.recordSearchMetrics(currentPath, currentTraceId, sharedEntitySearchEvent, indexResult.getTimer(), indexResult.getResult().hashCode(), databaseTimer, databaseHash);
            });
        }
        return indexResult.getResult();
    }

    public SearchRequest getSharedEntity(Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.setSharePermissions(this.searchRequestStore.getSearchRequest(entityId));
    }

    public SearchRequest getSharedEntity(ApplicationUser user, Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.getSearchRequestById(user, entityId);
    }

    public boolean hasPermissionToUse(ApplicationUser user, SearchRequest entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.equals((String)"SearchRequestManager can only adjust favourite counts for Search Requests.", (Object)SearchRequest.ENTITY_TYPE, (Object)entity.getEntityType());
        return this.shareManager.isSharedWith(user, (SharedEntity)entity);
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return ImmutableSet.of((Object)this.databaseSearchFeature);
    }

    private java.util.function.Function<SearchRequest, SearchRequest> createPermissionSanitisingResolver(ApplicationUser searcher) {
        return request -> this.setSanitisedQuery(searcher, this.setSharePermissions((SearchRequest)request));
    }

    private TimedSearchResult<SearchRequest> timedSearch(String timerName, Supplier<SharedEntitySearchResult<SearchRequest>> search) {
        SimpleOpTimer timer = new SimpleOpTimer(timerName);
        SharedEntitySearchResult<SearchRequest> result = search.get();
        timer.end((long)result.getTotalResultCount());
        return new TimedSearchResult<SearchRequest>(result, timer);
    }

    private Supplier<SharedEntitySearchResult<SearchRequest>> searchIndex(SharedEntitySearchParameters searchParameters, ApplicationUser user, int pagePosition, int pageWidth) {
        return () -> this.indexer.getSearcher(SearchRequest.ENTITY_TYPE).search(searchParameters, user, pagePosition, pageWidth);
    }

    private Supplier<SharedEntitySearchResult<SearchRequest>> searchDatabase(SharedEntitySearchParameters searchParameters, ApplicationUser user, int pagePosition, int pageWidth) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private boolean isSearchDatabaseCapable(SharedEntitySearchParameters searchParameters) {
        return false;
    }

    private void recordSearchMetrics(String currentPath, String currentTraceId, SharedEntitySearchEvent sharedEntitySearchEvent, SimpleOpTimer indexTimer, Integer indexHash, @Nullable SimpleOpTimer databaseTimer, @Nullable Integer databaseHash) {
        List<SearchStatistics> searchStatistics = SearchStatistics.create(DefaultSearchRequestManager.class.getName(), sharedEntitySearchEvent, indexTimer, indexHash, databaseTimer, databaseHash);
        this.instrumentationLogger.save(currentTraceId, Optional.empty(), Optional.empty(), currentPath, searchStatistics, Optional.empty());
    }
}

