/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;

public class LabelsSearchInputTransformer
implements SearchInputTransformer {
    private final IndexInfoResolver<Label> indexInfoResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final JqlOperandResolver operandResolver;

    public LabelsSearchInputTransformer(IndexInfoResolver<Label> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        this.indexInfoResolver = indexInfoResolver;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
    }

    public void populateFromParams(ApplicationUser user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String url = SystemSearchConstants.forLabels().getUrlParameter();
        String[] labels = actionParams.getValuesForKey(url);
        if (labels != null) {
            fieldValuesHolder.put((Object)url, (Object)labels);
        }
    }

    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String url = SystemSearchConstants.forLabels().getUrlParameter();
        Collection labels = (Collection)fieldValuesHolder.get((Object)url);
        if (labels != null) {
            for (String label : labels) {
                if (!LabelParser.isValidLabelName((String)label)) {
                    errors.addErrorMessage(i18nHelper.getText("label.service.error.label.invalid", label));
                }
                if (label.length() <= 255) continue;
                errors.addErrorMessage(i18nHelper.getText("label.service.error.label.toolong", label));
            }
        }
    }

    public void populateFromQuery(ApplicationUser user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        String url = SystemSearchConstants.forLabels().getUrlParameter();
        ImmutableList cleanValues = ImmutableList.copyOf((Iterable)Iterables.transform(this.getNavigatorValuesAsStrings(user, query, searchContext), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input.trim();
            }
        }));
        fieldValuesHolder.put((Object)url, (Object)cleanValues);
    }

    Set<String> getNavigatorValuesAsStrings(ApplicationUser searcher, Query query, SearchContext searchContext) {
        DefaultIndexedInputHelper helper = new DefaultIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry);
        return helper.getAllNavigatorValuesForMatchingClauses(searcher, SystemSearchConstants.forLabels().getJqlClauseNames(), query);
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return this.createNavigatorStructureChecker().checkSearchRequest(query);
    }

    private NavigatorStructureChecker<Label> createNavigatorStructureChecker() {
        return new NavigatorStructureChecker(SystemSearchConstants.forLabels().getJqlClauseNames(), false, this.fieldFlagOperandRegistry, this.operandResolver);
    }

    public Clause getSearchClause(ApplicationUser user, FieldValuesHolder fieldValuesHolder) {
        String url = SystemSearchConstants.forLabels().getUrlParameter();
        Collection labels = (Collection)fieldValuesHolder.get((Object)url);
        if (labels != null && !labels.isEmpty()) {
            String primaryName = SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName();
            if (labels.size() == 1) {
                String label = ((String)Iterables.getOnlyElement((Iterable)labels)).trim();
                return new TerminalClauseImpl(primaryName, Operator.EQUALS, (Operand)new SingleValueOperand(label));
            }
            ImmutableList operands = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)labels, (Function)new Function<String, Operand>(){

                public Operand apply(String label) {
                    return new SingleValueOperand(label.trim());
                }
            }));
            return new TerminalClauseImpl(primaryName, Operator.IN, (Operand)new MultiValueOperand((Collection)operands));
        }
        return null;
    }
}

