/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SearchContextRenderHelper {
    public static void addSearchContextParams(SearchContext searchContext, Map<String, Object> velocityParams) {
        Iterable<Object> projectNames = null != searchContext.getProjects() ? Iterables.transform((Iterable)searchContext.getProjects(), (Function)new Function<Project, String>(){

            public String apply(@Nullable Project project) {
                return TextUtils.htmlEncode((String)project.getName());
            }
        }) : Collections.emptyList();
        velocityParams.put("contextProjectNames", StringUtils.join(projectNames, (String)", "));
        Iterable<Object> issueTypeNames = null != searchContext.getIssueTypes() ? Iterables.transform((Iterable)searchContext.getIssueTypes(), (Function)new Function<IssueType, String>(){

            public String apply(@Nullable IssueType issueType) {
                return TextUtils.htmlEncode((String)issueType.getName());
            }
        }) : Collections.emptyList();
        velocityParams.put("contextIssueTypeNames", StringUtils.join(issueTypeNames, (String)", "));
    }
}

