/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.IssueXMLView;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.RssViewUtils;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.RequestContextParameterHolder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestXMLView
extends AbstractSearchRequestView {
    public static final String DEFAULT_DESCRIPTION = "An XML representation of a search request";
    private static final Logger log = LoggerFactory.getLogger(SearchRequestXMLView.class);
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;
    private final BuildUtilsInfo buildUtilsInfo;

    public SearchRequestXMLView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil, BuildUtilsInfo buildUtilsInfo) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public void writeSearchResults(SearchRequest searchRequest, final SearchRequestParams searchRequestParams, Writer writer) {
        IssueXMLView xmlView = this.getIssueXMLView();
        try {
            if (xmlView == null) {
                writer.write("Could not find plugin of class 'IssueXMLView'.  This is needed for this plugin to work");
                return;
            }
            writer.write(this.getHeader(searchRequest, searchRequestParams));
            SingleIssueWriter singleIssueWriter = new SingleIssueWriter(){

                @Override
                public void writeIssue(Issue issue, AbstractIssueView issueView, Writer writer) throws IOException {
                    if (log.isDebugEnabled()) {
                        log.debug("About to write XML view for issue [" + issue.getKey() + "].");
                    }
                    writer.write(issueView.getBody(issue, (IssueViewRequestParams)searchRequestParams));
                }
            };
            this.searchRequestViewBodyWriterUtil.writeBody(writer, this.getIssueXMLView(), searchRequest, singleIssueWriter, searchRequestParams.getPagerFilter());
            writer.write(this.getFooter());
        }
        catch (SearchException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private IssueXMLView getIssueXMLView() {
        return SearchRequestViewUtils.getIssueView(IssueXMLView.class);
    }

    public String getHeader(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        String requestURL;
        long startIssue = searchRequestParams.getPagerFilter().getStart();
        long totalIssues = this.getSearchCount(searchRequest, searchRequestParams);
        long tempMax = searchRequestParams.getPagerFilter().getMax() < 0 ? 0L : (long)searchRequestParams.getPagerFilter().getMax();
        long endIssue = Math.min(startIssue + tempMax, totalIssues);
        Map<String, Object> headerParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        headerParams.put("title", SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getString("jira.title")));
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        headerParams.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getUser()));
        headerParams.put("buildInfo", this.buildUtilsInfo.getBuildInformation());
        headerParams.put("currentDate", new Date());
        headerParams.put("description", this.getDescription(searchRequest));
        headerParams.put("rssLocale", RssViewUtils.getRssLocale(this.authenticationContext.getLocale()));
        headerParams.put("startissue", startIssue);
        headerParams.put("endissue", endIssue);
        headerParams.put("totalissue", totalIssues);
        headerParams.put("version", this.buildUtilsInfo.getVersion());
        headerParams.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        headerParams.put("buildDate", new SimpleDateFormat("dd-MM-yyyy").format(this.buildUtilsInfo.getCurrentBuildDate()));
        headerParams.put("customViewRequested", searchRequestParams.getIssueViewFieldParams().isCustomViewRequested());
        RequestContextParameterHolder requestParameters = velocityRequestContext.getRequestParameters();
        if (requestParameters != null && (requestURL = requestParameters.getRequestURL()) != null) {
            String queryString = StringEscapeUtils.escapeXml((String)requestParameters.getQueryString());
            if (queryString != null) {
                headerParams.put("exampleURLPrefix", requestURL + "?" + queryString + (queryString.endsWith("&amp;") ? "" : "&amp;"));
            } else {
                headerParams.put("exampleURLPrefix", requestURL + "?");
            }
        }
        return this.descriptor.getHtml("header", headerParams);
    }

    private String getDescription(SearchRequest searchRequest) {
        return searchRequest.getDescription() != null ? searchRequest.getDescription() : DEFAULT_DESCRIPTION;
    }

    public String getFooter() {
        return this.descriptor.getHtml("footer", Collections.emptyMap());
    }

    private long getSearchCount(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        String searchCount = (String)searchRequestParams.getSession().get("searchCount");
        if (StringUtils.isNumeric((String)searchCount)) {
            return Long.parseLong(searchCount);
        }
        try {
            return this.searchRequestViewBodyWriterUtil.searchCount(searchRequest);
        }
        catch (SearchException se) {
            return 0L;
        }
    }
}

