/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.vote.VotedIssuesAccessor;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Collector;

public class DefaultVotedIssuesAccessor
implements VotedIssuesAccessor {
    private final VoteManager voteManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory factory;

    public DefaultVotedIssuesAccessor(@Nonnull VoteManager voteManager, @Nonnull SearchProvider searchProvider, @Nonnull SearchProviderFactory factory) {
        this.voteManager = (VoteManager)Assertions.notNull((String)"voteManager", (Object)voteManager);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.factory = (SearchProviderFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    public Iterable<Long> getVotedIssueIds(ApplicationUser voter, ApplicationUser searcher, VotedIssuesAccessor.Security security) {
        FieldHitCollector collector = new FieldHitCollector("issue_id");
        Query query = DefaultVotedIssuesAccessor.getVoterQuery(voter);
        try {
            switch (security) {
                case OVERRIDE: {
                    this.searchProvider.searchOverrideSecurity(query, searcher, (Collector)collector);
                    break;
                }
                case RESPECT: {
                    this.searchProvider.search(query, searcher, (Collector)collector);
                }
            }
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        List<String> issueIds = collector.getValues();
        return Iterables.transform(issueIds, (Function)new Function<String, Long>(){

            public Long apply(@Nullable String input) {
                return Long.valueOf(input);
            }
        });
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    static Query getVoterQuery(ApplicationUser voter) {
        return JqlQueryBuilder.newBuilder().where().voterUser(voter.getName()).endWhere().buildQuery();
    }
}

