/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.dbquery;

import com.atlassian.jira.jql.dbquery.AbstractOperatorDbQueryFactory;
import com.atlassian.jira.jql.dbquery.DbQueryFactoryResultQuerydsl;
import com.atlassian.jira.jql.dbquery.OperatorSpecificDbQueryFactory;
import com.atlassian.jira.jql.dbquery.VisibilityClauseQueryFactory;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.DbQueryFactoryResult;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.query.operator.Operator;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.StringPath;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEqualityDbQueryFactory<T>
extends AbstractOperatorDbQueryFactory<T>
implements OperatorSpecificDbQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractEqualityDbQueryFactory.class);
    private final VisibilityClauseQueryFactory visibilityQueryFactory;

    public AbstractEqualityDbQueryFactory(String fieldName, Path path, VisibilityClauseQueryFactory visibilityQueryFactory, NameResolver<T> nameResolver) {
        super(fieldName, path, nameResolver);
        this.visibilityQueryFactory = visibilityQueryFactory;
    }

    @Override
    public DbQueryFactoryResult createQueryForSingleValue(Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.EQUALS.equals((Object)operator)) {
            return this.handleEquals(this.path, rawValues);
        }
        if (Operator.NOT_EQUALS.equals((Object)operator)) {
            return this.handleNotEquals(this.path, rawValues);
        }
        if (log.isDebugEnabled()) {
            log.debug("Create query for single value was called with operator '" + operator.getDisplayString() + "', this only handles '=' and '!='.");
        }
        return DbQueryFactoryResultQuerydsl.createFalseResult();
    }

    @Override
    public DbQueryFactoryResult createQueryForMultipleValues(Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.IN.equals((Object)operator)) {
            return this.handleEquals(this.path, rawValues);
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            return this.handleNotEquals(this.path, rawValues);
        }
        if (log.isDebugEnabled()) {
            log.debug("Create query for multiple value was called with operator '" + operator.getDisplayString() + "', this only handles 'in'.");
        }
        return DbQueryFactoryResultQuerydsl.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    protected DbQueryFactoryResult handleNotEquals(Path path, List<QueryLiteral> values) {
        if (values == null) {
            return DbQueryFactoryResultQuerydsl.builder().withPredicate(this.getIsNotEmptyQuery()).build();
        }
        if (path instanceof NumberPath) {
            List<Long> dbNumberValues = this.getNumericDbValues(values);
            return this.handleNumericNotEquals((NumberPath)path, dbNumberValues);
        }
        if (path instanceof StringPath) {
            List<String> dbStringValues = this.getStringDbValues(values);
            return this.handleStringNotEquals((StringPath)path, dbStringValues);
        }
        throw new UnsupportedOperationException("Path type not String or Number");
    }

    private DbQueryFactoryResult handleNumericNotEquals(NumberPath path, List<Long> dbNumberValues) {
        Predicate fieldPredicate;
        if (dbNumberValues.size() == 0) {
            fieldPredicate = this.getIsNotEmptyQuery();
        } else if (dbNumberValues.size() == 1) {
            fieldPredicate = path.ne((Object)dbNumberValues.get(0));
        } else {
            BooleanBuilder booleanPredicate = new BooleanBuilder();
            for (Long dbNumberValue : dbNumberValues) {
                booleanPredicate.and((Predicate)path.ne((Object)dbNumberValue));
            }
            fieldPredicate = booleanPredicate;
        }
        DbQueryFactoryResultQuerydsl fieldResult = DbQueryFactoryResultQuerydsl.builder().withPredicate(fieldPredicate).build();
        DbQueryFactoryResultQuerydsl visibilityResult = this.visibilityQueryFactory.visibilityQuery(this.fieldName);
        return fieldResult.and(visibilityResult);
    }

    private DbQueryFactoryResult handleStringNotEquals(StringPath path, List<String> dbValues) {
        Predicate fieldPredicate;
        if (dbValues.size() == 0) {
            fieldPredicate = this.getIsNotEmptyQuery();
        } else if (dbValues.size() == 1) {
            fieldPredicate = path.ne((Object)dbValues.get(0));
        } else {
            BooleanBuilder booleanPredicate = new BooleanBuilder();
            for (String dbValue : dbValues) {
                booleanPredicate.and((Predicate)path.ne((Object)dbValue));
            }
            fieldPredicate = booleanPredicate;
        }
        DbQueryFactoryResultQuerydsl fieldResult = DbQueryFactoryResultQuerydsl.builder().withPredicate(fieldPredicate).build();
        DbQueryFactoryResultQuerydsl visibilityResult = this.visibilityQueryFactory.visibilityQuery(this.fieldName);
        return fieldResult.and(visibilityResult);
    }

    protected DbQueryFactoryResult handleEquals(Path path, List<QueryLiteral> values) {
        if (values == null) {
            return DbQueryFactoryResultQuerydsl.createFalseResult();
        }
        if (path instanceof NumberPath) {
            List<Long> dbNumberValues = this.getNumericDbValues(values);
            return this.handleNumericEquals((NumberPath<Long>)((NumberPath)path), dbNumberValues);
        }
        if (path instanceof StringPath) {
            List<String> dbStringValues = this.getStringDbValues(values);
            return this.handleStringEquals((StringPath)path, dbStringValues);
        }
        throw new UnsupportedOperationException("Path type not String or Number");
    }

    private DbQueryFactoryResult handleNumericEquals(NumberPath<Long> path, List<Long> dbNumberValues) {
        if (dbNumberValues.size() == 0) {
            return DbQueryFactoryResultQuerydsl.builder().withPredicate(this.getIsEmptyQuery()).build();
        }
        if (dbNumberValues.size() == 1) {
            BooleanExpression predicate = path.eq((Object)dbNumberValues.get(0));
            return DbQueryFactoryResultQuerydsl.builder().withPredicate((Predicate)predicate).build();
        }
        BooleanBuilder booleanPredicate = new BooleanBuilder();
        for (Long dbNumberValue : dbNumberValues) {
            booleanPredicate.or((Predicate)path.eq((Object)dbNumberValue));
        }
        return DbQueryFactoryResultQuerydsl.builder().withPredicate((Predicate)booleanPredicate).build();
    }

    private DbQueryFactoryResult handleStringEquals(StringPath path, List<String> dbValues) {
        if (dbValues.size() == 0) {
            return DbQueryFactoryResultQuerydsl.builder().withPredicate(this.getIsEmptyQuery()).build();
        }
        if (dbValues.size() == 1) {
            BooleanExpression predicate = path.eq((Object)dbValues.get(0));
            return DbQueryFactoryResultQuerydsl.builder().withPredicate((Predicate)predicate).build();
        }
        BooleanBuilder booleanPredicate = new BooleanBuilder();
        for (String dbValue : dbValues) {
            booleanPredicate.or((Predicate)path.eq((Object)dbValue));
        }
        return DbQueryFactoryResultQuerydsl.builder().withPredicate((Predicate)booleanPredicate).build();
    }

    private List<Long> getNumericDbValues(List<QueryLiteral> values) {
        ArrayList<Long> numericDbValues = new ArrayList<Long>();
        for (QueryLiteral value : values) {
            if (value == null) continue;
            if (value.getStringValue() != null) {
                List ids = this.nameResolver.getIdsFromName(value.getStringValue());
                if (ids.isEmpty()) {
                    Object obj;
                    Long id = this.getValueAsLong(value.getStringValue());
                    if (id == null || (obj = this.nameResolver.get(id)) == null) continue;
                    numericDbValues.add(id);
                    continue;
                }
                for (String id : ids) {
                    Long numericId = this.getValueAsLong(id);
                    if (numericId == null) continue;
                    numericDbValues.add(numericId);
                }
                continue;
            }
            if (value.getLongValue() == null) continue;
            numericDbValues.add(value.getLongValue());
        }
        return numericDbValues;
    }

    private List<String> getStringDbValues(List<QueryLiteral> values) {
        ArrayList<String> dbValues = new ArrayList<String>();
        for (QueryLiteral value : values) {
            if (value.getStringValue() == null) continue;
            List ids = this.nameResolver.getIdsFromName(value.getStringValue());
            if (ids.isEmpty()) {
                dbValues.add(value.getStringValue());
                continue;
            }
            for (String id : ids) {
                dbValues.add(id);
            }
        }
        return dbValues;
    }

    abstract Predicate getIsEmptyQuery();

    abstract Predicate getIsNotEmptyQuery();
}

