/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.dbquery;

import com.atlassian.jira.jql.dbquery.DbQueryFactoryResultQuerydsl;
import com.atlassian.jira.jql.dbquery.OperatorSpecificDbQueryFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.DbClauseQueryFactory;
import com.atlassian.jira.jql.query.DbQueryFactoryResult;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.mysema.query.types.path.NumberPath;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDbClauseQueryFactory
implements DbClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(GenericDbClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final List<OperatorSpecificDbQueryFactory> operatorQueryFactories;
    private final NumberPath<Long> path;

    public GenericDbClauseQueryFactory(NumberPath<Long> path, List<OperatorSpecificDbQueryFactory> operatorQueryFactories, JqlOperandResolver operandResolver) {
        this.path = (NumberPath)Assertions.notNull((String)"path", path);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.operatorQueryFactories = CollectionUtil.copyAsImmutableList((Collection)((Collection)Assertions.notNull((String)"operatorQueryFactories", operatorQueryFactories)));
    }

    public DbQueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (this.operandResolver.isValidOperand(operand)) {
            for (OperatorSpecificDbQueryFactory operatorQueryFactory : this.operatorQueryFactories) {
                if (!operatorQueryFactory.handlesOperator(operator)) continue;
                if (this.operandResolver.isEmptyOperand(operand)) {
                    return operatorQueryFactory.createQueryForEmptyOperand(operator);
                }
                List<QueryLiteral> rawValues = this.getRawValues(queryCreationContext, terminalClause);
                if (this.operandResolver.isListOperand(operand)) {
                    return operatorQueryFactory.createQueryForMultipleValues(operator, rawValues);
                }
                return operatorQueryFactory.createQueryForSingleValue(operator, rawValues);
            }
            log.debug(String.format("The '%s' clause does not support the %s operator.", terminalClause.getName(), operator.getDisplayString()));
            return DbQueryFactoryResultQuerydsl.createFalseResult();
        }
        log.debug(String.format("There is no OperandHandler registered to handle the operand '%s' for operand '%s'.", operator.getDisplayString(), terminalClause.getOperand().getDisplayString()));
        return DbQueryFactoryResultQuerydsl.createFalseResult();
    }

    List<QueryLiteral> getRawValues(QueryCreationContext queryCreationContext, TerminalClause clause) {
        return this.operandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
    }
}

