/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@ExperimentalApi
public class DbQueryCapabilityVisitor
implements ClauseVisitor<Boolean> {
    private final QueryCreationContext queryCreationContext;
    private final SearchHandlerManager searchHandlerManager;

    public DbQueryCapabilityVisitor(QueryCreationContext queryCreationContext, SearchHandlerManager searchHandlerManager) {
        this.queryCreationContext = queryCreationContext;
        this.searchHandlerManager = searchHandlerManager;
    }

    @Nonnull
    public Boolean visit(AndClause andClause) {
        return this.visitAllSubClauses(andClause.getClauses());
    }

    @Nonnull
    public Boolean visit(NotClause notClause) {
        return this.visitAllSubClauses(Collections.singletonList(notClause.getSubClause()));
    }

    @Nonnull
    public Boolean visit(OrClause orClause) {
        return this.visitAllSubClauses(orClause.getClauses());
    }

    @Nonnull
    public Boolean visit(TerminalClause terminalClause) {
        Collection handlers = !this.queryCreationContext.isSecurityOverriden() ? this.searchHandlerManager.getClauseHandler(this.queryCreationContext.getApplicationUser(), terminalClause.getName()) : this.searchHandlerManager.getClauseHandler(terminalClause.getName());
        boolean dbCapable = handlers.stream().allMatch(new Predicate<ClauseHandler>(){

            @Override
            public boolean test(ClauseHandler handler) {
                return handler.isDbQueryCapable();
            }
        });
        return dbCapable;
    }

    @Nonnull
    public Boolean visit(WasClause clause) {
        return Boolean.FALSE;
    }

    @Nonnull
    public Boolean visit(ChangedClause clause) {
        return Boolean.FALSE;
    }

    private Boolean visitAllSubClauses(List<Clause> subClauses) {
        boolean dbCapable = subClauses.stream().allMatch(new Predicate<Clause>(){

            @Override
            public boolean test(Clause clause) {
                return (Boolean)clause.accept((ClauseVisitor)DbQueryCapabilityVisitor.this);
            }
        });
        return dbCapable;
    }
}

