/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.core.util.Clock;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JqlLocalDateSupportImpl
implements JqlLocalDateSupport {
    private static final Logger log = LoggerFactory.getLogger(JqlLocalDateSupportImpl.class);
    public static final String PATTERN_WITH_SLASH = "yyyy/MM/dd";
    public static final String PATTERN_WITH_HYPHEN = "yyyy-MM-dd";
    private final Clock clock;
    private final TimeZoneManager timeZoneManager;

    public JqlLocalDateSupportImpl(Clock clock, TimeZoneManager timeZoneManager) {
        this.timeZoneManager = timeZoneManager;
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
    }

    public JqlLocalDateSupportImpl(TimeZoneManager timeZoneManager) {
        this(RealClock.getInstance(), timeZoneManager);
    }

    public LocalDate convertToLocalDate(String dateString) {
        Assertions.notNull((String)"dateString", (Object)dateString);
        String trimLocalDate = StringUtils.trimToNull((String)dateString);
        if (trimLocalDate != null) {
            LocalDate returnLocalDate = this.parseDuration(trimLocalDate);
            if (returnLocalDate != null) {
                return returnLocalDate;
            }
            return this.parseLocalDate(dateString);
        }
        if (log.isDebugEnabled()) {
            log.debug("Unable to parse JQL date '" + dateString + "'.");
        }
        return null;
    }

    public LocalDate convertToLocalDate(Long dateLong) {
        Assertions.notNull((String)"dateLong", (Object)dateLong);
        TimeZone tz = this.timeZoneManager.getLoggedInUserTimeZone();
        return LocalDateFactory.getLocalDate((Date)new Date(dateLong), (TimeZone)tz);
    }

    public String getIndexedValue(LocalDate date) {
        return LuceneUtils.localDateToString((LocalDate)date);
    }

    public boolean validate(String dateString) {
        String trimDate = StringUtils.trimToNull((String)dateString);
        return trimDate != null && this.convertToLocalDate(trimDate) != null;
    }

    public String getLocalDateString(LocalDate localDate) {
        Assertions.notNull((String)"date", (Object)localDate);
        return localDate.toString();
    }

    public Date convertToDate(LocalDate date) {
        Assertions.notNull((String)"date", (Object)date);
        try {
            return this.toDate(PATTERN_WITH_HYPHEN, date.toString());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public LocalDate getLocalDateFromQueryLiteral(QueryLiteral rawValue) {
        if (rawValue.getLongValue() != null) {
            return this.convertToLocalDate(rawValue.getLongValue());
        }
        if (rawValue.getStringValue() != null) {
            return this.convertToLocalDate(rawValue.getStringValue());
        }
        return null;
    }

    public List<LocalDate> getLocalDatesFromQueryLiterals(List<QueryLiteral> rawValues) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (QueryLiteral rawValue : rawValues) {
            LocalDate localDate;
            if (rawValue.getLongValue() != null) {
                localDate = this.convertToLocalDate(rawValue.getLongValue());
                if (localDate == null) continue;
                dates.add(localDate);
                continue;
            }
            if (rawValue.getStringValue() != null) {
                localDate = this.convertToLocalDate(rawValue.getStringValue());
                if (localDate == null) continue;
                dates.add(localDate);
                continue;
            }
            dates.add(null);
        }
        return dates;
    }

    private LocalDate parseDuration(String str) {
        try {
            long offset = this.parseDurationOffset(str);
            Date currentDate = this.clock.getCurrentDate();
            return this.convertToLocalDate(currentDate.getTime() + offset);
        }
        catch (InvalidDurationException e) {
            return null;
        }
        catch (NumberFormatException ne) {
            return null;
        }
    }

    private long parseDurationOffset(String str) throws InvalidDurationException {
        return TimeUnit.SECONDS.toMillis(DateUtils.getDurationWithNegative((String)str));
    }

    private LocalDate parseDate(String pattern, String dateString) {
        try {
            Date date = this.toDate(pattern, dateString);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            return new LocalDate(year, month, day);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Date toDate(String pattern, String dateString) throws IllegalArgumentException {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        DateTime dateTime = fmt.parseDateTime(dateString);
        return dateTime.toDate();
    }

    private LocalDate parseLocalDate(String dateString) {
        try {
            LocalDate localDate = this.parseDate(PATTERN_WITH_SLASH, dateString);
            return localDate != null ? localDate : this.parseDate(PATTERN_WITH_HYPHEN, dateString);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }
}

