/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseJohnsonEventRaiserImpl
implements LicenseJohnsonEventRaiser {
    private static final Logger log = LoggerFactory.getLogger(LicenseJohnsonEventRaiserImpl.class);
    private final BuildVersionLicenseCheck buildVersionLicenseCheck;
    private final JohnsonProvider johnsonProvider;

    public LicenseJohnsonEventRaiserImpl(@Nonnull BuildVersionLicenseCheck buildVersionLicenseCheck, JohnsonProvider johnsonProvider) {
        this.buildVersionLicenseCheck = (BuildVersionLicenseCheck)Assertions.notNull((String)"buildVersionLicenseCheck", (Object)buildVersionLicenseCheck);
        this.johnsonProvider = (JohnsonProvider)Assertions.notNull((String)"johnsonProvider", (Object)johnsonProvider);
    }

    @Override
    public boolean checkLicenseIsTooOldForBuild() {
        LicenseCheck.Result result = this.buildVersionLicenseCheck.evaluate();
        if (!result.isPass()) {
            String failureMessage = result.getFailureMessage();
            log.error(failureMessage);
            JohnsonEventContainer cont = this.johnsonProvider.getContainer();
            for (LicenseDetails license : result.getFailedLicenses()) {
                String eventString = license.isEnterpriseLicenseAgreement() ? "subscription-expired" : "license-too-old";
                Event newEvent = new Event(EventType.get((String)eventString), failureMessage, EventLevel.get((String)"error"));
                cont.addEvent(newEvent);
            }
            return true;
        }
        return false;
    }
}

