/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefaultTemplateContext
implements TemplateContext {
    private final Locale locale;
    private final WebResourceUrlProvider resourceUrlProvider;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory beanFactory;

    public DefaultTemplateContext(Locale locale, WebResourceUrlProvider resourceUrlProvider, ApplicationProperties applicationProperties, I18nHelper.BeanFactory beanFactory) {
        this.locale = locale;
        this.resourceUrlProvider = resourceUrlProvider;
        this.applicationProperties = applicationProperties;
        this.beanFactory = beanFactory;
    }

    @Override
    public Map<String, Object> getTemplateParams() {
        I18nHelper i18nHelper = this.beanFactory.getInstance(this.locale);
        HashMap templateParams = Maps.newHashMap();
        templateParams.put("i18n", i18nHelper);
        OutlookDate formatter = new OutlookDate(this.locale);
        templateParams.put("dateformatter", formatter);
        LookAndFeelBean landf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        templateParams.put("lfbean", landf);
        templateParams.put("baseurl", this.applicationProperties.getString("jira.baseurl"));
        String jiraLogo = landf.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = this.resourceUrlProvider.getStaticResourcePrefix(UrlMode.ABSOLUTE) + jiraLogo;
        }
        templateParams.put("jiraLogoUrl", jiraLogo);
        return templateParams;
    }
}

