/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.HTMLUtils;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueMockRequest;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.ColumnLayoutItemProvider;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public class SubscriptionMailQueueItem
extends AbstractMailQueueItem {
    public static final String USER_KEY_COLUMN_NAME = "username";
    private static final Logger log = LoggerFactory.getLogger(SubscriptionMailQueueItem.class);
    public static final String ATTACHMENTS_MANAGER_KEY = "attachmentsManager";
    private final Long FILTER_SUBSCRIPTION_TEMPLATE_ID = 10000L;
    private FilterSubscription subscription;
    private SearchRequest request;
    private ApplicationUser subscriptionCreator;
    private TemplateManager templateManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final MailAttachmentsManager mailAttachmentsManager;
    private final MailingListCompiler mailingListCompiler;
    private static final int DEFAULT_MAIL_MAX_ISSUES = 200;

    SubscriptionMailQueueItem(FilterSubscription sub, MailingListCompiler mailingListCompiler, TemplateManager templateManager, UserManager userManager, GroupManager groupManager, MailAttachmentsManager mailAttachmentsManager) {
        this.subscription = sub;
        this.mailingListCompiler = mailingListCompiler;
        this.templateManager = templateManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.mailAttachmentsManager = mailAttachmentsManager;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        String groupName = this.subscription.getGroupName();
        if (StringUtils.isNotEmpty((String)groupName)) {
            Group group = this.userManager.getGroup(groupName);
            if (group == null) {
                log.warn("Group '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{groupName, this.subscription.getId(), this.subscription.getFilterId()});
                return;
            }
            try {
                Collection groupUser = this.groupManager.getUsersInGroup(groupName, Boolean.valueOf(false));
                for (ApplicationUser user : groupUser) {
                    this.sendSearchRequestEmail(user);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new MailException((Throwable)ex);
            }
        }
        String getKey = this.subscription.getUserKey();
        ApplicationUser user = this.getSubscriptionUser();
        if (user == null) {
            log.warn("User '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{getKey, this.subscription.getId(), this.subscription.getFilterId()});
        } else {
            try {
                this.sendSearchRequestEmail(user);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new MailException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void sendSearchRequestEmail(ApplicationUser user) throws Exception {
        JiraAuthenticationContext jiraAuthenticationContext = this.getJiraAuthenticationContext();
        ApplicationUser originalUser = jiraAuthenticationContext.getUser();
        jiraAuthenticationContext.setLoggedInUser(user);
        try {
            Map<String, Object> params = this.getContextParams(this.subscription, this.getSearchRequest(), user);
            HashSet recipient = Sets.newHashSet();
            recipient.add(new NotificationRecipient(user));
            if (this.subscription == null) {
                throw new RuntimeException("Null subscription for user " + user.getName());
            }
            boolean emailOnEmptyStr = this.subscription.isEmailOnEmpty();
            if (params.get("issues") == null) {
                throw new RuntimeException("Null list of issues for subscription " + this.subscription + ", user " + user);
            }
            if (user.equals((Object)this.getSubscriptionUser())) {
                params.put("recipientIsAuthor", Boolean.TRUE);
            }
            if (emailOnEmptyStr || !((Collection)params.get("issues")).isEmpty()) {
                this.mailingListCompiler.sendLists(recipient, null, null, this.FILTER_SUBSCRIPTION_TEMPLATE_ID, this.getApplicationProperties().getString("jira.baseurl"), params, null);
            }
        }
        finally {
            jiraAuthenticationContext.setLoggedInUser(originalUser);
        }
    }

    @VisibleForTesting
    JiraAuthenticationContext getJiraAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    public IssueTableLayoutBean getTableLayout(ApplicationUser user) throws Exception {
        Query query;
        SearchRequest searchRequest = this.getSearchRequest();
        List searchSorts = null;
        if (searchRequest != null && (query = searchRequest.getQuery()).getOrderByClause() != null) {
            searchSorts = query.getOrderByClause().getSearchSorts();
        }
        IssueTableLayoutBean bean = new IssueTableLayoutBean(this.getColumns(user), searchSorts);
        bean.setSortingEnabled(false);
        bean.addCellDisplayParam("email_view", (Object)Boolean.TRUE);
        bean.addCellDisplayParam(ATTACHMENTS_MANAGER_KEY, (Object)this.mailAttachmentsManager);
        return bean;
    }

    public List<ColumnLayoutItem> getColumns(ApplicationUser user) throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest == null) {
            return this.getColumnsProvider().getUserColumns(user);
        }
        return this.getColumnsProvider().getColumns(user, searchRequest);
    }

    @VisibleForTesting
    ColumnLayoutItemProvider getColumnsProvider() {
        return new ColumnLayoutItemProvider();
    }

    @VisibleForTesting
    I18nHelper.BeanFactory getI18nBeanFactory() {
        return (I18nHelper.BeanFactory)ComponentAccessor.getComponent(I18nHelper.BeanFactory.class);
    }

    @VisibleForTesting
    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    @VisibleForTesting
    SearchRequestService getSearchRequestService() {
        return (SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class);
    }

    public String getSubject() {
        I18nHelper i18n = this.getI18nBeanFactory().getInstance(this.getApplicationProperties().getDefaultLocale());
        try {
            String subjectTemplate = this.templateManager.getTemplateContent(this.FILTER_SUBSCRIPTION_TEMPLATE_ID, "subject");
            Map<String, Object> contextParams = this.getContextParams(this.subscription, this.getSearchRequest(), null);
            contextParams.put("i18n", i18n);
            OutlookDate formatter = new OutlookDate(i18n.getLocale());
            contextParams.put("dateformatter", formatter);
            return this.getTemplatingEngine().render(TemplateSources.fragment((String)subjectTemplate)).applying(contextParams).asPlainText();
        }
        catch (Exception e) {
            log.error("Could not determine subject", (Throwable)e);
            return i18n.getText("bulk.bean.initialise.error");
        }
    }

    @VisibleForTesting
    SearchRequest getSearchRequest() {
        if (this.request == null) {
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getSubscriptionUser());
            this.request = this.getSearchRequestService().getFilter((JiraServiceContext)ctx, this.subscription.getFilterId());
        }
        return this.request;
    }

    private ApplicationUser getSubscriptionUser() {
        if (this.subscriptionCreator == null) {
            this.subscriptionCreator = this.userManager.getUserByKey(this.subscription.getUserKey());
        }
        return this.subscriptionCreator;
    }

    private Map<String, Object> getContextParams(FilterSubscription sub, SearchRequest sr, ApplicationUser u) throws Exception {
        String baseURL = this.getApplicationProperties().getString("jira.baseurl");
        String contextPath = this.getContextPath(baseURL);
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        IssueTableLayoutBean tableLayout = this.getTableLayout(u);
        IssueTableWebComponent iwtc = new IssueTableWebComponent();
        ActionContext oldCtx = ActionContext.getContext();
        ActionContext.setContext((ActionContext)new ActionContext());
        ActionContext.setRequest((HttpServletRequest)new SubscriptionMailQueueMockRequest(contextPath));
        ActionContext.setContext((ActionContext)oldCtx);
        if (u != null) {
            SearchResults results = this.getSearchProvider().search(sr != null ? sr.getQuery() : null, u, this.getPageFilter());
            List issues = results.getIssues();
            String issueTableHtml = iwtc.getHtml(tableLayout, issues, null);
            contextParams.put("totalIssueCount", results.getTotal());
            contextParams.put("actualIssueCount", issues.size());
            contextParams.put("issueTableHtml", issueTableHtml);
            contextParams.put("issues", issues);
            contextParams.put("user", u);
        }
        if (this.getSubscriptionUser() != null) {
            contextParams.put(USER_KEY_COLUMN_NAME, this.getSubscriptionUser().getUsername());
        }
        contextParams.put("baseHREF", this.getBaseURLWithoutContext(baseURL));
        contextParams.put("constantsManager", this.getConstantsManager());
        contextParams.put("req", new SubscriptionMailQueueMockRequest(contextPath));
        contextParams.put("searchRequest", sr);
        contextParams.put("SRUtils", new SearchRequestUtils());
        contextParams.put("subscription", sub);
        contextParams.put("StringUtils", new StringUtils());
        contextParams.put("HTMLUtils", new HTMLUtils());
        contextParams.put("build", ComponentAccessor.getComponent(BuildUtilsInfo.class));
        contextParams.put("textutils", new TextUtils());
        contextParams.put("webResourceManager", this.getWebResourceManager());
        contextParams.put("urlModeAbsolute", UrlMode.ABSOLUTE);
        contextParams.put(ATTACHMENTS_MANAGER_KEY, this.mailAttachmentsManager);
        return contextParams;
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    @VisibleForTesting
    SearchProvider getSearchProvider() {
        return (SearchProvider)ComponentAccessor.getComponent(SearchProvider.class);
    }

    @VisibleForTesting
    WebResourceManager getWebResourceManager() {
        return ComponentAccessor.getWebResourceManager();
    }

    @VisibleForTesting
    ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    private String getContextPath(String baseURL) {
        try {
            URL url = new URL(baseURL);
            return url.getPath();
        }
        catch (MalformedURLException e) {
            log.error("Incorrect baseURL format: " + baseURL);
            return "";
        }
    }

    private String getBaseURLWithoutContext(String baseURL) {
        String path = this.getContextPath(baseURL);
        return StringUtils.chomp((String)baseURL, (String)path);
    }

    private PagerFilter getPageFilter() {
        int maxEmail;
        String application = this.getApplicationProperties().getDefaultBackedString("jira.subscription.email.max.issues");
        if (StringUtils.isBlank((String)application)) {
            log.warn("The maximum number of issues to include in subscription email '({})' is not configured. Using default of {}", (Object)"jira.subscription.email.max.issues", (Object)200);
            maxEmail = 200;
        } else {
            try {
                maxEmail = Integer.parseInt(application);
                if (maxEmail == 0) {
                    log.warn("The maximum number of issues to include in subscription email '({})' cannot be zero. Using default of {}", (Object)"jira.subscription.email.max.issues", (Object)200);
                    maxEmail = 200;
                } else if (maxEmail < 0) {
                    maxEmail = -1;
                }
            }
            catch (NumberFormatException e) {
                log.warn("The maximum number of issues to include in subscription email '({})' is not a valid number. Using default of {}", (Object)"jira.subscription.email.max.issues", (Object)200);
                maxEmail = 200;
            }
        }
        return new PagerFilter(maxEmail);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionMailQueueItem)) {
            return false;
        }
        SubscriptionMailQueueItem subscriptionMailQueueItem = (SubscriptionMailQueueItem)((Object)o);
        if (this.request != null ? !this.request.equals((Object)subscriptionMailQueueItem.request) : subscriptionMailQueueItem.request != null) {
            return false;
        }
        if (!this.subscription.equals(subscriptionMailQueueItem.subscription)) {
            return false;
        }
        return !(this.subscriptionCreator != null ? !this.subscriptionCreator.equals((Object)subscriptionMailQueueItem.subscriptionCreator) : subscriptionMailQueueItem.subscriptionCreator != null);
    }

    public int hashCode() {
        int result = this.subscription.hashCode();
        result = 29 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 29 * result + (this.subscriptionCreator != null ? this.subscriptionCreator.hashCode() : 0);
        return result;
    }

    public String toString() {
        ApplicationUser subscriptionUser = this.getSubscriptionUser();
        return ((Object)((Object)this)).getClass().getName() + " owner: '" + subscriptionUser + "'";
    }
}

