/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.function.Consumer;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedSQLInterceptor
implements SQLConnectionInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChainedSQLInterceptor.class);
    private final List<SQLConnectionInterceptor> forward;
    private final List<SQLConnectionInterceptor> reverse;

    private ChainedSQLInterceptor(List<SQLConnectionInterceptor> interceptorsList) {
        this.forward = interceptorsList;
        this.reverse = Lists.reverse(interceptorsList);
    }

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        ChainedSQLInterceptor.forEach(this.forward, interceptor -> interceptor.onConnectionTaken(connection, connectionPoolState));
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        ChainedSQLInterceptor.forEach(this.reverse, interceptor -> interceptor.onConnectionReplaced(connection, connectionPoolState));
    }

    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
        ChainedSQLInterceptor.forEach(this.forward, interceptor -> interceptor.beforeExecution(sqlString, parameterValues, statement));
    }

    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
        ChainedSQLInterceptor.forEach(this.reverse, interceptor -> interceptor.afterSuccessfulExecution(sqlString, parameterValues, statement, resultSet, rowsUpdated));
    }

    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
        ChainedSQLInterceptor.forEach(this.reverse, interceptor -> interceptor.onException(sqlString, parameterValues, statement, sqlException));
    }

    private static void forEach(List<SQLConnectionInterceptor> interceptors, Consumer<SQLConnectionInterceptor> callback) {
        for (SQLConnectionInterceptor interceptor : interceptors) {
            try {
                callback.accept(interceptor);
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected exception in {}", (Object)interceptor, (Object)e);
            }
        }
    }

    public static class Builder {
        private ImmutableList.Builder<SQLConnectionInterceptor> interceptorsList = ImmutableList.builder();

        public Builder add(SQLConnectionInterceptor sqlInterceptor) {
            this.interceptorsList.add((Object)sqlInterceptor);
            return this;
        }

        public ChainedSQLInterceptor build() {
            return new ChainedSQLInterceptor((List)this.interceptorsList.build());
        }
    }
}

