/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptors;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldSearcherModuleDescriptorsImpl
implements CustomFieldSearcherModuleDescriptors {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldSearcherModuleDescriptorsImpl.class);
    private PluginAccessor pluginAccessor;

    public CustomFieldSearcherModuleDescriptorsImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Option<CustomFieldSearcher> getCustomFieldSearcher(String completeModuleKey) {
        if (!ObjectUtils.isValueSelected((Object)completeModuleKey)) {
            return Option.none();
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(completeModuleKey);
        if (module instanceof CustomFieldSearcherModuleDescriptor) {
            CustomFieldSearcher searcher = (CustomFieldSearcher)((CustomFieldSearcherModuleDescriptor)module).getModule();
            return Option.some((Object)searcher);
        }
        log.warn("Custom field searcher module: " + completeModuleKey + " is invalid. Null being returned.");
        return Option.none();
    }
}

