/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.plugin.ha.PluginEventType;
import com.atlassian.jira.plugin.ha.ReplicatedPluginManager;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class MessageEventRegistry {
    private final Map<PluginEventType, Function<String, Void>> pluginUpdateMethods = Maps.newEnumMap(PluginEventType.class);
    private final ReplicatedPluginManager replicatedPluginManager;

    public MessageEventRegistry(ReplicatedPluginManager replicatedPluginManager) {
        this.replicatedPluginManager = replicatedPluginManager;
        this.initailiseEventMap();
    }

    private void initailiseEventMap() {
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_DISABLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.disablePlugin(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_ENABLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.enablePlugin(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_UPGRADED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.upgradePlugin(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_MODULE_DISABLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.disablePluginModule(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_MODULE_ENABLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.enablePluginModule(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_UNINSTALLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.uninstallPlugin(input);
                return null;
            }
        });
        this.pluginUpdateMethods.put(PluginEventType.PLUGIN_INSTALLED, new Function<String, Void>(){

            public Void apply(@Nullable String input) {
                MessageEventRegistry.this.replicatedPluginManager.installPlugin(input);
                return null;
            }
        });
    }

    public Function<String, Void> getEventFunction(PluginEventType pluginEventType) {
        return this.pluginUpdateMethods.get((Object)pluginEventType);
    }
}

