/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.CachingUserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.plugin.userformat.UserFormatterImpl;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatModuleDescriptors;
import com.atlassian.jira.user.UserKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserFormats
implements UserFormats {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserFormats.class);
    private final UserFormatTypeConfiguration userFormatTypeConfiguration;
    private final UserFormatModuleDescriptors userFormatModuleDescriptors;
    private final UserKeyService userKeyService;

    public DefaultUserFormats(UserFormatTypeConfiguration userFormatTypeConfiguration, UserFormatModuleDescriptors userFormatModuleDescriptors, UserKeyService userKeyService) {
        this.userFormatTypeConfiguration = userFormatTypeConfiguration;
        this.userFormatModuleDescriptors = userFormatModuleDescriptors;
        this.userKeyService = userKeyService;
    }

    public UserFormat forType(String type) {
        if (this.userFormatTypeConfiguration.containsType(type)) {
            String moduleKey = this.userFormatTypeConfiguration.getUserFormatKeyForType(type);
            if (this.userFormatModuleDescriptors.withKey(moduleKey) != null) {
                return new CachingUserFormat((UserFormat)this.userFormatModuleDescriptors.withKey(moduleKey).getModule());
            }
            log.info(String.format("Disabled user format found mapped to type '%s'. Falling back to system default.", type));
            return new CachingUserFormat(this.defaultUserFormatForType(type));
        }
        UserFormat defaultUserFormatForType = this.defaultUserFormatForType(type);
        if (defaultUserFormatForType != null) {
            log.info(String.format("Mapping user format type '%s' to the default format in module with key '%s'", type, this.userFormatModuleDescriptors.defaultFor(type).getCompleteKey()));
            this.userFormatTypeConfiguration.setUserFormatKeyForType(type, this.userFormatModuleDescriptors.defaultFor(type).getCompleteKey());
        }
        return new CachingUserFormat(defaultUserFormatForType);
    }

    public UserFormatter formatter(String type) {
        return new UserFormatterImpl(this.forType(type), this.userKeyService);
    }

    private UserFormat defaultUserFormatForType(String type) {
        UserFormatModuleDescriptor defaultDescriptorForType = this.userFormatModuleDescriptors.defaultFor(type);
        if (defaultDescriptorForType != null) {
            return (UserFormat)defaultDescriptorForType.getModule();
        }
        log.error(String.format("Falling back to a default user format for type: %s FAILED.", type));
        return null;
    }
}

