/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileLinkUserFormat
implements UserFormat {
    public static final String TYPE = "profileLink";
    private static final Logger log = LoggerFactory.getLogger(ProfileLinkUserFormat.class);
    private final AvatarService avatarService;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserKeyService userKeyService;
    private final UserUtil userUtil;

    public ProfileLinkUserFormat(AvatarService avatarService, I18nHelper i18nHelper, JiraAuthenticationContext jiraAuthenticationContext, UserFormatModuleDescriptor moduleDescriptor, UserKeyService userKeyService, UserUtil userUtil) {
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.moduleDescriptor = moduleDescriptor;
        this.userKeyService = userKeyService;
        this.userUtil = userUtil;
    }

    @HtmlSafe
    public String format(String key, String id) {
        Map<String, Object> params = this.getInitialParams(key, id);
        return this.moduleDescriptor.getHtml("view", params);
    }

    @HtmlSafe
    public String format(String key, String id, Map<String, Object> params) {
        Map<String, Object> velocityParams = this.getInitialParams(key, id);
        velocityParams.putAll(params);
        return this.moduleDescriptor.getHtml("view", velocityParams);
    }

    private Map<String, Object> getInitialParams(String key, String id) {
        ApplicationUser user = null;
        String username = null;
        String fullName = null;
        if (key != null) {
            user = this.userUtil.getUserByKey(key);
            if (user == null) {
                username = this.userKeyService.getUsernameForKey(key);
                if (username == null) {
                    username = key;
                }
                fullName = username;
            } else {
                username = user.getUsername();
                fullName = this.userUtil.getDisplayableNameSafely(user);
                if (!user.isActive()) {
                    fullName = fullName + " (" + this.jiraAuthenticationContext.getI18nHelper().getText("admin.common.words.inactive") + ')';
                }
            }
        }
        Avatar.Size avatarSize = Avatar.Size.SMALL;
        String avatarURL = this.avatarService.getAvatarURL(this.jiraAuthenticationContext.getUser(), user, avatarSize).toString();
        return MapBuilder.newBuilder().add((Object)"avatarURL", (Object)avatarURL).add((Object)"avatarSize", (Object)avatarSize.getParam()).add((Object)"defaultFullName", (Object)this.i18nHelper.getText("common.words.anonymous")).add((Object)"fullname", (Object)fullName).add((Object)"id", (Object)id).add((Object)"user", (Object)user).add((Object)"username", (Object)username).add((Object)"userAsJson", (Object)ProfileLinkUserFormat.toJson(avatarURL, fullName, ProfileLinkUserFormat.emptyEmailIfUserIsNull(user), username)).add((Object)"soyRenderer", (Object)this.getSoyRenderer()).toMutableMap();
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return ((SoyTemplateRendererProvider)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRendererProvider.class)).getRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject toJson(String avatarUrl, String fullName, String email, String username) {
        JSONObject result = new JSONObject();
        try {
            result.put("avatarUrl", (Object)avatarUrl).put("displayName", (Object)fullName).put("emailAddress", (Object)email).put("username", (Object)username);
        }
        catch (JSONException e) {
            log.info("It has failed to create an Json object for given information, so that the empty Json will be returned", (Throwable)e);
        }
        finally {
            return result;
        }
    }

    private static String emptyEmailIfUserIsNull(ApplicationUser user) {
        return user == null ? "" : user.getEmailAddress();
    }
}

