/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.prebake.PrebakeConfig;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class JiraPrefixCDNStrategy
implements CDNStrategy {
    static final String ENABLED_FEATURE_KEY = "jira.fixed.cdn.enabled";
    static final String PREFIX_SYSTEM_PROPERTY = "jira.fixed.cdn.prefix";
    private final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
    private final Optional<PrebakeConfig> prebakeConfig;

    public JiraPrefixCDNStrategy(Optional<PrebakeConfig> prebakeConfig) {
        this.prebakeConfig = prebakeConfig;
    }

    public boolean supportsCdn() {
        return !StringUtils.isBlank((String)this.getPrefix());
    }

    public String transformRelativeUrl(String s) {
        return this.getPrefix() + s;
    }

    private String getPrefix() {
        return this.jiraSystemProperties.getProperty(PREFIX_SYSTEM_PROPERTY);
    }

    public Optional<PrebakeConfig> getPrebakeConfig() {
        return this.prebakeConfig;
    }
}

