/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.WorkflowDescriptorUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractWorkflowPermissionPluginFactory
extends AbstractWorkflowPluginFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    protected AbstractWorkflowPermissionPluginFactory(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    public Map<String, ?> getDescriptorParams(Map<String, Object> params) {
        String permission = this.extractSingleParam(params, "permissionKey");
        return ImmutableMap.of((Object)"permissionKey", (Object)permission);
    }

    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        this.populateTemplateParamsForInputAndEdit(velocityParams, null);
    }

    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        this.populateTemplateParamsForInputAndEdit(velocityParams, this.extractArgs(descriptor));
    }

    protected void populateTemplateParamsForInputAndEdit(Map<String, Object> velocityParams, Map<?, ?> descriptorArgs) {
        ProjectPermissionKey permissionKey = null;
        if (descriptorArgs != null) {
            permissionKey = WorkflowDescriptorUtil.resolvePermissionKey(descriptorArgs);
            velocityParams.put("permission", permissionKey.permissionKey());
        }
        velocityParams.put("permissions", Collections.unmodifiableMap(this.getGroupedPermissions(permissionKey)));
    }

    private Map<String, Map<String, String>> getGroupedPermissions(ProjectPermissionKey selectedKey) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        LinkedHashMap groups = Maps.newLinkedHashMap();
        groups.put("admin.permission.group.project.permissions", this.permissionsWithCategory(ProjectPermissionCategory.PROJECTS, i18nHelper));
        groups.put("admin.permission.group.issue.permissions", this.permissionsWithCategory(ProjectPermissionCategory.ISSUES, i18nHelper));
        groups.put("admin.permission.group.voters.and.watchers.permissions", this.permissionsWithCategory(ProjectPermissionCategory.VOTERS_AND_WATCHERS, i18nHelper));
        groups.put("admin.permission.group.comments.permissions", this.permissionsWithCategory(ProjectPermissionCategory.COMMENTS, i18nHelper));
        groups.put("admin.permission.group.attachments.permissions", this.permissionsWithCategory(ProjectPermissionCategory.ATTACHMENTS, i18nHelper));
        groups.put("admin.permission.group.time.tracking.permissions", this.permissionsWithCategory(ProjectPermissionCategory.TIME_TRACKING, i18nHelper));
        Map<String, String> otherPermissions = this.permissionsWithCategory(ProjectPermissionCategory.OTHER, i18nHelper);
        if (!otherPermissions.isEmpty()) {
            groups.put("admin.permission.group.other.permissions", otherPermissions);
        }
        if (selectedKey != null && !this.permissionsContainSelected(groups, selectedKey)) {
            groups.put("admin.permission.group.unavailable.permissions", MapBuilder.singletonMap((Object)selectedKey.permissionKey(), (Object)selectedKey.permissionKey()));
        }
        return groups;
    }

    private Map<String, String> permissionsWithCategory(ProjectPermissionCategory category, I18nHelper i18nHelper) {
        LinkedHashMap keysToPermissionNames = Maps.newLinkedHashMap();
        for (ProjectPermission permission : this.permissionManager.getProjectPermissions(category)) {
            String permissionName = i18nHelper.getText(permission.getNameI18nKey());
            keysToPermissionNames.put(permission.getKey(), permissionName);
        }
        return keysToPermissionNames;
    }

    private boolean permissionsContainSelected(Map<String, Map<String, String>> groups, ProjectPermissionKey selectedKey) {
        for (Map<String, String> permissions : groups.values()) {
            if (!permissions.containsKey(selectedKey.permissionKey())) continue;
            return true;
        }
        return false;
    }

    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        this.populateTemplateParamsForView(velocityParams, this.extractArgs(descriptor));
    }

    protected void populateTemplateParamsForView(Map<String, Object> velocityParams, Map<?, ?> descriptorArgs) {
        ProjectPermissionKey permissionKey = WorkflowDescriptorUtil.resolvePermissionKey(descriptorArgs);
        Option permission = this.permissionManager.getProjectPermission(permissionKey);
        if (permission.isDefined()) {
            velocityParams.put("permission", ((ProjectPermission)permission.get()).getNameI18nKey());
            velocityParams.put("defined", true);
        } else {
            velocityParams.put("permission", permissionKey.permissionKey());
            velocityParams.put("defined", false);
        }
    }

    protected abstract Map<?, ?> extractArgs(AbstractDescriptor var1);

    protected void clearLegacyPermissionArgument(Map<?, ?> descriptorArgs) {
        if (descriptorArgs.containsKey("permission")) {
            descriptorArgs.remove("permission");
        }
    }
}

