/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectTypeValidator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.project.ProjectAvatarUpdateEvent;
import com.atlassian.jira.event.project.ProjectCategoryChangeEvent;
import com.atlassian.jira.event.project.ProjectCategoryUpdateEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCategoryStore;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.ProjectRelationConstants;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultProjectManager
extends AbstractProjectManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectManager.class);
    public static final String APPLINKS_LOCAL_PROPERTY_PREFIX = "applinks.local";
    private final OfBizDelegator delegator;
    private final DbConnectionManager dbConnectionManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final ProjectFactory projectFactory;
    private final ProjectRoleManager projectRoleManager;
    private final IssueManager issueManager;
    private final AvatarManager avatarManager;
    private final ProjectCategoryStore projectCategoryStore;
    private final ProjectKeyStore projectKeyStore;
    private final TransactionSupport transactionSupport;
    private final PropertiesManager propertiesManager;
    private final NextIdGenerator nextIdGenerator;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final EventPublisher eventPublisher;
    private final ProjectTypeValidator projectTypeValidator;

    public DefaultProjectManager(OfBizDelegator delegator, DbConnectionManager dbConnectionManager, NodeAssociationStore nodeAssociationStore, ProjectFactory projectFactory, ProjectRoleManager projectRoleManager, IssueManager issueManager, AvatarManager avatarManager, UserManager userManager, ProjectCategoryStore projectCategoryStore, ApplicationProperties applicationProperties, ProjectKeyStore projectKeyStore, TransactionSupport transactionSupport, PropertiesManager propertiesManager, JsonEntityPropertyManager jsonEntityPropertyManager, EventPublisher eventPublisher, ProjectTypeValidator projectTypeValidator) {
        super(userManager, applicationProperties);
        this.delegator = delegator;
        this.dbConnectionManager = dbConnectionManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.projectFactory = projectFactory;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.avatarManager = avatarManager;
        this.projectCategoryStore = projectCategoryStore;
        this.projectKeyStore = projectKeyStore;
        this.transactionSupport = transactionSupport;
        this.propertiesManager = propertiesManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.nextIdGenerator = new NextIdGenerator(delegator, issueManager);
        this.eventPublisher = eventPublisher;
        this.projectTypeValidator = projectTypeValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(@Nonnull ApplicationUser user, @Nonnull ProjectCreationData projectCreationData) {
        String key = projectCreationData.getKey();
        String name = projectCreationData.getName();
        ApplicationUser lead = projectCreationData.getLead();
        String url = projectCreationData.getUrl();
        String description = projectCreationData.getDescription();
        Long avatarId = projectCreationData.getAvatarId();
        Long assigneeType = projectCreationData.getAssigneeType();
        ProjectTypeKey projectTypeKey = projectCreationData.getProjectTypeKey();
        Assertions.notNull((String)"key", (Object)key);
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"lead", (Object)lead);
        Preconditions.checkState((boolean)this.projectTypeValidator.isValid(user, projectTypeKey));
        if (avatarId == null) {
            avatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
        }
        Transaction transaction = this.transactionSupport.begin();
        try {
            Map<String, Object> params = new PrimitiveMap.Builder().add("key", key).add("originalkey", key).add("name", name).add("url", url).add("lead", lead.getKey()).add("description", description).add("counter", 0L).add("assigneetype", assigneeType).add("avatar", avatarId).add("projecttype", projectTypeKey != null ? projectTypeKey.getKey() : null).toMap();
            GenericValue projectGV = this.delegator.createValue("Project", params);
            ProjectImpl newProject = new ProjectImpl(projectGV);
            this.projectKeyStore.addProjectKey(newProject.getId(), newProject.getKey());
            this.projectRoleManager.applyDefaultsRolesToProject((Project)newProject);
            transaction.commit();
            ProjectImpl projectImpl = newProject;
            return projectImpl;
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
            this.projectKeyStore.refresh();
        }
    }

    public long getNextId(Project project) {
        return this.nextIdGenerator.getNextId(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project updateProject(Project updatedProject, String name, String description, String leadKey, String url, Long assigneeType, Long avatarId, String projectKey) {
        Assertions.notNull((String)"Project", (Object)updatedProject);
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"lead", (Object)leadKey);
        ProjectAvatarUpdateEvent projectAvatarUpdateEvent = null;
        Transaction transaction = this.transactionSupport.begin();
        try {
            GenericValue projectUpdate = this.delegator.makeValue("Project");
            projectUpdate.set("id", (Object)updatedProject.getId());
            projectUpdate.setString("name", name);
            projectUpdate.setString("url", url);
            projectUpdate.setString("lead", leadKey);
            projectUpdate.setString("description", description);
            projectUpdate.set("assigneetype", (Object)assigneeType);
            if (avatarId != null) {
                projectUpdate.set("avatar", (Object)avatarId);
                if (updatedProject.getAvatar() == null || !avatarId.equals(updatedProject.getAvatar().getId())) {
                    projectAvatarUpdateEvent = new ProjectAvatarUpdateEvent(updatedProject, avatarId);
                }
            }
            if (projectKey != null && !updatedProject.getKey().equals(projectKey)) {
                projectUpdate.setString("key", projectKey);
                Long projectId = this.projectKeyStore.getProjectId(projectKey);
                if (projectId == null) {
                    this.projectKeyStore.addProjectKey(updatedProject.getId(), projectKey);
                } else if (!projectId.equals(updatedProject.getId())) {
                    throw new RuntimeException("Key " + projectKey + " already used by project: " + projectId);
                }
                this.updateEntityLinks(updatedProject.getKey(), projectKey);
            }
            this.delegator.store(projectUpdate);
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
        this.getIssueSecurityLevelManager().clearUsersLevels();
        if (projectAvatarUpdateEvent != null) {
            this.eventPublisher.publish((Object)projectAvatarUpdateEvent);
        }
        return this.getProjectObj(updatedProject.getId());
    }

    public Project updateProjectType(ApplicationUser user, Project project, ProjectTypeKey newProjectType) {
        Preconditions.checkState((boolean)this.projectTypeValidator.isValid(user, newProjectType));
        this.dbConnectionManager.execute(dbConnection -> dbConnection.update((RelationalPath<?>)QProject.PROJECT).set((Path)QProject.PROJECT.projecttype, (Object)(newProjectType != null ? newProjectType.getKey() : null)).where((Predicate)QProject.PROJECT.id.eq((Object)project.getId())).execute());
        return this.getProjectObj(project.getId());
    }

    @VisibleForTesting
    void updateEntityLinks(String oldKey, String newKey) {
        Collection<String> oldPropertyKeys = this.getEntityLinkKeys(oldKey);
        for (String oldPropertyKey : oldPropertyKeys) {
            String value = this.propertiesManager.getPropertySet().getText(oldPropertyKey);
            String newPropertyKey = oldPropertyKey.replaceFirst("^" + Pattern.quote(this.prefix(oldKey)), this.prefix(newKey));
            this.propertiesManager.getPropertySet().setText(newPropertyKey, value);
            this.propertiesManager.getPropertySet().remove(oldPropertyKey);
        }
    }

    private Collection<String> getEntityLinkKeys(String oldKey) {
        return this.propertiesManager.getPropertySet().getKeys(this.prefix(oldKey));
    }

    private String prefix(String key) {
        return "applinks.local." + key + ".";
    }

    public void removeProjectIssues(Project project) throws RemoveException {
        Collection issueIds;
        Assertions.notNull((String)"Project", (Object)project);
        try {
            issueIds = this.issueManager.getIssueIdsForProject(project.getId());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        for (Long issueId : issueIds) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            if (issue != null) {
                try {
                    this.issueManager.deleteIssueNoEvent((Issue)issue);
                    continue;
                }
                catch (Exception e) {
                    log.error("Exception removing issues", (Throwable)e);
                    throw new RemoveException("Error removing issues: " + e, e);
                }
            }
            log.debug("Issue with id '" + issueId + "' was not found." + " Most likely it is a sub-task and has been deleted previously with its parent.");
        }
    }

    public void removeProject(Project project) {
        Assertions.notNull((String)"Project", (Object)project);
        this.projectRoleManager.removeAllRoleActorsByProject(project);
        this.projectKeyStore.deleteProjectKeys(project.getId());
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.PROJECT_PROPERTY.getDbEntityName(), project.getId());
        Delete.from("Project").whereIdEquals(project.getId()).execute(this.delegator);
    }

    protected GenericValue getProject(Long id) {
        return this.getDelegator().findById("Project", id);
    }

    public Project getProjectObj(Long id) {
        Project project = null;
        GenericValue gv = this.getProject(id);
        if (gv != null) {
            project = this.projectFactory.getProject(gv);
        }
        return project;
    }

    protected GenericValue getProjectByName(String name) {
        return EntityUtil.getOnly((List)this.getDelegator().findByAnd("Project", (Map)FieldMap.build((String)"name", (Object)name)));
    }

    protected GenericValue getProjectByKey(String key) {
        GenericValue gv = EntityUtil.getOnly((List)this.getDelegator().findByAnd("Project", (Map)FieldMap.build((String)"key", (Object)key)));
        if (gv != null) {
            return gv;
        }
        Long projectId = this.projectKeyStore.getProjectId(key);
        return projectId != null ? this.getProject(projectId) : null;
    }

    @Override
    public Project getProjectByCurrentKey(String projectKey) {
        GenericValue gv = EntityUtil.getOnly((List)this.getDelegator().findByAnd("Project", (Map)FieldMap.build((String)"key", (Object)projectKey)));
        if (gv != null) {
            return this.projectFactory.getProject(gv);
        }
        return null;
    }

    public Project getProjectObjByKey(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    public Project getProjectByCurrentKeyIgnoreCase(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv == null) {
            for (Project prj : this.getProjects()) {
                if (!prj.getKey().equalsIgnoreCase(projectKey)) continue;
                project = prj;
                break;
            }
        } else {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        ImmutableSortedMap projectKeys = ImmutableSortedMap.copyOf(this.projectKeyStore.getAllProjectKeys(), (Comparator)String.CASE_INSENSITIVE_ORDER);
        Long projectId = (Long)projectKeys.get(projectKey);
        if (projectId != null) {
            GenericValue projectGv = this.getProject(projectId);
            return projectGv != null ? this.projectFactory.getProject(projectGv) : null;
        }
        return null;
    }

    public Set<String> getAllProjectKeys(Long projectId) {
        return this.projectKeyStore.getProjectKeys(projectId);
    }

    public Project getProjectObjByName(String projectName) {
        Project project = null;
        GenericValue projectGv = this.getProjectByName(projectName);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Nonnull
    public List<Project> getProjects() {
        List projectGVs = this.getDelegator().findAll("Project", Collections.singletonList("name"));
        Collections.sort(projectGVs, OfBizComparators.NAME_COMPARATOR);
        return this.projectFactory.getProjects((Collection)projectGVs);
    }

    @Nonnull
    public List<Project> getProjectObjects() {
        return this.getProjects();
    }

    public long getProjectCount() throws DataAccessException {
        return this.getDelegator().getCount("Project");
    }

    protected OfBizDelegator getDelegator() {
        return this.delegator;
    }

    public List<ProjectCategory> getAllProjectCategories() {
        return this.projectCategoryStore.getAllProjectCategories();
    }

    public ProjectCategory getProjectCategory(Long id) {
        return this.projectCategoryStore.getProjectCategory(id);
    }

    @Nullable
    public ProjectCategory getProjectCategoryObject(Long id) {
        return this.getProjectCategory(id);
    }

    public void updateProjectCategory(@Nonnull ProjectCategory projectCategory) throws DataAccessException {
        ProjectCategory oldProjectCategory = this.projectCategoryStore.getProjectCategory(projectCategory.getId());
        if (!Objects.equal((Object)oldProjectCategory.getName(), (Object)projectCategory.getName()) || !Objects.equal((Object)oldProjectCategory.getDescription(), (Object)projectCategory.getDescription())) {
            this.projectCategoryStore.updateProjectCategory(projectCategory);
            this.eventPublisher.publish((Object)new ProjectCategoryUpdateEvent(oldProjectCategory, projectCategory));
        }
    }

    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        return this.getProjectObjectsFromProjectCategory(projectCategory.getId());
    }

    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        if (projectCategoryId == null) {
            return Collections.emptyList();
        }
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(ProjectRelationConstants.PROJECT_CATEGORY_ASSOC, projectCategoryId);
        List<Project> projects = this.getProjectsById(projectIds);
        Collections.sort(projects, ProjectNameComparator.COMPARATOR);
        return projects;
    }

    public Collection<Project> getProjectObjectsWithNoCategory() throws DataAccessException {
        List<Project> projects = this.getProjects();
        ArrayList result = Lists.newArrayListWithCapacity((int)projects.size());
        for (Project project : projects) {
            if (this.getProjectCategoryForProject(project) != null) continue;
            result.add(project);
        }
        Collections.sort(result, ProjectNameComparator.COMPARATOR);
        return result;
    }

    @Nullable
    public ProjectCategory getProjectCategoryForProject(Project project) throws DataAccessException {
        if (project == null) {
            return null;
        }
        List<GenericValue> projectCats = this.nodeAssociationStore.getSinksFromSource("Project", project.getId(), "ProjectCategory", "ProjectCategory");
        if (null == projectCats || projectCats.isEmpty()) {
            return null;
        }
        return (ProjectCategory)Entity.PROJECT_CATEGORY.build(projectCats.get(0));
    }

    public ProjectCategory createProjectCategory(String name, String description) {
        return this.projectCategoryStore.createProjectCategory(name, description);
    }

    public void removeProjectCategory(Long id) {
        this.projectCategoryStore.removeProjectCategory(id);
    }

    public boolean isProjectCategoryUnique(String name) {
        Collection projectCategories = this.getAllProjectCategories();
        return projectCategories == null || projectCategories.stream().allMatch(projectCategory -> !name.equalsIgnoreCase(projectCategory.getName()));
    }

    public void setProjectCategory(Project project, ProjectCategory projectCategory) {
        if (project == null) {
            throw new IllegalArgumentException("Cannot associate a category with a null project");
        }
        ProjectCategory oldProjectCategory = this.getProjectCategoryForProject(project);
        if (projectCategory != null && oldProjectCategory != null && Objects.equal((Object)projectCategory.getId(), (Object)oldProjectCategory.getId())) {
            return;
        }
        ProjectCategoryChangeEvent.Builder eventBuilder = new ProjectCategoryChangeEvent.Builder(project);
        if (oldProjectCategory != null) {
            this.nodeAssociationStore.removeAssociation(ProjectRelationConstants.PROJECT_CATEGORY_ASSOC, project.getId(), oldProjectCategory.getId());
            eventBuilder.addOldCategory(oldProjectCategory);
        }
        if (projectCategory != null) {
            this.nodeAssociationStore.createAssociation(ProjectRelationConstants.PROJECT_CATEGORY_ASSOC, project.getId(), projectCategory.getId());
            eventBuilder.addNewCategory(projectCategory);
        }
        if (eventBuilder.canBePublished()) {
            this.eventPublisher.publish((Object)eventBuilder.build());
        }
    }

    public List<Project> getProjectsLeadBy(ApplicationUser leadUser) {
        List<GenericValue> projects = this.findProjectsByLead(leadUser);
        return this.projectFactory.getProjects(projects);
    }

    private List<GenericValue> findProjectsByLead(ApplicationUser leadUser) {
        if (leadUser == null) {
            return Collections.emptyList();
        }
        ApplicationUser leadAppUser = this.userManager.getUserByName(leadUser.getName());
        if (leadAppUser == null) {
            return Collections.emptyList();
        }
        return this.getDelegator().findByAnd("Project", (Map)FieldMap.build((String)"lead", (Object)leadAppUser.getKey()), Collections.singletonList("name"));
    }

    private List<Project> getProjectsById(List<Long> projectIds) {
        ArrayList<Project> projects = new ArrayList<Project>(projectIds.size());
        for (Long projectId : projectIds) {
            projects.add(this.getProjectObj(projectId));
        }
        return projects;
    }

    public void refresh() {
    }

    IssueSecurityLevelManager getIssueSecurityLevelManager() {
        return (IssueSecurityLevelManager)ComponentAccessor.getComponentOfType(IssueSecurityLevelManager.class);
    }

    public long getCurrentCounterForProject(Long id) {
        return this.nextIdGenerator.getCurrentCounterForProject(id);
    }

    public void setCurrentCounterForProject(Project project, long counter) {
        this.nextIdGenerator.resetCounter(project, counter);
    }

    @EventListener
    public void shutdown(ComponentManagerShutdownEvent shutdownEvent) {
        this.nextIdGenerator.shutdown();
    }

    static class NextIdGenerator {
        private final OfBizDelegator ofBizDelegator;
        private final IssueManager issueManager;
        private final ExecutorService executor = NextIdGenerator.createSelfCleaningExecutorService();

        private static EntityCondition getProjectIdEqualsCondition(long projectId) {
            return new EntityExpr("id", EntityOperator.EQUALS, (Object)projectId);
        }

        private static ExecutorService createSelfCleaningExecutorService() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ProjectCounterUpdateThread-%d").build();
            return Executors.newCachedThreadPool(threadFactory);
        }

        private static long getNonNullCounter(GenericValue project) {
            Long counterObject = project.getLong("counter");
            return counterObject == null ? 0L : counterObject;
        }

        NextIdGenerator(OfBizDelegator delegator, IssueManager issueManager) {
            this.ofBizDelegator = delegator;
            this.issueManager = issueManager;
        }

        long getNextId(Project project) {
            if (project == null) {
                throw new IllegalArgumentException();
            }
            final EntityCondition projectIdCondition = NextIdGenerator.getProjectIdEqualsCondition(project.getId());
            try {
                Future<Long> issueIdFuture;
                long nextId;
                while (this.counterAlreadyExists(nextId = (issueIdFuture = this.executor.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        GenericValue updatedProject = ofBizDelegator.transformOne("Project", projectIdCondition, "counter", new Transformation(){

                            public void transform(GenericValue entity) {
                                long currentCounter = NextIdGenerator.getNonNullCounter(entity);
                                entity.set("counter", (Object)(currentCounter + 1L));
                            }
                        });
                        return NextIdGenerator.getNonNullCounter(updatedProject);
                    }
                })).get().longValue(), project)) {
                }
                return nextId;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        long getCurrentCounterForProject(long projectId) {
            List gvs = this.ofBizDelegator.findByCondition("Project", NextIdGenerator.getProjectIdEqualsCondition(projectId), (Collection)ImmutableList.of((Object)"counter"));
            Validate.validState((gvs.size() <= 1 ? 1 : 0) != 0, (String)"Expected at most one Project with ID %d but found these: %s", (Object[])new Object[]{projectId, gvs});
            return gvs.isEmpty() ? 0L : NextIdGenerator.getNonNullCounter((GenericValue)gvs.get(0));
        }

        private boolean counterAlreadyExists(long incCount, Project project) throws GenericEntityException {
            String issueKey = IssueKey.format((Project)project, (long)incCount);
            boolean alreadyExists = this.issueManager.isExistingIssueKey(issueKey);
            if (alreadyExists) {
                log.warn("Existing issue found for key " + issueKey + ". Incrementing key.");
            }
            return alreadyExists;
        }

        void resetCounter(Project project, final long counter) {
            EntityCondition projectIdCondition = NextIdGenerator.getProjectIdEqualsCondition(project.getId());
            this.ofBizDelegator.transformOne("Project", projectIdCondition, "counter", new Transformation(){

                public void transform(GenericValue entity) {
                    entity.set("counter", (Object)counter);
                }
            });
        }

        public void shutdown() {
            this.executor.shutdownNow();
        }
    }

    static class Model {
        static final String ENTITY_NAME = "Project";
        static final String ID_FIELD = "id";
        static final String NAME_FIELD = "name";
        static final String URL_FIELD = "url";
        static final String LEAD_FIELD = "lead";
        static final String DESCRIPTION_FIELD = "description";
        static final String KEY_FIELD = "key";
        static final String COUNTER_FIELD = "counter";
        static final String ASSIGNEE_TYPE_FIELD = "assigneetype";
        static final String AVATAR_FIELD = "avatar";
        static final String ORIGINAL_KEY_FIELD = "originalkey";
        static final String PROJECT_TYPE_KEY = "projecttype";

        Model() {
        }
    }
}

