/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.browse;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.ProjectHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BrowseProjectContext
implements BrowseContext {
    protected Project project;
    private final ApplicationUser user;
    protected TerminalClause projectClause;

    public BrowseProjectContext(ApplicationUser user, Project project) {
        this.project = project;
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public Query createQuery() {
        return new QueryImpl((Clause)this.getProjectClause());
    }

    protected TerminalClause getProjectClause() {
        if (this.projectClause == null) {
            this.projectClause = new TerminalClauseImpl("project", Operator.EQUALS, this.getProject().getKey());
        }
        return this.projectClause;
    }

    protected ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    protected SearchService getSearchService() {
        return (SearchService)ComponentAccessor.getComponent(SearchService.class);
    }

    public String getQueryString() {
        QueryImpl query = new QueryImpl((Clause)this.getProjectClause());
        return this.getSearchService().getQueryString(this.getUser(), (Query)query);
    }

    public Map<String, Object> createParameterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("project", this.getProject());
        map.put("user", this.getUser());
        map.put("helper", this.getHelper());
        map.put("contextType", "project");
        return map;
    }

    public String getContextKey() {
        return this.project.getKey();
    }

    private JiraHelper getHelper() {
        return new ProjectHelper(this.getExecutingHttpRequest(), this);
    }

    @VisibleForTesting
    protected HttpServletRequest getExecutingHttpRequest() {
        return ExecutingHttpRequest.get();
    }
}

