/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionBuilderImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.event.project.VersionArchiveEvent;
import com.atlassian.jira.event.project.VersionCreateEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionMoveEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnarchiveEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.project.VersionUpdatedEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.model.querydsl.QNodeAssociation;
import com.atlassian.jira.model.querydsl.QVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionImpl;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.project.version.VersionPredicates;
import com.atlassian.jira.project.version.VersionStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.NamedPredicates;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVersionManager
implements VersionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultVersionManager.class);
    private final IssueManager issueManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final IssueIndexManager issueIndexManager;
    private final VersionStore versionStore;
    private final EventPublisher eventPublisher;
    private final DbConnectionManager dbConnectionManager;

    public DefaultVersionManager(IssueManager issueManager, NodeAssociationStore nodeAssociationStore, IssueIndexManager issueIndexManager, VersionStore versionStore, EventPublisher eventPublisher, DbConnectionManager dbConnectionManager) {
        this.issueManager = issueManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.issueIndexManager = issueIndexManager;
        this.versionStore = versionStore;
        this.eventPublisher = eventPublisher;
        this.dbConnectionManager = dbConnectionManager;
    }

    @Deprecated
    public Version createVersion(String name, Date releaseDate, String description, GenericValue project, Long scheduleAfterVersion) throws CreateException {
        if (project == null) {
            throw new CreateException("You cannot create a version without a project.");
        }
        return this.createVersion(name, releaseDate, description, project.getLong("id"), scheduleAfterVersion);
    }

    public Version createVersion(String name, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion) throws CreateException {
        return this.createVersion(name, null, releaseDate, description, projectId, scheduleAfterVersion);
    }

    public Version createVersion(String name, Date startDate, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion) throws CreateException {
        return this.createVersion(name, startDate, releaseDate, description, projectId, scheduleAfterVersion, false);
    }

    public Version createVersion(String name, Date startDate, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion, boolean released) throws CreateException {
        if (!TextUtils.stringSet((String)name)) {
            throw new CreateException("You cannot create a version without a name.");
        }
        if (projectId == null) {
            throw new CreateException("You cannot create a version without a project.");
        }
        VersionBuilder builder = new VersionBuilderImpl().projectId(projectId).name(name).description(description).released(released);
        if (startDate != null) {
            builder.startDate((Date)new Timestamp(startDate.getTime()));
        }
        if (releaseDate != null) {
            builder.releaseDate((Date)new Timestamp(releaseDate.getTime()));
        }
        this.configureSchedulingOrderForVersion(projectId, scheduleAfterVersion, builder);
        Version newVersion = this.versionStore.createVersion(builder.build());
        this.eventPublisher.publish((Object)new VersionCreateEvent(newVersion));
        return newVersion;
    }

    private void configureSchedulingOrderForVersion(Long projectId, Long scheduleAfterVersion, VersionBuilder builder) {
        if (scheduleAfterVersion != null) {
            if (scheduleAfterVersion == -1L) {
                this.moveAllVersionSequences(projectId);
                builder.sequence(Long.valueOf(1L));
            } else {
                this.moveVersionSequences(scheduleAfterVersion);
                Long newSequence = this.getVersion(scheduleAfterVersion).getSequence() + 1L;
                builder.sequence(newSequence);
            }
        } else {
            builder.sequence(Long.valueOf(this.getMaxVersionSequence(projectId)));
        }
    }

    public Version moveToStartVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        CollectionReorderer.moveToStart(versions, version);
        this.storeReorderedVersionList(versions);
        this.eventPublisher.publish((Object)new VersionMoveEvent(version));
        return this.getVersion(version.getId());
    }

    public Version increaseVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        CollectionReorderer.increasePosition(versions, version);
        this.storeReorderedVersionList(versions);
        this.eventPublisher.publish((Object)new VersionMoveEvent(version));
        return this.getVersion(version.getId());
    }

    public Version decreaseVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        CollectionReorderer.decreasePosition(versions, version);
        this.storeReorderedVersionList(versions);
        this.eventPublisher.publish((Object)new VersionMoveEvent(version));
        return this.getVersion(version.getId());
    }

    public Version moveToEndVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        CollectionReorderer.moveToEnd(versions, version);
        this.storeReorderedVersionList(versions);
        this.eventPublisher.publish((Object)new VersionMoveEvent(version));
        return this.getVersion(version.getId());
    }

    public Version moveVersionAfter(Version version, Long scheduleAfterVersionId) {
        if (version == null) {
            throw new IllegalArgumentException("You cannot move a null version");
        }
        if (version.getId() != null && !version.getId().equals(scheduleAfterVersionId)) {
            Object targetVersion = scheduleAfterVersionId == null ? this.getLastVersion(version.getProjectId()) : (scheduleAfterVersionId == -1L ? null : this.getVersion(scheduleAfterVersionId));
            ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
            CollectionReorderer.moveToPositionAfter(versions, version, targetVersion);
            this.storeReorderedVersionList(versions);
            this.eventPublisher.publish((Object)new VersionMoveEvent(version));
            return this.getVersion(version.getId());
        }
        return version;
    }

    private void moveVersionSequences(Long scheduleAfterVersion) {
        Version startVersion = this.getVersion(scheduleAfterVersion);
        List<Version> versions = this.getVersions(startVersion.getProjectId());
        ArrayList versionsChanged = Lists.newArrayListWithCapacity((int)versions.size());
        for (Version version : versions) {
            if (version.getSequence() <= startVersion.getSequence()) continue;
            Long newSequence = version.getSequence() + 1L;
            versionsChanged.add(new VersionBuilderImpl(version).sequence(newSequence).build());
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    private void moveAllVersionSequences(Long project) {
        List<Version> versions = this.getVersions(project);
        ArrayList versionsChanged = Lists.newArrayListWithCapacity((int)versions.size());
        for (Version version : versions) {
            Long newSequence = version.getSequence() + 1L;
            versionsChanged.add(new VersionBuilderImpl(version).sequence(newSequence).build());
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    public void deleteVersion(Version version) {
        this.deleteVersionWithoutPublishingAnEvent(version);
        this.eventPublisher.publish((Object)VersionDeleteEvent.deleted((Version)version));
    }

    public void deleteVersion(ApplicationUser applicationUser, Version versionToDelete, Option<Version> affectsSwapVersion, Option<Version> fixSwapVersion) {
        this.swapVersionForRelatedIssues(applicationUser, versionToDelete, affectsSwapVersion, fixSwapVersion);
        this.deleteVersionWithoutPublishingAnEvent(versionToDelete);
        this.eventPublisher.publish((Object)new VersionDeleteEvent.VersionDeleteEventBuilder(versionToDelete).affectsVersionSwappedTo((Version)affectsSwapVersion.getOrNull()).fixVersionSwappedTo((Version)fixSwapVersion.getOrNull()).createEvent());
    }

    private void deleteVersionWithoutPublishingAnEvent(Version version) {
        this.versionStore.deleteVersion(version);
        this.reorderVersionsInProject(version);
    }

    public void deleteAllVersions(@Nonnull Long projectId) {
        this.dbConnectionManager.execute(callback -> {
            QNodeAssociation na = QNodeAssociation.NODE_ASSOCIATION;
            QVersion v = QVersion.VERSION;
            callback.delete((RelationalPath<?>)na).where((Predicate)na.sinkNodeEntity.eq((Object)"IssueVersion").and((Predicate)na.sinkNodeId.in((CollectionExpression)((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)v)).where((Predicate)v.project.eq((Object)projectId))).list(v.id)))).execute();
        });
        this.versionStore.deleteAllVersions(projectId);
    }

    public Version update(Version version) {
        Version originalVersion = this.getVersion(version.getId());
        this.versionStore.storeVersion(version);
        this.eventPublisher.publish((Object)new VersionUpdatedEvent(version, originalVersion));
        return version;
    }

    public Version editVersionDetails(Version version, String name, String description) {
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("You must specify a valid version name.");
        }
        if (this.isDuplicateName(version, name)) {
            throw new IllegalArgumentException("A version with this name already exists in this project.");
        }
        VersionBuilderImpl versionInputParams = new VersionBuilderImpl(version);
        versionInputParams.name(name);
        versionInputParams.description(description);
        Version newVersion = versionInputParams.build();
        this.versionStore.storeVersion(newVersion);
        return newVersion;
    }

    public Version releaseVersion(Version version, boolean release) {
        this.releaseVersions(Collections.singleton(version), release);
        Version updatedVersion = this.getVersion(version.getId());
        if (release) {
            this.eventPublisher.publish((Object)new VersionReleaseEvent(updatedVersion));
        } else {
            this.eventPublisher.publish((Object)new VersionUnreleaseEvent(updatedVersion));
        }
        return updatedVersion;
    }

    public Collection<Version> releaseVersions(Collection<Version> versions, boolean release) {
        ArrayList versionsChanged = Lists.newArrayListWithCapacity((int)versions.size());
        for (Version version : versions) {
            this.validateReleaseParams(version, release);
            versionsChanged.add(new VersionBuilderImpl(version).released(release).build());
        }
        if (!versionsChanged.isEmpty()) {
            this.versionStore.storeVersions(versionsChanged);
        }
        return versionsChanged;
    }

    public void moveIssuesToNewVersion(List<Issue> issues, Version currentVersion, Version swapToVersion) throws IndexException {
        if (currentVersion != null && swapToVersion != null && !issues.isEmpty()) {
            this.nodeAssociationStore.swapAssociation(issues.stream().map(issue -> issue.getGenericValue()).collect(Collectors.toCollection(ArrayList::new)), "IssueFixVersion", ((VersionImpl)currentVersion).toGenericValue(), ((VersionImpl)swapToVersion).toGenericValue());
            this.issueIndexManager.reIndexIssueObjects(issues);
        }
    }

    public void archiveVersions(String[] idsToArchive, String[] idsToUnarchive) {
        Version version;
        ArrayList versionsChanged = Lists.newArrayListWithCapacity((int)idsToArchive.length);
        for (String anIdsToArchive : idsToArchive) {
            Long archiveId = new Long(anIdsToArchive);
            version = this.getVersion(archiveId);
            if (version == null || version.isArchived()) continue;
            versionsChanged.add(new VersionBuilderImpl(version).archived(true).build());
        }
        for (String anIdsToUnarchive : idsToUnarchive) {
            Long unArchiveId = new Long(anIdsToUnarchive);
            version = this.getVersion(unArchiveId);
            if (version == null || !version.isArchived()) continue;
            versionsChanged.add(new VersionBuilderImpl(version).archived(false).build());
        }
        if (!versionsChanged.isEmpty()) {
            this.versionStore.storeVersions(versionsChanged);
        }
    }

    public Version archiveVersion(Version version, boolean archive) {
        Version newVersion = new VersionBuilderImpl(version).archived(archive).build();
        this.versionStore.storeVersion(newVersion);
        Version updatedVersion = this.getVersion(version.getId());
        if (archive) {
            this.eventPublisher.publish((Object)new VersionArchiveEvent(updatedVersion));
        } else {
            this.eventPublisher.publish((Object)new VersionUnarchiveEvent(updatedVersion));
        }
        return updatedVersion;
    }

    public Version editVersionReleaseDate(Version version, Date duedate) {
        if (version == null) {
            throw new IllegalArgumentException("You must specify a valid version.");
        }
        if (version.getStartDate() != null && duedate != null && version.getStartDate().after(duedate)) {
            throw new IllegalArgumentException("Release date must be after the version start date");
        }
        Version newVersion = new VersionBuilderImpl(version).releaseDate(duedate).build();
        this.versionStore.storeVersion(newVersion);
        return newVersion;
    }

    public Version editVersionStartDate(Version version, Date startDate) {
        if (version == null) {
            throw new IllegalArgumentException("You must specify a valid version.");
        }
        if (startDate != null && version.getReleaseDate() != null && startDate.after(version.getReleaseDate())) {
            throw new IllegalArgumentException("Start date must be before the version release date");
        }
        Version newVersion = new VersionBuilderImpl(version).startDate(startDate).build();
        this.versionStore.storeVersion(newVersion);
        return newVersion;
    }

    public Version editVersionStartReleaseDate(Version version, Date startDate, Date releaseDate) {
        if (version == null) {
            throw new IllegalArgumentException("You must specify a valid version.");
        }
        if (startDate != null && releaseDate != null && startDate.after(releaseDate)) {
            throw new IllegalArgumentException("Start date must be before the version release date");
        }
        Version newVersion = new VersionBuilderImpl(version).startDate(startDate).releaseDate(releaseDate).build();
        this.versionStore.storeVersion(newVersion);
        return newVersion;
    }

    public boolean isVersionOverDue(Version version) {
        if (version.getReleaseDate() == null || version.isArchived() || version.isReleased()) {
            return false;
        }
        Calendar releaseDate = Calendar.getInstance();
        releaseDate.setTime(version.getReleaseDate());
        Calendar lastMidnight = Calendar.getInstance();
        lastMidnight.set(11, 0);
        lastMidnight.set(12, 0);
        lastMidnight.set(13, 0);
        lastMidnight.set(14, 0);
        return releaseDate.before(lastMidnight);
    }

    public Collection<Version> getVersionsUnarchived(Long projectId) {
        Iterable<Version> versions = this.versionStore.getVersionsByProject(projectId);
        return this.filterVersions(versions, (com.google.common.base.Predicate<Version>)Predicates.not(VersionPredicates.isArchived()));
    }

    @Nonnull
    private List<Version> filterVersions(@Nonnull Iterable<Version> versions, @Nonnull com.google.common.base.Predicate<Version> predicate) {
        return Lists.newArrayList((Iterable)Iterables.filter(versions, predicate));
    }

    public Collection<Version> getVersionsArchived(Project project) {
        Iterable<Version> versions = this.versionStore.getVersionsByProject(project.getId());
        return this.filterVersions(versions, VersionPredicates.isArchived());
    }

    public List<Version> getVersions(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        return ImmutableList.copyOf(this.versionStore.getVersionsByProject(projectId));
    }

    public List<Version> getVersions(Long projectId, boolean includeArchived) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        Iterable<Version> versions = this.versionStore.getVersionsByProject(projectId);
        com.google.common.base.Predicate predicate = Predicates.alwaysTrue();
        if (!includeArchived) {
            predicate = Predicates.not(VersionPredicates.isArchived());
        }
        return this.filterVersions(versions, (com.google.common.base.Predicate<Version>)predicate);
    }

    public List<Version> getVersions(Project project) {
        return this.getVersions(project.getId());
    }

    public Collection<Version> getVersionsByName(String versionName) {
        Assertions.notNull((String)"versionName", (Object)versionName);
        return ImmutableList.copyOf(this.versionStore.getVersionsByName(versionName));
    }

    public Collection<Version> getAffectedVersionsFor(Issue issue) {
        return this.getVersionsByIssue(issue.getGenericValue(), "IssueVersion");
    }

    public List<ChangeItemBean> updateIssueAffectsVersions(Issue issue, Collection<Version> newVersions) {
        return this.updateIssueValue(issue, newVersions, this.getAffectedVersionsFor(issue), NodeAssocationType.ISSUE_TO_AFFECTS_VERISON, "Version");
    }

    public List<ChangeItemBean> updateIssueFixVersions(Issue issue, Collection<Version> newValue) {
        return this.updateIssueValue(issue, newValue, this.getFixVersionsFor(issue), NodeAssocationType.ISSUE_TO_FIX_VERISON, "Fix Version");
    }

    private List<ChangeItemBean> updateIssueValue(Issue issue, Collection<Version> newVersions, Collection<Version> oldVersions, NodeAssocationType nodeAssocationType, String changeItemField) {
        if (newVersions == null) {
            newVersions = Collections.emptyList();
        }
        ArrayList<ChangeItemBean> changes = new ArrayList<ChangeItemBean>(newVersions.size());
        Collection oldVersionIds = (Collection)oldVersions.stream().map(Version::getId).collect(CollectorsUtil.toNewArrayListWithSizeOf(oldVersions));
        Collection newVersionIds = (Collection)newVersions.stream().map(Version::getId).collect(CollectorsUtil.toNewArrayListWithSizeOf(newVersions));
        newVersions.stream().filter(v -> !oldVersionIds.contains(v.getId())).forEach(v -> {
            this.nodeAssociationStore.createAssociation(nodeAssocationType, issue.getId(), v.getId());
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, v.getId().toString(), v.getName()));
        });
        oldVersions.stream().filter(v -> !newVersionIds.contains(v.getId())).forEach(v -> {
            this.nodeAssociationStore.removeAssociation(nodeAssocationType, issue.getId(), v.getId());
            changes.add(new ChangeItemBean("jira", changeItemField, v.getId().toString(), v.getName(), null, null));
        });
        return changes;
    }

    public Collection<Version> getFixVersionsFor(Issue issue) {
        return this.getVersionsByIssue(issue.getGenericValue(), "IssueFixVersion");
    }

    public Collection<Version> getAllVersions() {
        return ImmutableList.copyOf(this.versionStore.getAllVersions());
    }

    public Collection<Version> getAllVersionsForProjects(Collection<Project> projects, boolean includeArchived) {
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable<Object> allVersions = Collections.emptyList();
        for (Project project : projects) {
            Iterable<Version> projectVersions = this.versionStore.getVersionsByProject(project.getId());
            allVersions = Iterables.concat(allVersions, projectVersions);
        }
        com.google.common.base.Predicate predicate = Predicates.alwaysTrue();
        if (!includeArchived) {
            predicate = Predicates.not(VersionPredicates.isArchived());
        }
        return this.filterVersions(allVersions, (com.google.common.base.Predicate<Version>)predicate);
    }

    public Collection<Version> getAllVersionsReleased(boolean includeArchived) {
        com.google.common.base.Predicate predicate = VersionPredicates.isReleased();
        if (!includeArchived) {
            predicate = Predicates.and(predicate, (com.google.common.base.Predicate)Predicates.not(VersionPredicates.isArchived()));
        }
        return this.filterVersions(this.versionStore.getAllVersions(), (com.google.common.base.Predicate<Version>)predicate);
    }

    public Collection<Version> getAllVersionsUnreleased(boolean includeArchived) {
        com.google.common.base.Predicate predicate = Predicates.not(VersionPredicates.isReleased());
        if (!includeArchived) {
            predicate = Predicates.and((com.google.common.base.Predicate)predicate, (com.google.common.base.Predicate)Predicates.not(VersionPredicates.isArchived()));
        }
        return this.filterVersions(this.versionStore.getAllVersions(), (com.google.common.base.Predicate<Version>)predicate);
    }

    public void merge(ApplicationUser user, @Nonnull Version versionToDelete, @Nonnull Version versionToMergeTo) {
        boolean affectedIssues = this.swapOrRemoveVersionsFromIssues(user, versionToDelete, (Option<Version>)Option.some((Object)versionToMergeTo), (Option<Version>)Option.some((Object)versionToMergeTo));
        if (affectedIssues) {
            this.eventPublisher.publish((Object)new VersionMergeEvent(versionToMergeTo, versionToDelete));
        }
        this.deleteVersionWithoutPublishingAnEvent(versionToDelete);
        this.eventPublisher.publish((Object)VersionDeleteEvent.deletedAndMerged((Version)versionToDelete, (Version)versionToMergeTo));
    }

    public void deleteAndRemoveFromIssues(ApplicationUser user, @Nonnull Version versionToRemove) {
        this.swapOrRemoveVersionsFromIssues(user, versionToRemove, (Option<Version>)Option.none(), (Option<Version>)Option.none());
        this.deleteVersion(versionToRemove);
    }

    public void swapVersionForRelatedIssues(ApplicationUser user, Version version, Option<Version> affectsSwapVersion, Option<Version> fixSwapVersion) {
        boolean affectedIssues = this.swapOrRemoveVersionsFromIssues(user, version, affectsSwapVersion, fixSwapVersion);
        if (affectedIssues && fixSwapVersion.isDefined()) {
            this.eventPublisher.publish((Object)new VersionMergeEvent((Version)fixSwapVersion.get(), version));
        }
    }

    private boolean swapOrRemoveVersionsFromIssues(ApplicationUser user, Version version, Option<Version> affectsSwapVersion, Option<Version> fixSwapVersion) {
        Set<Long> issuesIds = this.getAllAssociatedIssueIds(version);
        for (Long issueId : issuesIds) {
            MutableIssue newIssue = this.issueManager.getIssueObject(issueId);
            newIssue.setAffectedVersions(this.getNewVersions(version, newIssue.getAffectedVersions(), affectsSwapVersion));
            newIssue.setFixVersions(this.getNewVersions(version, newIssue.getFixVersions(), fixSwapVersion));
            Issue updated = this.issueManager.updateIssue(user, newIssue, UpdateIssueRequest.builder().eventDispatchOption(EventDispatchOption.ISSUE_UPDATED).sendMail(false).build());
            try {
                this.issueIndexManager.reIndex(updated);
            }
            catch (IndexException e) {
                log.warn("Could not reindex issue with id '" + issueId + "' after swapping versions", (Throwable)e);
            }
        }
        return issuesIds.size() > 0;
    }

    private Set<Long> getAllAssociatedIssueIds(Version version) {
        HashSet issueIds = Sets.newHashSet();
        issueIds.addAll(this.getIssueIdsWithAffectsVersion(version));
        issueIds.addAll(this.getIssueIdsWithFixVersion(version));
        return issueIds;
    }

    private Set<Version> getNewVersions(final Version versionToRemove, Collection<Version> versions, final Option<Version> versionToSwap) {
        if (versionToSwap.isDefined()) {
            return Sets.newHashSet((Iterable)Iterables.transform(versions, (Function)new Function<Version, Version>(){

                public Version apply(Version input) {
                    return input.getId().equals(versionToRemove.getId()) ? (Version)versionToSwap.get() : input;
                }
            }));
        }
        return Sets.newHashSet((Iterable)Iterables.filter(versions, (com.google.common.base.Predicate)new com.google.common.base.Predicate<Version>(){

            public boolean apply(Version input) {
                return !input.getId().equals(versionToRemove.getId());
            }
        }));
    }

    protected Collection<Version> getVersionsByIssue(GenericValue issue, String relationName) {
        List<GenericValue> versionGVs = this.nodeAssociationStore.getSinksFromSource(issue, "Version", relationName);
        return Entity.VERSION.buildList(versionGVs);
    }

    public Collection<Version> getVersions(List<Long> ids) {
        ArrayList versions = Lists.newArrayListWithCapacity((int)ids.size());
        for (Long id : ids) {
            versions.add(this.getVersion(id));
        }
        return versions;
    }

    public Collection<Version> getVersionsUnreleased(Long projectId, boolean includeArchived) {
        Iterable<Version> versions = this.versionStore.getVersionsByProject(projectId);
        com.google.common.base.Predicate predicate = Predicates.not(VersionPredicates.isReleased());
        if (!includeArchived) {
            predicate = Predicates.and((com.google.common.base.Predicate)predicate, (com.google.common.base.Predicate)Predicates.not(VersionPredicates.isArchived()));
        }
        return this.filterVersions(versions, (com.google.common.base.Predicate<Version>)predicate);
    }

    public Collection<Version> getVersionsReleased(Long projectId, boolean includeArchived) {
        Iterable<Version> versions = this.versionStore.getVersionsByProject(projectId);
        com.google.common.base.Predicate predicate = VersionPredicates.isReleased();
        if (!includeArchived) {
            predicate = Predicates.and(predicate, (com.google.common.base.Predicate)Predicates.not(VersionPredicates.isArchived()));
        }
        return this.filterVersions(versions, predicate);
    }

    public Collection<Version> getVersionsReleasedDesc(Long projectId, boolean includeArchived) {
        ArrayList<Version> released = new ArrayList<Version>(this.getVersionsReleased(projectId, includeArchived));
        Collections.reverse(released);
        return released;
    }

    public Version getVersion(Long id) {
        return this.versionStore.getVersion(id);
    }

    public Version getVersion(Long projectId, String versionName) {
        Iterable versions = Iterables.filter(this.versionStore.getVersionsByProject(projectId), NamedPredicates.equalsIgnoreCase(versionName));
        return (Version)Iterables.getFirst((Iterable)versions, null);
    }

    protected IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    public Collection<Version> getOtherVersions(Version version) {
        ArrayList<Version> otherVersions = new ArrayList<Version>(this.getAllVersions(version));
        otherVersions.remove(version);
        return otherVersions;
    }

    public Collection<Version> getOtherUnarchivedVersions(Version version) {
        ArrayList<Version> otherUnarchivedVersions = new ArrayList<Version>(this.getVersionsUnarchived(version.getProjectId()));
        otherUnarchivedVersions.remove(version);
        return otherUnarchivedVersions;
    }

    public Collection<Issue> getIssuesWithFixVersion(Version version) {
        Collection<Long> issueIds = this.getIssueIdsWithFixVersion(version);
        ArrayList<Issue> issues = new ArrayList<Issue>(issueIds.size());
        for (Long issueId : issueIds) {
            issues.add((Issue)this.issueManager.getIssueObject(issueId));
        }
        return issues;
    }

    public Collection<Issue> getIssuesWithAffectsVersion(Version version) {
        Collection<Long> issueIds = this.getIssueIdsWithAffectsVersion(version);
        ArrayList<Issue> issues = new ArrayList<Issue>(issueIds.size());
        for (Long issueId : issueIds) {
            issues.add((Issue)this.issueManager.getIssueObject(issueId));
        }
        return issues;
    }

    public Collection<Long> getIssueIdsWithAffectsVersion(@Nonnull Version version) {
        return this.nodeAssociationStore.getSourceIdsFromSink(NodeAssocationType.ISSUE_TO_AFFECTS_VERISON, version.getId());
    }

    public Collection<Long> getIssueIdsWithFixVersion(@Nonnull Version version) {
        return this.nodeAssociationStore.getSourceIdsFromSink(NodeAssocationType.ISSUE_TO_FIX_VERISON, version.getId());
    }

    private List<Version> getAllVersions(Version version) {
        return this.getVersions(version.getProjectId());
    }

    public boolean isDuplicateName(Version currentVersion, String name) {
        for (Version version : currentVersion.getProjectObject().getVersions()) {
            if (currentVersion.getId().equals(version.getId()) || !name.trim().equalsIgnoreCase(version.getName())) continue;
            return true;
        }
        return false;
    }

    private void validateReleaseParams(Version version, boolean release) {
        if (version == null && release) {
            throw new IllegalArgumentException("Please select a version to release");
        }
        if (version == null && !release) {
            throw new IllegalArgumentException("Please select a version to unrelease.");
        }
    }

    private Version getLastVersion(Long projectId) {
        long maxSequence = 0L;
        Version lastVersion = null;
        for (Version version : this.getVersions(projectId)) {
            if (version.getSequence() == null || version.getSequence() < maxSequence) continue;
            maxSequence = version.getSequence();
            lastVersion = version;
        }
        return lastVersion;
    }

    private long getMaxVersionSequence(Long projectId) {
        long maxSequence = 1L;
        for (Version version : this.getVersions(projectId)) {
            if (version.getSequence() == null || version.getSequence() < maxSequence) continue;
            maxSequence = version.getSequence() + 1L;
        }
        return maxSequence;
    }

    public void storeReorderedVersionList(List<Version> versions) {
        ArrayList versionsChanged = Lists.newArrayListWithCapacity((int)versions.size());
        for (int i = 0; i < versions.size(); ++i) {
            long expectedSequenceNumber = (long)i + 1L;
            Version version = versions.get(i);
            if (expectedSequenceNumber == version.getSequence()) continue;
            versionsChanged.add(new VersionBuilderImpl(version).sequence(expectedSequenceNumber).build());
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    void reorderVersionsInProject(Version version) {
        this.storeReorderedVersionList(this.getAllVersions(version));
    }
}

