/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.filter.SecurityFilter;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSecurityFilter
extends SecurityFilter {
    private static final Logger log = LoggerFactory.getLogger(JiraSecurityFilter.class);

    public void init(FilterConfig config) {
        log.debug("Initing JIRA security filter");
        this.init(config, true);
        log.debug("JIRA security filter inited");
    }

    protected void init(FilterConfig config, boolean startupCheck) {
        if (!startupCheck || JiraStartupChecklist.startupOK()) {
            super.init(config);
        }
    }

    protected String getLoginUrl(HttpServletRequest request, Set<String> missingRoles) {
        UserRole userRole = null;
        if (missingRoles.contains(Permissions.getShortName((int)44))) {
            userRole = UserRole.SYSADMIN;
        } else if (missingRoles.contains(Permissions.getShortName((int)0))) {
            userRole = UserRole.ADMIN;
        }
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        String loginURL = securityConfig.getLoginURL(userRole != null, false);
        if (userRole != null) {
            loginURL = loginURL.replaceAll("\\$\\{userRole\\}", userRole.toString());
        }
        return RedirectUtils.getLoginURL((String)loginURL, (HttpServletRequest)request);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (ComponentAccessor.getComponentSafely(LoginManager.class).isPresent()) {
            super.doFilter(req, res, chain);
        } else {
            JiraSecurityFilter.rejectWith503((HttpServletRequest)req, res);
        }
    }

    private static void rejectWith503(HttpServletRequest req, ServletResponse res) throws IOException {
        log.warn("Rejecting security-sensitive request that bypassed Johnson filter: {}", (Object)req.getRequestURI());
        ServiceUnavailableResponder.respondWithEmpty503(res);
    }
}

