/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.DefaultIPMatcher;
import com.atlassian.security.auth.trustedapps.DefaultURLMatcher;
import com.atlassian.security.auth.trustedapps.IPMatcher;
import com.atlassian.security.auth.trustedapps.URLMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class TrustedApplicationUtil {
    static URLMatcher getURLMatcher(String urlMatch) {
        return new DefaultURLMatcher(TrustedApplicationUtil.getLines(urlMatch));
    }

    static IPMatcher getIPMatcher(String string) {
        return new DefaultIPMatcher(TrustedApplicationUtil.getLines(string));
    }

    public static Set<String> getLines(String ipMatch) {
        if (StringUtils.isBlank((String)ipMatch)) {
            return Collections.emptySet();
        }
        BufferedReader reader = new BufferedReader(new StringReader(ipMatch));
        LinkedHashSet<String> ipLines = new LinkedHashSet<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                ipLines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ipLines;
    }

    static String getMultilineString(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        Iterator<String> it = set.iterator();
        StringBuilder result = new StringBuilder(it.next());
        while (it.hasNext()) {
            result.append("\n");
            result.append(it.next());
        }
        return result.toString();
    }

    static String canonicalize(String string) {
        if (string == null) {
            return null;
        }
        return TrustedApplicationUtil.getMultilineString(TrustedApplicationUtil.getLines(string));
    }

    static String canonicalize(Iterable<String> urlPatterns) {
        return StringUtils.join(urlPatterns.iterator(), (String)"\n");
    }

    private TrustedApplicationUtil() {
    }
}

