/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.SqlPredicates;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.security.groups.UserIsNotShadowedPredicate;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class FilterUsersInAllGroupsQueryCallback
implements QueryCallback<List<Result>> {
    private static final int SQL_SERVER_USE_LITERALS_THRESHOLD = 1900;
    private final Long directoryId;
    private final UserIsNotShadowedPredicate userIsNotShadowedPredicate;
    private final Collection<String> lowerCaseGroupNames;
    private final Collection<String> lowerCaseUserNames;
    private final DatabaseConfig dbConfig;
    private final SqlPredicates sqlPredicates;

    public FilterUsersInAllGroupsQueryCallback(Long directoryId, Collection<Long> higherPriorityDirectoryIds, Collection<String> userNames, Collection<String> groupNames, DatabaseConfig dbConfig) {
        this.directoryId = directoryId;
        this.userIsNotShadowedPredicate = new UserIsNotShadowedPredicate(higherPriorityDirectoryIds);
        this.lowerCaseGroupNames = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        this.lowerCaseUserNames = userNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        this.dbConfig = dbConfig;
        this.sqlPredicates = new SqlPredicates(dbConfig);
    }

    @Override
    public List<Result> runQuery(DbConnection dbConnection) {
        QMembership m = new QMembership("m");
        QUser u = new QUser("u");
        BooleanExpression userIsNotShadowed = this.userIsNotShadowedPredicate.apply(u);
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)u)).innerJoin((EntityPath)m)).on((Predicate)u.lowerUserName.eq((Expression)m.lowerChildName))).where((Predicate)u.active.eq((Object)1).and((Predicate)u.directoryId.eq((Object)this.directoryId)).and((Predicate)userIsNotShadowed).and((Predicate)m.membershipType.eq((Object)"GROUP_USER")).and((Predicate)m.directoryId.eq((Object)this.directoryId)).and(this.sqlPredicates.partitionedIn(m.lowerChildName, this.lowerCaseUserNames)).and(this.sqlPredicates.partitionedIn(m.lowerParentName, this.lowerCaseGroupNames)))).orderBy(new OrderSpecifier[]{u.lowerUserName.asc(), m.lowerChildName.asc()});
        if (this.dbConfig.isSqlServer() && this.lowerCaseGroupNames.size() > 1900) {
            query.setUseLiterals(true);
        }
        return query.list(new Expression[]{u.userName, m.parentName}).stream().map(tuple -> new Result((String)tuple.get((Expression)u.userName), (String)tuple.get((Expression)m.parentName))).collect(Collectors.toList());
    }

    public static class Result {
        private final String userName;
        private final String groupName;

        public Result(String userName, String groupName) {
            this.userName = userName;
            this.groupName = groupName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

