/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicReference;

public class RecoveryLoginStore
implements LoginStore {
    private final RecoveryMode mode;
    private final LoginStore delegate;
    private final Clock clock;
    private final AtomicReference<LoginInfo> recoveryInfo = new AtomicReference();

    public RecoveryLoginStore(RecoveryMode mode, LoginStore delegate, Clock clock) {
        this.mode = (RecoveryMode)Assertions.notNull((String)"mode", (Object)mode);
        this.delegate = (LoginStore)Assertions.notNull((String)"delegate", (Object)delegate);
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
    }

    @Override
    public LoginInfo getLoginInfo(ApplicationUser user) {
        if (this.mode.isRecoveryUser(user)) {
            LoginInfo info = this.recoveryInfo.get();
            while (info == null) {
                this.recoveryInfo.compareAndSet(null, LoginInfoImpl.builder().build());
                info = this.recoveryInfo.get();
            }
            return info;
        }
        return this.delegate.getLoginInfo(user);
    }

    @Override
    public LoginInfo recordLoginAttempt(ApplicationUser user, final boolean authenticated) {
        if (this.mode.isRecoveryUser(user)) {
            return this.setRecoveryInfo(new Function<LoginInfo, LoginInfo>(){

                public LoginInfo apply(LoginInfo loginInfo) {
                    LoginInfoImpl.Builder builder = LoginInfoImpl.builder(loginInfo);
                    if (authenticated) {
                        builder.succeededAt(RecoveryLoginStore.this.now());
                    } else {
                        builder.failedAt(RecoveryLoginStore.this.now());
                    }
                    return builder.build();
                }
            });
        }
        return this.delegate.recordLoginAttempt(user, authenticated);
    }

    @Override
    public long getMaxAuthenticationAttemptsAllowed() {
        return this.delegate.getMaxAuthenticationAttemptsAllowed();
    }

    @Override
    public void resetFailedLoginCount(ApplicationUser user) {
        if (this.mode.isRecoveryUser(user)) {
            this.setRecoveryInfo(new Function<LoginInfo, LoginInfo>(){

                public LoginInfo apply(LoginInfo loginInfo) {
                    return LoginInfoImpl.builder(loginInfo).setLoginCount(0L).build();
                }
            });
        } else {
            this.delegate.resetFailedLoginCount(user);
        }
    }

    private LoginInfo setRecoveryInfo(Function<LoginInfo, LoginInfo> transform) {
        LoginInfo newInfo;
        LoginInfo oldInfo;
        while (!this.recoveryInfo.compareAndSet(oldInfo = this.recoveryInfo.get(), newInfo = (LoginInfo)transform.apply((Object)oldInfo))) {
        }
        return newInfo;
    }

    private long now() {
        return this.clock.getCurrentDate().getTime();
    }
}

