/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.plugin.permission.GlobalPermissionModuleDescriptor;
import com.atlassian.jira.security.plugin.GlobalPermissionTypesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@EventComponent
public class GlobalPermissionTypesManagerImpl
implements Startable,
GlobalPermissionTypesManager {
    private final DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> pluginModuleTracker;
    private final ResettableLazyReference<Map<String, GlobalPermissionType>> globalPermissions;
    private final ApplicationRoleManager applicationRoleManager;

    public GlobalPermissionTypesManagerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull PluginEventManager pluginEventManager, @Nonnull ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, GlobalPermissionModuleDescriptor.class, (PluginModuleTracker.Customizer)new PluginModuleTracker.Customizer<Void, GlobalPermissionModuleDescriptor>(){

            public void removed(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
            }

            public GlobalPermissionModuleDescriptor adding(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
                return descriptor;
            }
        });
        this.globalPermissions = new GlobalPermissionsResettableLazyReference(this.pluginModuleTracker.getModuleDescriptors());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.globalPermissions.reset();
    }

    public void start() throws Exception {
        this.globalPermissions.reset();
    }

    @Override
    public Collection<GlobalPermissionType> getAll() {
        return (Collection)((Map)this.globalPermissions.get()).values().stream().filter(gpt -> !gpt.getKey().equals(GlobalPermissionKey.USE.getKey())).collect(CollectorsUtil.toImmutableSet());
    }

    @Override
    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull String permissionKey) {
        return Option.option(((Map)this.globalPermissions.get()).get(permissionKey));
    }

    @Override
    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull GlobalPermissionKey permissionKey) {
        return this.getGlobalPermission(permissionKey.getKey());
    }

    @VisibleForTesting
    DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> getPluginModuleTracker() {
        return this.pluginModuleTracker;
    }

    private static class GlobalPermissionsResettableLazyReference
    extends ResettableLazyReference<Map<String, GlobalPermissionType>> {
        private final Iterable<GlobalPermissionModuleDescriptor> moduleDescriptors;

        private GlobalPermissionsResettableLazyReference(Iterable<GlobalPermissionModuleDescriptor> moduleDescriptors) {
            this.moduleDescriptors = moduleDescriptors;
        }

        protected Map<String, GlobalPermissionType> create() {
            HashMap permissions = Maps.newHashMap();
            for (GlobalPermissionModuleDescriptor moduleDescriptor : this.moduleDescriptors) {
                GlobalPermissionType globalPermissionType = this.createGlobalPermission(moduleDescriptor);
                String key = moduleDescriptor.getKey();
                permissions.put(key, globalPermissionType);
            }
            return permissions;
        }

        private GlobalPermissionType createGlobalPermission(GlobalPermissionModuleDescriptor descriptor) {
            return new GlobalPermissionType(descriptor.getKey(), descriptor.getI18nNameKey(), descriptor.getDescriptionI18nKey(), descriptor.isAnonymousAllowed());
        }
    }
}

